<?php

class stPaypalFrontendActions extends stActions
{

   protected $order = null;
   protected $paypalCaller = null;
   protected $orderPayment = null;

   public function executeSetExpressCheckout()
   {
      $this->smarty = new stSmarty('stPaypalFrontend');

      $order = $this->getOrder();

      $controller = $this->getController();

      $paypal = $this->getPaypalCallerService();

      $request = new stPaypalCallerRequest();

      $request->setPaymentAction('Sale');

      $request->setLandingPage('Billing');

      $request->setSolutionType('Sole');

      $request->setAllowNote(false);

      $request->setNoShipping(true);

      $request->setReturnUrl($controller->genUrl('@stPaypalDoExpressCheckout?order_id=' . $order->getId() . '&order_hash=' . $order->getHashCode(), true));

      $request->setCancelUrl($controller->genUrl('@stOrderSummary?id=' . $order->getId() . '&hash_code=' . $order->getHashCode(), true));

      $request->setLocaleCode($this->getUser()->getCulture());

      $request->setCurrencyCode($order->getOrderCurrency()->getShortcut());

      $this->processOrderBillingAddress($request);

      $this->processOrderSummary($request);

      $this->paypal_response = $paypal->setExpressCheckout($request);

      $this->postExecute();

      if ($this->paypal_response->isSuccessful())
      {
         $this->redirect($paypal->getExpressCheckoutUrl($this->paypal_response->getToken()));
      }
      else
      {
         if (sfConfig::get('sf_debug'))
         {
            throw new stPaypalCallerException(var_export($this->paypal_response->getItems(), true));
         }
      }
   }

   /**
    *
    * @return <type>
    */
   public function executeIpn()
   {
      $request = $this->getRequest();

      $parameters = $request->getParameterHolder()->getAll();

      unset($parameters['module']);

      unset($parameters['action']);

      unset($parameters['order_id']);

      unset($parameters['order_hash']);

      if (isset($parameters['test_ipn']) && $parameters['test_ipn'])
      {
         $response = stPaypalCallerService::curlCall('https://www.sandbox.paypal.com/cgi-bin/webscr?cmd=_notify-validate', $parameters);
      }
      else
      {
         $response = stPaypalCallerService::curlCall('https://www.paypal.com/cgi-bin/webscr?cmd=_notify-validate', $parameters);
      }

      if ($response == 'VERIFIED')
      {
         if ($parameters['payment_status'] == 'Completed')
         {
            $order = $this->getOrder();

            if ($this->validatePayment($order, $parameters['mc_gross']))
            {
               $order_payment = $this->getOrderPaymentByPaymentHash('PAYPAL-' . $parameters['txn_id']);

               if ($order_payment && !$order_payment->getStatus())
               {
                  $order_payment->setStatus(true);

                  $order_payment->save();
               }
            }
         }
      }

      return sfView::HEADER_ONLY;
   }

   /**
    *
    * Finalizacja płatności Paypal Express Checkout
    *
    */
   public function executeDoExpressCheckout()
   {
      $this->smarty = new stSmarty('stPaypalFrontend');

      $this->order_id = $this->getRequestParameter('order_id');

      $this->hash_code = $this->getRequestParameter('order_hash');

      $token = $this->getRequestParameter('token');

      $controller = $this->getController();

      $paypal = $this->getPaypalCallerService();

      $response = $this->getExpressCheckoutDetails($token);

      $request = new stPaypalCallerRequest();

      $request->setPayerId($response->getPayerId());

      $request->setToken($token);

      $request->setPaymentAction('Sale');

      $request->setButtonSource('Sote_ShoppingCart_EC_PL');

      $request->setCurrencyCode($response->getCurrencyCode());

      $request->setNotifyUrl($controller->genUrl('@stPaypalIpn?order_id=' . $this->order_id . '&order_hash=' . $this->hash_code, true));

      $request->setAmt($response->getAmt());

      $request->setItemAmt($response->getItemAmt());
            
      $request->setItems($response->getItems());

      $this->paypal_response = $paypal->doExpressCheckoutPayment($request);

      if ($this->paypal_response->isSuccessful())
      {
         $order_payment = $this->getOrderPaymentByOrder($this->order_id, $this->order_hash);

         if ($this->paypal_response->getPaymentStatus() == 'Completed')
         {
            $order_payment->setStatus(true);
         }

         $order_payment->setHash('PAYPAL-' . $this->paypal_response->getTransactionId());

         $order_payment->save();
      }
      else
      {
         if (sfConfig::get('sf_debug'))
         {
            throw new stPaypalCallerException($response->getItemAmt() . ':' . $response->getShippingAmt() . ':' . $response->getAmt() . var_export($this->paypal_response->getItems(), true));
         }
      }
   }

   /**
    *
    * Wykonuje żądanie o szczegółowe informacje transakcji Paypal
    *
    * @param string $token Unikalny klucz otrzymany z Paypal
    * @return stPaypalCallerResponse Odpowiedź
    */
   protected function getExpressCheckoutDetails($token)
   {
      $paypal = $this->getPaypalCallerService();

      $request = new stPaypalCallerRequest();

      $request->setToken($token);

      return $paypal->getExpressCheckoutDetails($request);
   }

   /**
    *
    * Uzupełnia żądanie o dane produktów z zamówienia
    *
    * @param stPaypalCallerRequest $request Żądanie API
    */
   protected function processOrderProducts($request)
   {
      $order_products = $this->getOrder()->getOrderProducts();

      foreach ($order_products as $index => $order_product)
      {
         $item = new stPaypalCallerItem($index);

         $item->setName($order_product->getName());

         $item->setNumber($order_product->getCode());

         $item->setAmt($order_product->getPrice(false, true));

         $item->setQty($order_product->getQuantity());

         $item->setTaxAmt($order_product->getTaxAmount(true));

         if ($order_product->getOptions())
         {
            $item->setDesc(implode(', ', $order_product->getOptions(true)));
         }

         $request->addItem($item);

         $this->itemAmount += $order_product->getTotalAmount(false, true);

         $this->itemTaxAmount += $order_product->getTotalTaxAmount(true);
      }
   }

   /**
    *
    * Uzupełnia żądanie o dane podsumowania z zamówienia
    *
    * @param stPaypalCallerRequest $request Żądanie API
    */
   protected function processOrderSummary($request)
   {
      $order = $this->getOrder();

      $item = new stPaypalCallerItem(0);

      $item->setName($this->getContext()->getI18N()->__('Zamówienie numer %number%', array('%number%' => $order->getNumber()), 'stOrder'));

      $item->setAmt($order->getUnpaidAmount());

      $item->setQty(1);

      $request->addItem($item);

      $unpaid_amount = $order->getUnpaidAmount();
      
      $request->setAmt($unpaid_amount);
      
      $request->setItemAmt($unpaid_amount);
   }

   /**
    *
    * Uzupełnia żądanie o dane billingowe z zamówienia
    *
    * @param stPaypalCallerRequest $request Żądanie API
    */
   protected function processOrderBillingAddress($request)
   {
      $billing = $this->order->getOrderUserDataBilling();

      $request->setEmail($this->order->getGuardUser()->getUsername());

      if ($billing)
      {
         $request->setShipToName($billing->getFullName());

         $request->setShipToStreet($billing->getAddress());

         if ($billing->getAddressMore())
         {
            $request->setShipToStreet2($billing->getAddressMore());
         }

         $request->setShipToCity($billing->getTown());

         $request->setShipToZip($billing->getCode());

         $request->setShipToPhoneNum($billing->getPhone());

         $request->setShipToCountryCode($billing->getCountry()->getIsoA2());
      }
   }

   /**
    * Aktualizuje status płatności
    */
   protected function updatePaymentStatus($paypal_status, $payment_hash)
   {
      $payment = $this->getOrderPaymentByPaymentHash($payment_hash);

      if ($paypal_status == 'Completed' && $payment->getStatus() == false)
      {
         $payment->setStatus(true);

         $payment->save();
      }
   }

   protected function validatePayment($order, $pay_amount)
   {
      $pay_amount = stCurrency::round($pay_amount);

      $order_amount = stCurrency::round(stPayment::getUnpayedAmountByOrder($order));

      return $order_amount == $pay_amount;
   }

   /**
    *
    * Pobiera aktualne zamówienie
    *
    * @return Order
    */
   protected function getOrder()
   {
      if (is_null($this->order))
      {
         $c = new Criteria();

         $c->add(OrderPeer::ID, $this->getRequestParameter('order_id'));

         $c->add(OrderPeer::HASH_CODE, $this->getRequestParameter('order_hash'));

         $c->setLimit(1);

         $tmp = OrderPeer::doSelectJoinAll($c);

         if (!empty($tmp))
         {
            $this->order = $tmp[0];
         }
      }

      return $this->order;
   }

   /**
    *
    * Pobiera płatność dla zamówienia
    *
    * @param int $payment_hash Unikalny kod płatności
    * @return Payment
    */
   protected function getOrderPaymentByOrder($order_id, $order_hash)
   {
      $c = new Criteria();

      $c->add(OrderPeer::ID, $this->getRequestParameter('order_id'));

      $c->add(OrderPeer::HASH_CODE, $this->getRequestParameter('order_hash'));

      $c->addJoin(OrderHasPaymentPeer::PAYMENT_ID, PaymentPeer::ID);

      $c->addJoin(OrderHasPaymentPeer::ORDER_ID, OrderPeer::ID);

      return PaymentPeer::doSelectOne($c);
   }

   protected function getOrderPaymentByPaymentHash($payment_hash)
   {
      $c = new Criteria();

      $c->add(PaymentPeer::HASH, $payment_hash);

      return PaymentPeer::doSelectOne($c);
   }

   /**
    *
    * Pobiera instancje stPaypalCallerService
    *
    * @return stPaypalCallerService
    */
   protected function getPaypalCallerService()
   {
      if (is_null($this->paypalCaller))
      {
         $config = stConfig::getInstance($this->getContext(), 'stPaypal');

         $this->paypalCaller = stPaypalCallerService::getInstance();

         if ($config->get('test_mode'))
         {
            $this->paypalCaller->setApiUsername($config->get('sandbox_api_username'));

            $this->paypalCaller->setApiPassword($config->get('sandbox_api_password'));

            $this->paypalCaller->setApiSignature($config->get('sandbox_api_signature'));

            $this->paypalCaller->setApiEnvironment('sandbox');
         }
         else
         {
            $this->paypalCaller->setApiUsername($config->get('live_api_username'));

            $this->paypalCaller->setApiPassword($config->get('live_api_password'));

            $this->paypalCaller->setApiSignature($config->get('live_api_signature'));
         }
      }

      return $this->paypalCaller;
   }

}