<?php
/**
 * SOTESHOP/stPositioningPlugin
 *
 * Ten plik należy do aplikacji stPositioningPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPositioningPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stProductMetaTagsGenerator.class.php 3628 2010-02-22 09:24:13Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stProductMetaTagsGenerator
 *
 * @package     stPositioningPlugin
 * @subpackage  libs
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */
class stProductMetaTagsGenerator extends stMetaTagsGenerator
{
    /**
     * Generowanie meta tagów
     *
     * @param Product $product
     */
    public function generate($product)
    {
        if (is_object($product))
        {
            $keywords = array($product->getName());
            $newKeywords = array();

            $c = new Criteria();
            $c->add(ProductHasCategoryPeer::PRODUCT_ID, $product->getId());
            $c->addJoin(ProductHasCategoryPeer::CATEGORY_ID, CategoryPeer::ID);
            $categories = CategoryPeer::doSelect($c);

            foreach ($categories as $category)
            {
                if(is_object($category))
                {
                    foreach ($category->getPath() as $categoryPath) $keywords[] = $categoryPath->getName();
                    $keywords[] = $category->getName();
                }
            }

            if (is_object($product->getProducer())) $keywords[] = $product->getProducer()->getName();

            foreach ($keywords as $keyword)
            {
                if ($keyword != stLocale::removeLocalSymbols($keyword, sfContext::getInstance()->getUser()->getCulture()))
                {
                    $newKeywords[] = stLocale::removeLocalSymbols($keyword, sfContext::getInstance()->getUser()->getCulture());
                }
            }
            $keywords = array_merge($keywords, $newKeywords);
            $keywords = array_unique($keywords);
            
            $this->title = $product->getName()." - ".$this->getTitle();
            $this->keywords = implode(', ',$keywords);

            if ($product->getShortDescription()) $this->description = strip_tags($product->getShortDescription());
            else $this->description = $this->getDescription();
        }
    }
}