<?php


abstract class BaseProductGroupHasPositioning extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $product_group_id;


	
	protected $opt_title;


	
	protected $opt_keywords;


	
	protected $opt_description;


	
	protected $opt_type;

	
	protected $aProductGroup;

	
	protected $collProductGroupHasPositioningI18ns;

	
	protected $lastProductGroupHasPositioningI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getProductGroupId()
    {

            return $this->product_group_id;
    }

    
    public function getOptTitle()
    {

            return $this->opt_title;
    }

    
    public function getOptKeywords()
    {

            return $this->opt_keywords;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getOptType()
    {

            return $this->opt_type;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductGroupHasPositioningPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductGroupHasPositioningPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::ID;
        }

	} 
	
	public function setProductGroupId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_group_id !== $v) {
          $this->product_group_id = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID;
        }

		if ($this->aProductGroup !== null && $this->aProductGroup->getId() !== $v) {
			$this->aProductGroup = null;
		}

	} 
	
	public function setOptTitle($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_title !== $v) {
          $this->opt_title = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::OPT_TITLE;
        }

	} 
	
	public function setOptKeywords($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_keywords !== $v) {
          $this->opt_keywords = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::OPT_KEYWORDS;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setOptType($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_type !== $v) {
          $this->opt_type = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningPeer::OPT_TYPE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioning.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->product_group_id = $rs->getInt($startcol + 3);

      $this->opt_title = $rs->getString($startcol + 4);

      $this->opt_keywords = $rs->getString($startcol + 5);

      $this->opt_description = $rs->getString($startcol + 6);

      $this->opt_type = $rs->getInt($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioning.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductGroupHasPositioning object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioning:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupHasPositioningPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductGroupHasPositioningPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioning:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioning.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductGroupHasPositioning:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductGroupHasPositioningPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductGroupHasPositioningPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupHasPositioningPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioning.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioning:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProductGroup !== null) {
				if ($this->aProductGroup->isModified() || $this->aProductGroup->getCurrentProductGroupI18n()->isModified()) {
					$affectedRows += $this->aProductGroup->save($con);
				}
				$this->setProductGroup($this->aProductGroup);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductGroupHasPositioningPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductGroupHasPositioningPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductGroupHasPositioningI18ns !== null) {
				foreach($this->collProductGroupHasPositioningI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProductGroup !== null) {
				if (!$this->aProductGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductGroup->getValidationFailures());
				}
			}


			if (($retval = ProductGroupHasPositioningPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductGroupHasPositioningI18ns !== null) {
					foreach($this->collProductGroupHasPositioningI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupHasPositioningPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getProductGroupId();
				break;
			case 4:
				return $this->getOptTitle();
				break;
			case 5:
				return $this->getOptKeywords();
				break;
			case 6:
				return $this->getOptDescription();
				break;
			case 7:
				return $this->getOptType();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupHasPositioningPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getProductGroupId(),
			$keys[4] => $this->getOptTitle(),
			$keys[5] => $this->getOptKeywords(),
			$keys[6] => $this->getOptDescription(),
			$keys[7] => $this->getOptType(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupHasPositioningPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setProductGroupId($value);
				break;
			case 4:
				$this->setOptTitle($value);
				break;
			case 5:
				$this->setOptKeywords($value);
				break;
			case 6:
				$this->setOptDescription($value);
				break;
			case 7:
				$this->setOptType($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupHasPositioningPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setProductGroupId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptTitle($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptKeywords($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptDescription($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptType($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductGroupHasPositioningPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductGroupHasPositioningPeer::CREATED_AT)) $criteria->add(ProductGroupHasPositioningPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::UPDATED_AT)) $criteria->add(ProductGroupHasPositioningPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::ID)) $criteria->add(ProductGroupHasPositioningPeer::ID, $this->id);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID)) $criteria->add(ProductGroupHasPositioningPeer::PRODUCT_GROUP_ID, $this->product_group_id);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::OPT_TITLE)) $criteria->add(ProductGroupHasPositioningPeer::OPT_TITLE, $this->opt_title);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::OPT_KEYWORDS)) $criteria->add(ProductGroupHasPositioningPeer::OPT_KEYWORDS, $this->opt_keywords);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::OPT_DESCRIPTION)) $criteria->add(ProductGroupHasPositioningPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(ProductGroupHasPositioningPeer::OPT_TYPE)) $criteria->add(ProductGroupHasPositioningPeer::OPT_TYPE, $this->opt_type);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductGroupHasPositioningPeer::DATABASE_NAME);

		$criteria->add(ProductGroupHasPositioningPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setProductGroupId($this->product_group_id);

		$copyObj->setOptTitle($this->opt_title);

		$copyObj->setOptKeywords($this->opt_keywords);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setOptType($this->opt_type);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductGroupHasPositioningI18ns() as $relObj) {
				$copyObj->addProductGroupHasPositioningI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductGroupHasPositioningPeer();
		}
		return self::$peer;
	}

	
	public function setProductGroup($v)
	{


		if ($v === null) {
			$this->setProductGroupId(NULL);
		} else {
			$this->setProductGroupId($v->getId());
		}


		$this->aProductGroup = $v;
	}


	
	public function getProductGroup($con = null)
	{
		if ($this->aProductGroup === null && ($this->product_group_id !== null)) {
						$this->aProductGroup = ProductGroupPeer::retrieveByPK($this->product_group_id, $con);

			
		}
		return $this->aProductGroup;
	}

	
	public function initProductGroupHasPositioningI18ns()
	{
		if ($this->collProductGroupHasPositioningI18ns === null) {
			$this->collProductGroupHasPositioningI18ns = array();
		}
	}

	
	public function getProductGroupHasPositioningI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductGroupHasPositioningI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductGroupHasPositioningI18ns = array();
			} else {

				$criteria->add(ProductGroupHasPositioningI18nPeer::ID, $this->getId());

				ProductGroupHasPositioningI18nPeer::addSelectColumns($criteria);
				$this->collProductGroupHasPositioningI18ns = ProductGroupHasPositioningI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductGroupHasPositioningI18nPeer::ID, $this->getId());

				ProductGroupHasPositioningI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductGroupHasPositioningI18nCriteria) || !$this->lastProductGroupHasPositioningI18nCriteria->equals($criteria)) {
					$this->collProductGroupHasPositioningI18ns = ProductGroupHasPositioningI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductGroupHasPositioningI18nCriteria = $criteria;
		return $this->collProductGroupHasPositioningI18ns;
	}

	
	public function countProductGroupHasPositioningI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductGroupHasPositioningI18nPeer::ID, $this->getId());

		return ProductGroupHasPositioningI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductGroupHasPositioningI18n(ProductGroupHasPositioningI18n $l)
	{
		$this->collProductGroupHasPositioningI18ns[] = $l;
		$l->setProductGroupHasPositioning($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getTitle()
  {
    $obj = $this->getCurrentProductGroupHasPositioningI18n();

    return ($obj ? $obj->getTitle() : null);
  }

  public function setTitle($value)
  {
    $this->getCurrentProductGroupHasPositioningI18n()->setTitle($value);
  }

  public function getKeywords()
  {
    $obj = $this->getCurrentProductGroupHasPositioningI18n();

    return ($obj ? $obj->getKeywords() : null);
  }

  public function setKeywords($value)
  {
    $this->getCurrentProductGroupHasPositioningI18n()->setKeywords($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentProductGroupHasPositioningI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentProductGroupHasPositioningI18n()->setDescription($value);
  }

  public function getType()
  {
    $obj = $this->getCurrentProductGroupHasPositioningI18n();

    return ($obj ? $obj->getType() : null);
  }

  public function setType($value)
  {
    $this->getCurrentProductGroupHasPositioningI18n()->setType($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductGroupHasPositioningI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductGroupHasPositioningI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductGroupHasPositioningI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductGroupHasPositioningI18nForCulture(new ProductGroupHasPositioningI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductGroupHasPositioningI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductGroupHasPositioningI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductGroupHasPositioning.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductGroupHasPositioning:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductGroupHasPositioning::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 