<?php


abstract class BaseProductGroupHasPositioningI18n extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $culture;


	
	protected $title;


	
	protected $keywords;


	
	protected $description;


	
	protected $type;

	
	protected $aProductGroupHasPositioning;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCulture()
    {

            return $this->culture;
    }

    
    public function getTitle()
    {

            return $this->title;
    }

    
    public function getKeywords()
    {

            return $this->keywords;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getType()
    {

            return $this->type;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::ID;
        }

		if ($this->aProductGroupHasPositioning !== null && $this->aProductGroupHasPositioning->getId() !== $v) {
			$this->aProductGroupHasPositioning = null;
		}

	} 
	
	public function setCulture($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->culture !== $v) {
          $this->culture = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::CULTURE;
        }

	} 
	
	public function setTitle($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->title !== $v) {
          $this->title = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::TITLE;
        }

	} 
	
	public function setKeywords($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->keywords !== $v) {
          $this->keywords = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::KEYWORDS;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::DESCRIPTION;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = ProductGroupHasPositioningI18nPeer::TYPE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioningI18n.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->culture = $rs->getString($startcol + 1);

      $this->title = $rs->getString($startcol + 2);

      $this->keywords = $rs->getString($startcol + 3);

      $this->description = $rs->getString($startcol + 4);

      $this->type = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioningI18n.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductGroupHasPositioningI18n object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioningI18n:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupHasPositioningI18nPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductGroupHasPositioningI18nPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioningI18n:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioningI18n.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductGroupHasPositioningI18n:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductGroupHasPositioningI18nPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductGroupHasPositioningI18n.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductGroupHasPositioningI18n:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProductGroupHasPositioning !== null) {
				if ($this->aProductGroupHasPositioning->isModified() || $this->aProductGroupHasPositioning->getCurrentProductGroupHasPositioningI18n()->isModified()) {
					$affectedRows += $this->aProductGroupHasPositioning->save($con);
				}
				$this->setProductGroupHasPositioning($this->aProductGroupHasPositioning);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductGroupHasPositioningI18nPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += ProductGroupHasPositioningI18nPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProductGroupHasPositioning !== null) {
				if (!$this->aProductGroupHasPositioning->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductGroupHasPositioning->getValidationFailures());
				}
			}


			if (($retval = ProductGroupHasPositioningI18nPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupHasPositioningI18nPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getCulture();
				break;
			case 2:
				return $this->getTitle();
				break;
			case 3:
				return $this->getKeywords();
				break;
			case 4:
				return $this->getDescription();
				break;
			case 5:
				return $this->getType();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupHasPositioningI18nPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getCulture(),
			$keys[2] => $this->getTitle(),
			$keys[3] => $this->getKeywords(),
			$keys[4] => $this->getDescription(),
			$keys[5] => $this->getType(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductGroupHasPositioningI18nPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setCulture($value);
				break;
			case 2:
				$this->setTitle($value);
				break;
			case 3:
				$this->setKeywords($value);
				break;
			case 4:
				$this->setDescription($value);
				break;
			case 5:
				$this->setType($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductGroupHasPositioningI18nPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setCulture($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTitle($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setKeywords($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDescription($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setType($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductGroupHasPositioningI18nPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::ID)) $criteria->add(ProductGroupHasPositioningI18nPeer::ID, $this->id);
		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::CULTURE)) $criteria->add(ProductGroupHasPositioningI18nPeer::CULTURE, $this->culture);
		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::TITLE)) $criteria->add(ProductGroupHasPositioningI18nPeer::TITLE, $this->title);
		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::KEYWORDS)) $criteria->add(ProductGroupHasPositioningI18nPeer::KEYWORDS, $this->keywords);
		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::DESCRIPTION)) $criteria->add(ProductGroupHasPositioningI18nPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(ProductGroupHasPositioningI18nPeer::TYPE)) $criteria->add(ProductGroupHasPositioningI18nPeer::TYPE, $this->type);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductGroupHasPositioningI18nPeer::DATABASE_NAME);

		$criteria->add(ProductGroupHasPositioningI18nPeer::ID, $this->id);
		$criteria->add(ProductGroupHasPositioningI18nPeer::CULTURE, $this->culture);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getId();

		$pks[1] = $this->getCulture();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setId($keys[0]);

		$this->setCulture($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setTitle($this->title);

		$copyObj->setKeywords($this->keywords);

		$copyObj->setDescription($this->description);

		$copyObj->setType($this->type);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
		$copyObj->setCulture(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductGroupHasPositioningI18nPeer();
		}
		return self::$peer;
	}

	
	public function setProductGroupHasPositioning($v)
	{


		if ($v === null) {
			$this->setId(NULL);
		} else {
			$this->setId($v->getId());
		}


		$this->aProductGroupHasPositioning = $v;
	}


	
	public function getProductGroupHasPositioning($con = null)
	{
		if ($this->aProductGroupHasPositioning === null && ($this->id !== null)) {
						$this->aProductGroupHasPositioning = ProductGroupHasPositioningPeer::retrieveByPK($this->id, $con);

			
		}
		return $this->aProductGroupHasPositioning;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductGroupHasPositioningI18n.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductGroupHasPositioningI18n:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductGroupHasPositioningI18n::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 