<?php


abstract class BaseWebpageHasPositioning extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $webpage_id;


	
	protected $opt_title;


	
	protected $opt_keywords;


	
	protected $opt_description;


	
	protected $opt_type;

	
	protected $aWebpage;

	
	protected $collWebpageHasPositioningI18ns;

	
	protected $lastWebpageHasPositioningI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getWebpageId()
    {

            return $this->webpage_id;
    }

    
    public function getOptTitle()
    {

            return $this->opt_title;
    }

    
    public function getOptKeywords()
    {

            return $this->opt_keywords;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getOptType()
    {

            return $this->opt_type;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = WebpageHasPositioningPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = WebpageHasPositioningPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::ID;
        }

	} 
	
	public function setWebpageId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->webpage_id !== $v) {
          $this->webpage_id = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::WEBPAGE_ID;
        }

		if ($this->aWebpage !== null && $this->aWebpage->getId() !== $v) {
			$this->aWebpage = null;
		}

	} 
	
	public function setOptTitle($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_title !== $v) {
          $this->opt_title = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::OPT_TITLE;
        }

	} 
	
	public function setOptKeywords($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_keywords !== $v) {
          $this->opt_keywords = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::OPT_KEYWORDS;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setOptType($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_type !== $v) {
          $this->opt_type = $v;
          $this->modifiedColumns[] = WebpageHasPositioningPeer::OPT_TYPE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageHasPositioning.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->webpage_id = $rs->getInt($startcol + 3);

      $this->opt_title = $rs->getString($startcol + 4);

      $this->opt_keywords = $rs->getString($startcol + 5);

      $this->opt_description = $rs->getString($startcol + 6);

      $this->opt_type = $rs->getInt($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageHasPositioning.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating WebpageHasPositioning object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseWebpageHasPositioning:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageHasPositioningPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			WebpageHasPositioningPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseWebpageHasPositioning:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageHasPositioning.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseWebpageHasPositioning:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(WebpageHasPositioningPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(WebpageHasPositioningPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageHasPositioningPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageHasPositioning.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseWebpageHasPositioning:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aWebpage !== null) {
				if ($this->aWebpage->isModified() || $this->aWebpage->getCurrentWebpageI18n()->isModified()) {
					$affectedRows += $this->aWebpage->save($con);
				}
				$this->setWebpage($this->aWebpage);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WebpageHasPositioningPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += WebpageHasPositioningPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collWebpageHasPositioningI18ns !== null) {
				foreach($this->collWebpageHasPositioningI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aWebpage !== null) {
				if (!$this->aWebpage->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aWebpage->getValidationFailures());
				}
			}


			if (($retval = WebpageHasPositioningPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collWebpageHasPositioningI18ns !== null) {
					foreach($this->collWebpageHasPositioningI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageHasPositioningPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getWebpageId();
				break;
			case 4:
				return $this->getOptTitle();
				break;
			case 5:
				return $this->getOptKeywords();
				break;
			case 6:
				return $this->getOptDescription();
				break;
			case 7:
				return $this->getOptType();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageHasPositioningPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getWebpageId(),
			$keys[4] => $this->getOptTitle(),
			$keys[5] => $this->getOptKeywords(),
			$keys[6] => $this->getOptDescription(),
			$keys[7] => $this->getOptType(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageHasPositioningPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setWebpageId($value);
				break;
			case 4:
				$this->setOptTitle($value);
				break;
			case 5:
				$this->setOptKeywords($value);
				break;
			case 6:
				$this->setOptDescription($value);
				break;
			case 7:
				$this->setOptType($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageHasPositioningPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setWebpageId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptTitle($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptKeywords($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptDescription($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptType($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(WebpageHasPositioningPeer::DATABASE_NAME);

		if ($this->isColumnModified(WebpageHasPositioningPeer::CREATED_AT)) $criteria->add(WebpageHasPositioningPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(WebpageHasPositioningPeer::UPDATED_AT)) $criteria->add(WebpageHasPositioningPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(WebpageHasPositioningPeer::ID)) $criteria->add(WebpageHasPositioningPeer::ID, $this->id);
		if ($this->isColumnModified(WebpageHasPositioningPeer::WEBPAGE_ID)) $criteria->add(WebpageHasPositioningPeer::WEBPAGE_ID, $this->webpage_id);
		if ($this->isColumnModified(WebpageHasPositioningPeer::OPT_TITLE)) $criteria->add(WebpageHasPositioningPeer::OPT_TITLE, $this->opt_title);
		if ($this->isColumnModified(WebpageHasPositioningPeer::OPT_KEYWORDS)) $criteria->add(WebpageHasPositioningPeer::OPT_KEYWORDS, $this->opt_keywords);
		if ($this->isColumnModified(WebpageHasPositioningPeer::OPT_DESCRIPTION)) $criteria->add(WebpageHasPositioningPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(WebpageHasPositioningPeer::OPT_TYPE)) $criteria->add(WebpageHasPositioningPeer::OPT_TYPE, $this->opt_type);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WebpageHasPositioningPeer::DATABASE_NAME);

		$criteria->add(WebpageHasPositioningPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setWebpageId($this->webpage_id);

		$copyObj->setOptTitle($this->opt_title);

		$copyObj->setOptKeywords($this->opt_keywords);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setOptType($this->opt_type);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getWebpageHasPositioningI18ns() as $relObj) {
				$copyObj->addWebpageHasPositioningI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WebpageHasPositioningPeer();
		}
		return self::$peer;
	}

	
	public function setWebpage($v)
	{


		if ($v === null) {
			$this->setWebpageId(NULL);
		} else {
			$this->setWebpageId($v->getId());
		}


		$this->aWebpage = $v;
	}


	
	public function getWebpage($con = null)
	{
		if ($this->aWebpage === null && ($this->webpage_id !== null)) {
						$this->aWebpage = WebpagePeer::retrieveByPK($this->webpage_id, $con);

			
		}
		return $this->aWebpage;
	}

	
	public function initWebpageHasPositioningI18ns()
	{
		if ($this->collWebpageHasPositioningI18ns === null) {
			$this->collWebpageHasPositioningI18ns = array();
		}
	}

	
	public function getWebpageHasPositioningI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageHasPositioningI18ns === null) {
			if ($this->isNew()) {
			   $this->collWebpageHasPositioningI18ns = array();
			} else {

				$criteria->add(WebpageHasPositioningI18nPeer::ID, $this->getId());

				WebpageHasPositioningI18nPeer::addSelectColumns($criteria);
				$this->collWebpageHasPositioningI18ns = WebpageHasPositioningI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageHasPositioningI18nPeer::ID, $this->getId());

				WebpageHasPositioningI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageHasPositioningI18nCriteria) || !$this->lastWebpageHasPositioningI18nCriteria->equals($criteria)) {
					$this->collWebpageHasPositioningI18ns = WebpageHasPositioningI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageHasPositioningI18nCriteria = $criteria;
		return $this->collWebpageHasPositioningI18ns;
	}

	
	public function countWebpageHasPositioningI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageHasPositioningI18nPeer::ID, $this->getId());

		return WebpageHasPositioningI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageHasPositioningI18n(WebpageHasPositioningI18n $l)
	{
		$this->collWebpageHasPositioningI18ns[] = $l;
		$l->setWebpageHasPositioning($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getTitle()
  {
    $obj = $this->getCurrentWebpageHasPositioningI18n();

    return ($obj ? $obj->getTitle() : null);
  }

  public function setTitle($value)
  {
    $this->getCurrentWebpageHasPositioningI18n()->setTitle($value);
  }

  public function getKeywords()
  {
    $obj = $this->getCurrentWebpageHasPositioningI18n();

    return ($obj ? $obj->getKeywords() : null);
  }

  public function setKeywords($value)
  {
    $this->getCurrentWebpageHasPositioningI18n()->setKeywords($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentWebpageHasPositioningI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentWebpageHasPositioningI18n()->setDescription($value);
  }

  public function getType()
  {
    $obj = $this->getCurrentWebpageHasPositioningI18n();

    return ($obj ? $obj->getType() : null);
  }

  public function setType($value)
  {
    $this->getCurrentWebpageHasPositioningI18n()->setType($value);
  }

  protected $current_i18n = array();

  public function getCurrentWebpageHasPositioningI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = WebpageHasPositioningI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setWebpageHasPositioningI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setWebpageHasPositioningI18nForCulture(new WebpageHasPositioningI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setWebpageHasPositioningI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addWebpageHasPositioningI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'WebpageHasPositioning.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseWebpageHasPositioning:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseWebpageHasPositioning::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 