<?php
class stFixPositioning
{
    protected $msg = '';

    protected $title = '';

    protected $langs = array();

    public function __construct()
    {
        $this->langs = LanguagePeer::doSelectLanguages();
    }

    public function productUpdate($step)
    {
        $i18n = sfContext::getInstance()->getI18N();
        stPropelSeoUrlBehavior::configuration(array('auto_generate_url'=>true));
        $c = new Criteria();
        $c->setOffset($step);
        $c->setLimit(20);

        $objects = ProductPeer::doSelect($c);
        foreach ($objects as $object) {
            foreach ($this->langs as $lang) {
                $object->setCulture($lang->getOriginalLanguage());
                try {
                    $object->save();
                } catch (Exception $e) {
                }
            }
        }
        $this->title = $i18n->__('Aktualizacja produktów', array(), 'stPositioningBackend');
        return ($step+count($objects));
    }

    public function categoryUpdate($step)
    {
        $i18n = sfContext::getInstance()->getI18N();
        
        stPropelSeoUrlBehavior::configuration(array('auto_generate_url'=>true));

        $c = new Criteria();
        $c->setOffset($step);
        $c->setLimit(20);

        $objects = CategoryPeer::doSelect($c);
        foreach ($objects as $object) {
            foreach ($this->langs as $lang) {
                $object->setCulture($lang->getOriginalLanguage());
                try {
                    $object->save();
                } catch (Exception $e) {
                }
            }
        }
        $this->title = $i18n->__('Aktualizacja kategorii', array(), 'stPositioningBackend');
        return ($step+count($objects));
    }

    public function productGroupUpdate($step)
    {
        $i18n = sfContext::getInstance()->getI18N();
        
        stPropelSeoUrlBehavior::configuration(array('auto_generate_url'=>true));

        $c = new Criteria();
        $c->setOffset($step);
        $c->setLimit(1);

        $object = ProductGroupPeer::doSelectOne($c);
        if (is_object($object)) {
            try {
                foreach ($this->langs as $lang) {
                    $object->setCulture($lang->getOriginalLanguage());
                    $object->save();
                }
            } catch (Exception $e) {
            }
        }
        $this->title = $i18n->__('Aktualizacja grup produktów', array(), 'stPositioningBackend');
        return $step+1;
    }

    public function webpageUpdate($step)
    {
        $i18n = sfContext::getInstance()->getI18N();
        
        stPropelSeoUrlBehavior::configuration(array('auto_generate_url'=>true));

        $c = new Criteria();
        $c->setOffset($step);
        $c->setLimit(1);

        $object = WebpagePeer::doSelectOne($c);
        if (is_object($object)) {
            try {
                foreach ($this->langs as $lang) {
                    $object->setCulture($lang->getOriginalLanguage());
                    $object->save();
                }
            } catch (Exception $e) {
            }
        }
        $this->title = $i18n->__('Aktualizacja stron www', array(), 'stPositioningBackend');
        return $step+1;
    }

    public  function producerUpdate($step)
    {
        $i18n = sfContext::getInstance()->getI18N();
        
        stPropelSeoUrlBehavior::configuration(array('auto_generate_url'=>true));

        $c = new Criteria();
        $c->setOffset($step);
        $c->setLimit(1);

        $object = ProducerPeer::doSelectOne($c);
        if (is_object($object)) {
            try {
                foreach ($this->langs as $lang) {
                    $object->setCulture($lang->getOriginalLanguage());
                    $object->save();
                }
            } catch (Exception $e) {
            }
        }
        $this->title = $i18n->__('Aktualizacja producentów', array(), 'stPositioningBackend');
        return $step+1;
    }


    public function getMessage()
    {
        return $this->msg;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function init()
    {
        $i18n = sfContext::getInstance()->getI18N();
        switch (sfContext::getInstance()->getRequest()->getParameterHolder()->get('name')) {
            case "stPositioning_ProductUpdate" :
                $this->title = $i18n->__('Aktualizacja produktów', array(), 'stPositioningBackend');
                break;
            case "stPositioning_CategoryUpdate" :
                $this->title = $i18n->__('Aktualizacja kategorii', array(), 'stPositioningBackend');
                break;
            case "stPositioning_ProductGroupUpdate" :
                $this->title = $i18n->__('Aktualizacja grup produktów', array(), 'stPositioningBackend');
                break;
            case "stPositioning_WebpageUpdate" :
                $this->title = $i18n->__('Aktualizacja stron www', array(), 'stPositioningBackend');
                break;
            case "stPositioning_ProducerUpdate" :
                $this->title = $i18n->__('Aktualizacja producentów', array(), 'stPositioningBackend');
                break;

        }
    }

    public function close()
    {
        $i18n = sfContext::getInstance()->getI18N();
        switch (sfContext::getInstance()->getRequest()->getParameterHolder()->get('name')) {
            case "stPositioning_ProductUpdate" :
                $this->title = $i18n->__('Aktualizacja produktów', array(), 'stPositioningBackend');
                touch(sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'stPositioning_ProductUpdate.log');
                break;
            case "stPositioning_CategoryUpdate" :
                $this->title = $i18n->__('Aktualizacja kategorii', array(), 'stPositioningBackend');
                touch(sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'stPositioning_CategoryUpdate.log');
                ProductHasCategoryPeer::cleanCache();
                break;
            case "stPositioning_ProductGroupUpdate" :
                $this->title = $i18n->__('Aktualizacja grup produktów', array(), 'stPositioningBackend');
                touch(sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'stPositioning_ProductGroupUpdate.log');
                break;
            case "stPositioning_WebpageUpdate" :
                $this->title = $i18n->__('Aktualizacja stron www', array(), 'stPositioningBackend');
                touch(sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'stPositioning_WebpageUpdate.log');
                break;
            case "stPositioning_ProducerUpdate" :
                $this->title = $i18n->__('Aktualizacja producentów', array(), 'stPositioningBackend');
                touch(sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'stPositioning_ProducerUpdate.log');
                break;
        }
    }

    public static function postInstall(sfEvent $event) {
        sfLoader::loadHelpers('stProgressBar');
        sfLoader::loadHelpers('Partial');
        $event->getSubject()->msg .= progress_bar('stPositioning_ProductUpdate', 'stUpdatePositioningPlugin', 'productUpdate', ProductPeer::doCount(new Criteria()));
        $event->getSubject()->msg .= progress_bar('stPositioning_CategoryUpdate', 'stUpdatePositioningPlugin', 'categoryUpdate', CategoryPeer::doCount(new Criteria()));
        $event->getSubject()->msg .= progress_bar('stPositioning_ProductGroupUpdate', 'stUpdatePositioningPlugin', 'productGroupUpdate', ProductGroupPeer::doCount(new Criteria()));
        $event->getSubject()->msg .= progress_bar('stPositioning_WebpageUpdate', 'stUpdatePositioningPlugin', 'webpageUpdate', WebpagePeer::doCount(new Criteria()));
        $event->getSubject()->msg .= progress_bar('stPositioning_ProducerUpdate', 'stUpdatePositioningPlugin', 'producerUpdate', ProducerPeer::doCount(new Criteria()));
    }
}
