<?php
/**
 * SOTESHOP/stPositioningPlugin
 *
 * Ten plik należy do aplikacji stPositioningPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPositioningPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stPositioning.class.php 13379 2011-06-02 09:58:45Z piotr $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stPositioning
 *
 * @package     stPositioningPlugin
 * @subpackage  libs
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */
class stPositioning
{
    /**
     * Typ domyślny
     *
     * @var int
     */
    const TYPE_DEFAULT = 0;

    /**
     * Typ użytkownika 
     *
     * @var int
     */
    const TYPE_USER = 1;

    /**
     * Typ automatycznego generowania
     *
     * @var int
     */
    const TYPE_GENERATE = 2;

    /**
     *
     * @param string $module
     * @param integer $id
     * @param sfResponse $response
     */
    public static function setHeaders($module, $param)
    {
        if ($module == "Product" || $module == 'Category' || $module == 'Webpage' || $module == 'ProductGroup' || $module == 'Producer')
        {
            $c = new Criteria();
            $c->add(constant($module.'I18nPeer::URL'), $param);
            $c->setLimit(1);
            $moduleI18n = call_user_func($module.'I18nPeer::doSelectJoin'.$module, $c);

            if (is_array($moduleI18n) && is_object($moduleI18n[0]))
            {
                $getter = 'get'.$module;
                
                if ($module == "Product") ProductPeer::setShowedProduct($moduleI18n[0]->getProduct());
                if ($module == "Webpage") WebpagePeer::setShowedWebpage($moduleI18n[0]->getWebpage());
                
                $c = new Criteria();
                $c->add(constant($module.'HasPositioningPeer::'.strtoupper(sfInflector::underscore($module)).'_ID'), $moduleI18n[0]->$getter()->getId());
                $positioning = call_user_func($module.'HasPositioningPeer::doSelectOne', $c);
                
                $metaTagsGeneratorName = 'st'.$module.'MetaTagsGenerator';
                if (!class_exists($metaTagsGeneratorName)) $metaTagsGeneratorName = 'stMetaTagsGenerator';

                if (is_object($positioning))
                {
                    if ($positioning->getType() == stPositioning::TYPE_DEFAULT) $object = new stMetaTagsGenerator();
                    if ($positioning->getType() == stPositioning::TYPE_USER)
                    {
                        $object = new stMetaTagsGenerator();

                        if ($positioning->getTitle()) $title = $positioning->getTitle();
                        if ($positioning->getKeywords()) $keywords = $positioning->getKeywords();
                        if ($positioning->getDescription()) $description = $positioning->getDescription();
                    }
                    if ($positioning->getType() == stPositioning::TYPE_GENERATE)
                    {
                        $object = new $metaTagsGeneratorName();
                        $object->generate($moduleI18n[0]->$getter());
                    } 
                } else {
                    $object = new $metaTagsGeneratorName();
                    $object->generate($moduleI18n[0]->$getter());
                }

                try {
                    $response = sfContext::getInstance()->getResponse();
                    $response->setTitle(isset($title) ? $title : $object->getTitle());
                    $response->addMeta('keywords', isset($keywords) ? $keywords : $object->getKeywords());
                    $response->addMeta('description', isset($description) ? $description : $object->getDescription());
                    return true;
                } catch (Exception $e) {}
            }
        }
        return false;
    }
}
