<?php if ($sf_flash->has('notice')):?>
    <div class="save-ok">
        <h2><?php echo __($sf_flash->get('notice'));?></h2>
    </div>
<?php endif;?>
<div id="sf_admin_content_config">
    <?php echo form_tag('stPositioningBackend/sitemapCustom', array('id' => 'sf_admin_config_form', 'name' => 'sf_admin_config_form'));?>
        <fieldset>
            <div class="st_header">
                <div>
                    <h2><?php echo __('Generowanie mapy serwisu');?></h2>
                </div>
            </div>
            <div class="st_fieldset-content">
                <?php if (!$sf_params->get('save_and_generate',0) || $sf_request->hasErrors()): ?>
                <div class="form-row">
                    <label><?php echo __('Generuj mapę strony dla wersji językowych') ?>:</label>
                    <div class="content<?php if ($sf_request->hasError('sitemap{langs}')): ?> form-error<?php endif; ?>" style="margin-left: 412px;">
                    <?php if ($sf_request->hasError('sitemap{langs}')): ?>
                        <?php echo form_error('sitemap{langs}', array('class' => 'form-error-msg')) ?>
                    <?php endif; ?>
                    <ul>
                        <?php foreach ($languages as $language):?> 
                            <li>
                            <?php echo checkbox_tag('sitemap[langs]['.$language->getShortcut().']',$language->getOriginalLanguage(),isset($langs[$language->getShortcut()])?$langs[$language->getShortcut()]:'');?>
                            <?php echo image_tag('/'.sfConfig::get('sf_upload_dir_name').'/stLanguagePlugin/'.$language->getActiveImage()) ?>
                            <?php echo $language->getName() ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>                
                    </div>                    
                    <br class="st_clear_all" />
                </div>
                <div class="form-row">
                    <label><?php echo __('Klucz weryfikacji') ?>:</label>
                    <div class="content<?php if ($sf_request->hasError('sitemap{verify}')): ?> form-error<?php endif; ?>" style="margin-left: 412px;">
                    <?php if ($sf_request->hasError('sitemap{verify}')): ?>
                        <?php echo form_error('sitemap{verify}', array('class' => 'form-error-msg')) ?>
                    <?php endif; ?>
                    <ul>
                        <?php foreach ($domains as $domain):?>
                            <li><?php echo __('Dla domeny:').' '.st_external_link_to("http://".$domain->getDomain()."/","http://".$domain->getDomain()."/")?><br />
                            <?php echo input_tag('sitemap[verify]['.$domain->getDomain().']', @$domainsVerify[$domain->getDomain()] , array('size'=>50))?></li>
                        <?php endforeach; ?>
                    </ul>    
                    <?php echo __("Klucz można uzyskać na stronie")?>
                    <?php echo st_external_link_to(__('Narzędzia dla webmasterów'),'https://www.google.com/webmasters/tools/')?>
                    </div>
                    <br class="st_clear_all" />
                </div>
                <div class="form-row">
                    <label><?php echo __('Pliki map strony') ?>:</label>
                  <div class="content">
                  <ul>
                    <?php foreach ($languages as $language):?> 
                        <li><?php echo image_tag('/'.sfConfig::get('sf_upload_dir_name').'/stLanguagePlugin/'.$language->getActiveImage()) ?>
                        <?php if (file_exists(sfConfig::get('sf_web_dir').DIRECTORY_SEPARATOR."sitemap_".$language->getShortcut().".xml")): ?>
                            <?php echo st_external_link_to("http://".stSitemapGenerator::getDefaultDomainForLang($language->getShortcut())."/sitemap_".$language->getShortcut().".xml", "http://".stSitemapGenerator::getDefaultDomainForLang($language->getShortcut())."/sitemap_".$language->getShortcut().".xml") ;?>
                        <?php else: ?>
                            <?php echo __("Mapa strony nie została wygenerowana") ?>
                        <?php endif;?>
                        </li>
                    <?php endforeach; ?>
                    </ul>
                  </div>
                </div>
                <?php else: ?>
                <div class="form-row">
                    <?php st_include_component('stPositioningBackend','generateSitemap',array('config'=>$config))?>
                    <br class="st_clear_all" />
                </div>                    
                <?php endif;?>
            </div>
        </fieldset>
        <?php if (!$sf_params->get('save_and_generate',0) || $sf_request->hasErrors()): ?>
        <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"');?>
            <?php echo st_get_admin_action('file', __('Generuj mapę serwisu'), null, array('name' => 'save_and_generate'));?>
            <?php echo st_get_admin_action('save', __('Zapisz', null, 'stAdminGeneratorPlugin'), null, array('name' => 'save'));?>
        <?php echo st_get_admin_actions_foot();?>
        <?php endif;?>
    </form>
</div>