<?php use_helper('stProgressBar')?>
<?php use_helper('Object', 'Validation', 'ObjectAdmin', 'I18N', 'Date', 'VisualEffect', 'stAdminGenerator') ?>

<?php echo st_get_admin_head('stPositioningPlugin', __('Zarządzanie pozycjonowaniem'), __('Generowanie mapy serwisu dla Google'), array (
  0 => 'stConfigurationPlugin',
  1 => 'stLanguagePlugin',
  2 => 'stProduct',
  3 => 'stCategory',
  4 => 'stWebpagePlugin',
  5 => 'stProducer',
)) ?>
    <?php st_include_component('stPositioningBackend', 'listMenu', array('forward_parameters' => $forward_parameters, 'positioning' => null)) ?>
  

    <div id="sf_admin_header">
    </div>
    
    <div id="sf_admin_content">
        <?php if($sf_params->get('force') == 'true' && !$sf_request->hasErrors()): ?>
            <?php if($sf_params->get('seo_links[product]')): ?>
                <?php echo progress_bar('stPositioning_ProductUpdate', 'stFixPositioning', 'productUpdate', ProductPeer::doCount(new Criteria())); ?>
            <?php endif; ?>
            <?php if($sf_params->get('seo_links[category]')): ?>
                <?php echo progress_bar('stPositioning_CategoryUpdate', 'stFixPositioning', 'categoryUpdate', CategoryPeer::doCount(new Criteria())); ?>
            <?php endif; ?>
            <?php if($sf_params->get('seo_links[productgroup]')): ?>
                <?php echo progress_bar('stPositioning_ProductGroupUpdate', 'stFixPositioning', 'productGroupUpdate', ProductGroupPeer::doCount(new Criteria())); ?>
            <?php endif; ?>
            <?php if($sf_params->get('seo_links[webpage]')): ?>
                <?php echo progress_bar('stPositioning_WebpageUpdate', 'stFixPositioning', 'webpageUpdate', WebpagePeer::doCount(new Criteria())); ?>
            <?php endif; ?>
            <?php if($sf_params->get('seo_links[producer]')): ?>
                <?php echo progress_bar('stPositioning_ProducerUpdate', 'stFixPositioning', 'producerUpdate', ProducerPeer::doCount(new Criteria())); ?>
            <?php endif; ?>
        <?php else: ?>
        <?php echo form_tag('stPositioningBackend/rebuildSeoLinks?force=true');?>
            <div class="form-errors">
            <h2><?php echo __("Przywracanie domyślnych linków SEO")?></h2>
            <dl>
              <dt><?php echo __("Uwaga:")?></dt>
              <dd><?php echo __("Wykonanie funkcji przywracania domyślnych linków SEO, spowoduje utratę wcześniej wprowadzonych zmian w polach Przyjazny link dla produktów, grup produktów, kategorii oraz stron www i ustawienie wartości domyślnych.")?></dd>
            </dl>
            </div>
            <?php if ($sf_request->hasError('seo_links')): ?>
            <div class="form-errors">
            <h2><?php echo __("Popraw dane w formularzu.")?></h2>
            <dl>
                <dt><?php echo __("Przywróć przyjazne linki dla")?></dt>
                <dd><?php echo $sf_request->getError('seo_links')?></dd>
            </dl>
            </div>
            <?php endif;?>
            <fieldset>
                <div class="st_header">
                    <div>
                        <h2><?php echo __('Przywracanie domyślnych linków SEO');?></h2>
                    </div>
                </div>
                <div class="st_fieldset-content">
                    <div class="form-row">
                        <label><?php echo __('Przywróć przyjazne linki dla') ?>:</label>
                        <div class="content<?php if ($sf_request->hasError('seo_links')): ?> form-error<?php endif; ?>" style="margin-left: 412px;">
                        <?php if ($sf_request->hasError('seo_links')): ?>
                            <?php echo form_error('seo_links', array('class' => 'form-error-msg')) ?>
                        <?php endif; ?>
                        <ul>
                            <li><?php echo checkbox_tag('seo_links[product]',1,0);?><?php echo __("Produktów")?></li>
                            <li><?php echo checkbox_tag('seo_links[productgroup]',1,0);?><?php echo __("Grupy produktów")?></li>
                            <li><?php echo checkbox_tag('seo_links[category]',1,0);?><?php echo __("Kategorie")?></li>
                            <li><?php echo checkbox_tag('seo_links[webpage]',1,0);?><?php echo __("Strony www")?></li>
                            <li><?php echo checkbox_tag('seo_links[producer]',1,0);?><?php echo __("Producentów")?></li>
                        </ul>                
                        </div>                    
                        <br class="st_clear_all" />
                    </div>
                </div>
            </fieldset>
            
        <?php echo st_get_admin_actions_head('style="margin-top: 10px; float: right"');?>
            <?php echo st_get_admin_action('save', __('Generuj linki SEO'), null , array('name' => 'save'));?>
        <?php echo st_get_admin_actions_foot();?>
        <?php endif; ?>
    </div>
    
    <div id="sf_admin_footer">
    </div>
<br class="st_clear_all" />
<?php echo st_get_admin_foot() ?>