<?php
/** 
 * SOTESHOP/stProductOptionsPlugin 
 * 
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stProductOptionsPlugin
 * @subpackage  configs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: config.php 16306 2011-11-30 12:07:17Z piotr $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Włączanie modułów
 */
stPluginHelper::addEnableModule('stProductOptionsTemplateBackend', 'backend');
stPluginHelper::addEnableModule('stProductOptionsTreeBackend', 'backend');
stPluginHelper::addEnableModule('stProductOptionsBackend', 'backend');
stPluginHelper::addEnableModule('stProductOptionsStockBackend', 'backend');

stPluginHelper::addEnableModule('stProductOptionsStockFrontend', 'frontend');
stPluginHelper::addEnableModule('stProductOptionsFrontend', 'frontend');

/** 
 * Dodawanie routingów
 */
stPluginHelper::addRouting('stProductOptionsPlugin', '/product_options_template/:action/*', 'stProductOptionsTemplateBackend', null, 'backend');
stPluginHelper::addRouting('stProductOptionsPluginDefault', '/product_options_template', 'stProductOptionsTemplateBackend', 'list', 'backend');

stPluginHelper::addRouting('stProductOptionsFrontend', '/product_options/:action/*', 'stProductOptionsFrontend', null, 'frontend');
stPluginHelper::addRouting('stProductOptionsStockFrontend', '/product_options_stock/:action/*', 'stProductOptionsStockFrontend', null, 'frontend');

/**
 *  Rozszerzenie modelu stProduct
 */ 
sfPropelBehavior::registerHooks('st_product_opt', array(':save:pre' => array('stProductOptBehavior' ,'preSaveProduct')));
sfPropelBehavior::registerMethods('st_product_opt', array(array('stProductOptBehavior', 'getHasOptions')));
sfPropelBehavior::add('Product', array('st_product_opt'));

/** 
 * pobiera instancję obiektu sfEventDispatcher
 */
$dispatcher = stEventDispatcher::getInstance();

/** 
 * dodaje sluchacza dla zdarzenia generator.generate
 */
switch(SF_APP)
{
    case 'backend':
        $dispatcher->connect('stAdminGenerator.generateStProduct', array('stProductOptionsPluginListener', 'generate')); 
        $dispatcher->connect('autostProductActions.preExecuteOptionsTemplatesEdit', array('stProductOptionsPluginListener', 'preExecuteOptionsTemplatesEdit'));
        $dispatcher->connect('autostProductActions.preExecuteOptionsEdit', array('stProductOptionsPluginListener', 'preExecuteOptionsEdit'));
        $dispatcher->connect('autostProductActions.postExecuteOptionsEdit', array('stProductOptionsPluginListener', 'postExecuteOptionsEdit'));
        $dispatcher->connect('autostProductActions.preExecuteOptionsTemplatesList', array('stProductOptionsPluginListener', 'preExecuteOptionsTemplatesList'));
        $dispatcher->connect('autostProductActions.preExecuteOptionsStockList', array('stProductOptionsStockListener', 'preExecuteOptionsStockList'));
        $dispatcher->connect('autostProductActions.postExecuteOptionsStockList', array('stProductOptionsStockListener', 'postExecuteOptionsStockList'));
        $dispatcher->connect('autostProductActions.preExecuteOptionsStockDelete', array('stProductOptionsStockListener', 'preExecuteOptionsStockDelete'));
        $dispatcher->connect('autoStProductActions.postSave', array('stProductOptionsStockListener', 'postProductSave'));
        $dispatcher->connect('stImportExport.Import_Product', array('stProductOptionsStockListener', 'importUpdateStock'));
        $dispatcher->connect('stProductActions.postExecuteDuplicate', array('stNewProductOptions', 'copyOptions'));
        $dispatcher->connect('stProductActions.validateConfig', array('stProductOptionsStockListener', 'validateProductConfig'));

        break;
        
    case 'frontend':
        $dispatcher->connect('stProductActions.preProductPagerInit', array('stNewProductOptions', 'listFilter'));
    	$dispatcher->connect('stProduct.pagerCustomLink', array('stNewProductOptions', 'pagerModify'));
        $dispatcher->connect('basket.post_component_add', array('stProductOptionsPluginListener', 'basketPostComponentAdd'));
        $dispatcher->connect('stBasket.modAddItem', array('stProductOptionsPluginListener', 'basketModAddItem'));
        $dispatcher->connect('stBasket.generateItemId', array('stProductOptionsPluginListener', 'basketGenerateItemId'));
    	$dispatcher->connect('Product.postHydrate', array('stProductOptionsPluginListener', 'overrideProductPrice'));
    	$dispatcher->connect('stBasket.postAddItem', array('stProductOptionsPluginListener', 'postAddItem'));


        break;
}
$dispatcher->connect('stDepositoryPluginListener.postDecrease', array('stProductOptionsStockListener', 'preDecrease'));
$dispatcher->connect('stDepositoryPluginListener.postIncrease', array('stProductOptionsStockListener', 'preIncrease'));
$dispatcher->connect('Product.preSave', array('stNewProductOptions', 'saveProductColors'));


