<?php

/** 
 * SOTESHOP/stProductOptionsPlugin
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  libs
 */
class ProductOptionsValue extends BaseProductOptionsValue
{

    protected static
            $productPool = array();

    protected $childOptions = null;

    /**
     * Przeciazenie setPrice, zeby nie zapisywalo pustego stringa
     *
     * @return void
     **/
    public function setPrice($v)
    {
        if($v === '')
        {
            $v = null;
        }

        parent::setPrice($v);
    }

    public function getChildOptions($hide_with_empty_stock = false)
    {
        if (null === $this->childOptions)
        {
            $c = new Criteria();

            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID);

            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);

            $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

            if ($hide_with_empty_stock)
            {
                $c->add(ProductOptionsValuePeer::STOCK, 0, Criteria::GREATER_THAN);
            }

            $this->childOptions = ProductOptionsValuePeer::doSelectJoinProductOptionsField($c);
        }

        return $this->childOptions;
    }

    /**
     * Funckja tworząca rekurencyjnie tablice obiektów stProductOptionsField
     * z uwzględnieniem głębokości występowania w drzewie.
     *
     * @param $path
     * @return array of stProductOptionsField
     */
    public function getFields($path = '', $selected = array())
    {
        $c = new Criteria();
        $c->addJoin(ProductOptionsFieldPeer::ID, ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID);
        $c->addAscendingOrderByColumn(ProductOptionsFieldPeer::FIELD_ORDER);
        $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);
        $c->addGroupByColumn(ProductOptionsFieldPeer::ID);
        if (ProductOptionsValuePeer::$hide_no_stock) $c->add(ProductOptionsValuePeer::STOCK,0,Criteria::GREATER_THAN);
        if($nodes = $this->getChildren('doSelect', $c))
        {

            foreach($nodes as $node)
            {
                $field = $node->getProductOptionsField();
                $field->setCulture($this->getCulture());
                $field->level = $node->getLevel();
                $field->path = ($path!='' ? $path.'_' : '').$field->getId();
                $result[] = $field;
                if(count($selected) && (!empty($selected[$field->getId()]) || !empty($selected[$field->path])))
                {
                    if(!empty($selected[$field->getId()]))
                    {
                        $node_path = explode('_', $selected[$field->getId()]);
                    }
                    else
                    {
                        $node_path = explode('_', $selected[$field->path]);
                    }
                    $defaultNode = ProductOptionsValuePeer::retrieveByPK(end($node_path));
                    end($result)->selected = $defaultNode->getId();
                    $result = array_merge($result, $defaultNode->getFields($field->path, $selected));
                }
                elseif(($field->getOptDefaultValue()!==null) && $field->getOptDefaultValue() != $node->getOptValue())
                {
                    if($defaultNode = $field->getDefaultNode($this->getProductId()))
                    {
                        end($result)->selected = $defaultNode->getId();
                        $result = array_merge($result, $defaultNode->getFields($field->path));
                    }
                    else
                    {
                        end($result)->selected = $node->getId();
                        $result = array_merge($result, $node->getFields($field->path));
                    }
                }
                else
                {
                    end($result)->selected = $node->getId();
                    $result = array_merge($result, $node->getFields($field->path));
                }
            }
            return $result;
        }
        return array();
    }

    public function getStock()
    {
        $stock = parent::getStock();

        return $stock < 0 ? 0 : $stock;
    }

    /**
     * Przeciążenie getPriceType
     *
     * @return string
     */
    public function getPriceType($check = false)
    {
        return ProductOptionsValuePeer::getPriceType($this->getProductId());
    }

    public function getModifiedPrice($price, $vat, $type = 'netto')
    {
        $optionType = ProductOptionsValuePeer::getRoot($this->getProductId())->getPriceType()=='brutto'?'brutto':'netto';

        $mod_price = $this->getPrice();
        if($mod_price !== null)
        {
            if(preg_match('/^\s*([-+])\s*([0-9]+(\.[0-9]{2})?)\s*$/', $mod_price, $value))
            {
                if ($optionType=='netto' && $type == 'brutto') $value[2] = stCurrency::calculateBruttoFromNetto($value[2], $vat);
                if ($optionType=='brutto' && $type == 'netto') $value[2] =stCurrency::extractNettoFromBrutto($value[2], $vat);

                if($value[1]=='+')
                {
                    $price += $value[2];
                }
                else
                {
                    $price -= $value[2];
                }
            }
            else if(preg_match('/^\s*([-+])\s*([0-9]+(\.[0-9]{2})?)\s*%\s*$/', $mod_price, $value))
            {
                if($value[1]=='+')
                {
                    $price += $value[2]*$price/100;
                }
                else
                {
                    $price -= $value[2]*$price/100;
                }
            }
            else if(preg_match('/^\s*[0-9]+(\.[0-9]{2})?\s*$/', $mod_price, $value))
            {
                if ($optionType=='netto' && $type == 'brutto') $value[0] = stCurrency::calculateBruttoFromNetto($value[0], $vat);
                if ($optionType=='brutto' && $type == 'netto') $value[0] =stCurrency::extractNettoFromBrutto($value[0], $vat);
                $price = $value[0];
            }
        }

        return $price < 0 ? 0 : $price;
    }

//   public function getsfAsset($con = null)
//   {
//      if ($this->asfAsset === null && ($this->sf_asset_id !== null) && ($this->sf_asset_id != 0))
//      {
//         $this->asfAsset = sfAssetPeer::retrieveByPK($this->sf_asset_id, $con);
//      }
//      elseif($this->getParent())
//      {
//         $this->asfAsset = $this->getParent()->getsfAsset();
//      }
//      return $this->asfAsset;
//   }

    /**
     * Przeciążenie hydrate
     *
     * @param ResultSet $rs
     * @param int $startcol
     * @return object
     */
    public function hydrate(ResultSet $rs, $startcol = 1)
    {
        $this->setCulture(stLanguage::getHydrateCulture());
        return parent::hydrate($rs, $startcol);
    }

    /**
     * Przeciążenie getValue
     *
     * @return string
     */
    public function getValue()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);
        }
        $v = parent::getValue();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }

    /**
     * Przeciążenie setValue
     *
     * @param string $v
     */
    public function setValue($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }

        parent::setValue($v);
    }

    public function getProduct($con = null)
    {
        $id = $this->getProductId();

        if ($id && !isset(self::$productPool[$id]))
        {
            self::$productPool[$id] = parent::getProduct($con);
        }

        return self::$productPool[$id];
    }
    /**
     * Przeciążenie funkcji save
     *
     * @param $con
     */
    public function save($con = null)
    {

        if($this->isNew())
        {
            $product = $this->getProduct();
            $product->setOptHasOptions($product->getOptHasOptions() + 1);
            $product->save();
        }

        if ($this->getOptVersion()!=ProductOptionsValuePeer::version)
        {
            $this->setOptVersion(ProductOptionsValuePeer::version);
        }
        parent::save($con);

        $field = ProductOptionsFieldPeer::retrieveByPk($this->product_options_field_id);
        if ($field && $this->getDepth()>0)
        {
            $field->setOptValueId($this->getParent()->getId());
            $field->save();
        }
    }

    /**
     * Przeciążenie funkcji delete
     *
     * @param $con
     **/
    public function delete($con = null)
    {
        $product = $this->getProduct();
        $product->setOptHasOptions(max($product->getOptHasOptions() - 1, 0));
        $product->save();
        parent::delete($con);
    }

    public function getParentId()
    {
        return $this->getProductOptionsValueId();
    }

    public function getUseProductPrice($price_type)
    {
        $c = new Criteria();
        $c->add(ProductPeer::CODE, $this->getUseProduct());
        $product = ProductPeer::doSelectOne($c);

        if (is_object($product)) {
           if ($price_type=='netto') return $product->getPrice();
           return $product->getPriceBrutto();
        }
        return $this->getPrice();
    }
    public function getUseProductStock()
    {
        $c = new Criteria();
        $c->add(ProductPeer::CODE, $this->getUseProduct());
        $product = ProductPeer::doSelectOne($c);

        if (is_object($product)) {
           return $product->getStock();
        }
        return $this->getStock();
    }
}

$columns = array('left' => ProductOptionsValuePeer::LFT,
        'right' => ProductOptionsValuePeer::RGT,
        'parent' => ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID,
        'scope' => ProductOptionsValuePeer::PRODUCT_ID,
        'depth' => ProductOptionsValuePeer::DEPTH);

sfPropelBehavior::add('ProductOptionsValue', array('actasnestedset' => array('columns' => $columns)));
