<?php

/** 
 * SOTESHOP/stProductOptionsPlugin
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  libs
 */
class ProductOptionsValuePeer extends BaseProductOptionsValuePeer
{
    protected static
            $selectedItems = array(),
            $doSelectByProduct = array(),
            $getPriceType = array();

    const version = 1;

    public static $hide_no_stock = false;

    public static function doCountLeafsJoinProduct(Criteria $c = null, $con = null)
    {
        if($c == null)
        {
            $c = new Criteria();
        }

        $user = sfContext::getInstance()->getUser();
        $filters = sfContext::getInstance()->getRequest()->getParameter('filters', array());
        
        
        $c->add(ProductOptionsValuePeer::LFT, ProductOptionsValuePeer::RGT.'-'.ProductOptionsValuePeer::LFT.'=1', Criteria::CUSTOM);
        $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);
        $c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, BaseProductOptionsFieldPeer::ID);
        $c->addJoin(ProductOptionsValuePeer::ID, ProductOptionsValueI18nPeer::ID.' AND '.ProductOptionsValueI18nPeer::CULTURE.'=\''.$user->getCulture().'\'', Criteria::LEFT_JOIN);
        $c->add(BaseProductOptionsFieldPeer::OPT_NAME, null, Criteria::ISNOTNULL);
        
        return self::doCountJoinProduct($c, $con);
    }    
    
    public static function doSelectLeafsJoinProduct(Criteria $c = null, $con = null)
    {
        if($c == null)
        {
            $c = new Criteria();
        }

        $user = sfContext::getInstance()->getUser();
        $filters = sfContext::getInstance()->getRequest()->getParameter('filters', array());

        $c->add(ProductOptionsValuePeer::LFT, ProductOptionsValuePeer::RGT.'-'.ProductOptionsValuePeer::LFT.'=1', Criteria::CUSTOM);
        $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);
        $c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, BaseProductOptionsFieldPeer::ID);
        $c->addJoin(ProductOptionsValuePeer::ID, ProductOptionsValueI18nPeer::ID.' AND '.ProductOptionsValueI18nPeer::CULTURE.'=\''.$user->getCulture().'\'', Criteria::LEFT_JOIN);
        $c->add(BaseProductOptionsFieldPeer::OPT_NAME, null, Criteria::ISNOTNULL);
        return self::doSelectJoinProduct($c, $con);

    }

    public static function updateStock($product)
    {
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::DEPTH,0);
        $c->add(ProductOptionsValuePeer::PRODUCT_ID,$product->getId());
        $root = ProductOptionsValuePeer::doSelectOne($c);
        if ($root)
        {
            return ProductOptionsValuePeer::recurencyStockUpdate($root);
        }
        return null;
    }

    public static function recurencyStockUpdate($root)
    {
        $total = 0;
        $field = null;
        foreach ($root->getChildren() as $child)
        {
            $total += ProductOptionsValuePeer::recurencyStockUpdate($child);
            if (!$field) $field = $child->getProductOptionsField();
        }

        if (!$root->isLeaf())
        {
            $root->setStock($total);
            $root->save();
            if (is_object($field))
            {
                $field->setOptStock($total);
                $field->save();
            }
        } else
        {
            if ($root->getStock() == null)
            {
                $root->setStock(0);
                $root->save();
            }
            $total+= (integer)$root->getStock();
        }

        return $total;
    }

    public static function updateTotalStock($product_id)
    {
        $product = ProductPeer::retrieveByPk($product_id);
        ProductOptionsValuePeer::updateStock($product);
    }

    public static function unsetTemplate($product)
    {
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::DEPTH, 0);
        $c->add(ProductOptionsValuePeer::PRODUCT_ID, $product->getId());

        $root = ProductOptionsValuePeer::doSelectOne($c);
        if(is_object($root))
        {
            $root->setProductOptionsTemplateId(null);
            $root->save();
        }
    }

    public static function getProductOptionsStock($product)
    {
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::PRODUCT_ID,$product->getId());
        $c->add(ProductOptionsValuePeer::LFT, ProductOptionsValuePeer::RGT.'-'.ProductOptionsValuePeer::LFT.'=1', Criteria::CUSTOM);

        $stock = 0;
        foreach (ProductOptionsValuePeer::doSelect($c) as $option)
        {
            $stock+= $option->getStock();
        }
        return $stock;
    }

    public static function retrieveByPkWithProduct($pk)
    {
        $c = new Criteria();

        $c->add(ProductOptionsValuePeer::ID, $pk);

        $options = ProductOptionsValuePeer::doSelectJoinProduct($c);

        return isset($options[0]) ? $options[0] : null;
    }

    public static function retrieveByPksWithProduct($pks)
    {
        $c = new Criteria();

        $c->add(ProductOptionsValuePeer::ID, $pks, Criteria::IN);

        return ProductOptionsValuePeer::doSelectJoinProduct($c);
    }

    public static function setSelectedItems($id, $items = array())
    {
        self::$selectedItems[$id] = $items;
    }

    public static function getSelectedItems($id)
    {
        if (isset(self::$selectedItems[$id])) return self::$selectedItems[$id];
        return array();
    }

    public static function getRoot($product_id)
    {
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
        $c->add(ProductOptionsValuePeer::LFT, 1);

        return ProductOptionsValuePeer::doSelectOne($c);
    }

    public static function getPriceType($product)
    {
        $id = is_object($product) ? $product->getId() : $product;

        if (!isset(self::$getPriceType[$id]))
        {
            $c = new Criteria();

            $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, null, Criteria::ISNULL);

            $c->add(ProductOptionsValuePeer::PRICE_TYPE, null, Criteria::ISNOTNULL);

            $c->addSelectColumn(ProductOptionsValuePeer::PRICE_TYPE);

            $c->add(ProductOptionsValuePeer::PRODUCT_ID, $id);

            $c->setLimit(1);

            $rs = ProductOptionsValuePeer::doSelectRS($c);

            $config = stConfig::getInstance(null, 'stProduct');

            self::$getPriceType[$id] = $rs->next() ? $rs->getString(1) : $config->get('price_type');
        }

        return self::$getPriceType[$id];
    }

    public static function doSelectByProduct($product)
    {
        $id = $product->getId();

        if (!isset(self::$doSelectByProduct[$id]))
        {
            $c = new Criteria();

            $c->add(ProductOptionsValuePeer::PRODUCT_ID, $id);

            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID);

            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);

            $c->add(ProductOptionsValuePeer::DEPTH, 1);

            if ($product->getConfiguration()->get('hide_options_with_empty_stock'))
            	$c->add(ProductOptionsValuePeer::STOCK, 0, Criteria::GREATER_THAN);

            self::$doSelectByProduct[$id] = ProductOptionsValuePeer::doSelectJoinProductOptionsField($c);
        }

        return self::$doSelectByProduct[$id];
    }
}
