<?php


abstract class BaseProductOptionsField extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $product_options_template_id;


	
	protected $product_options_filter_id;


	
	protected $required;


	
	protected $typ;


	
	protected $opt_name;


	
	protected $opt_default_value;


	
	protected $opt_stock = 0;


	
	protected $opt_value_id;


	
	protected $field_order;

	
	protected $aProductOptionsTemplate;

	
	protected $aProductOptionsFilter;

	
	protected $collProductOptionsDefaultValues;

	
	protected $lastProductOptionsDefaultValueCriteria = null;

	
	protected $collProductOptionsValues;

	
	protected $lastProductOptionsValueCriteria = null;

	
	protected $collProductOptionsFieldI18ns;

	
	protected $lastProductOptionsFieldI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getProductOptionsTemplateId()
    {

            return $this->product_options_template_id;
    }

    
    public function getProductOptionsFilterId()
    {

            return $this->product_options_filter_id;
    }

    
    public function getRequired()
    {

            return $this->required;
    }

    
    public function getTyp()
    {

            return $this->typ;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDefaultValue()
    {

            return $this->opt_default_value;
    }

    
    public function getOptStock()
    {

            return $this->opt_stock;
    }

    
    public function getOptValueId()
    {

            return $this->opt_value_id;
    }

    
    public function getFieldOrder()
    {

            return $this->field_order;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductOptionsFieldPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductOptionsFieldPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::ID;
        }

	} 
	
	public function setProductOptionsTemplateId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_options_template_id !== $v) {
          $this->product_options_template_id = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID;
        }

		if ($this->aProductOptionsTemplate !== null && $this->aProductOptionsTemplate->getId() !== $v) {
			$this->aProductOptionsTemplate = null;
		}

	} 
	
	public function setProductOptionsFilterId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_options_filter_id !== $v) {
          $this->product_options_filter_id = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID;
        }

		if ($this->aProductOptionsFilter !== null && $this->aProductOptionsFilter->getId() !== $v) {
			$this->aProductOptionsFilter = null;
		}

	} 
	
	public function setRequired($v)
	{

        if ($this->required !== $v) {
          $this->required = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::REQUIRED;
        }

	} 
	
	public function setTyp($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->typ !== $v) {
          $this->typ = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::TYP;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::OPT_NAME;
        }

	} 
	
	public function setOptDefaultValue($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_default_value !== $v) {
          $this->opt_default_value = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::OPT_DEFAULT_VALUE;
        }

	} 
	
	public function setOptStock($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_stock !== $v || $v === 0) {
          $this->opt_stock = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::OPT_STOCK;
        }

	} 
	
	public function setOptValueId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_value_id !== $v) {
          $this->opt_value_id = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::OPT_VALUE_ID;
        }

	} 
	
	public function setFieldOrder($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->field_order !== $v) {
          $this->field_order = $v;
          $this->modifiedColumns[] = ProductOptionsFieldPeer::FIELD_ORDER;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsField.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->product_options_template_id = $rs->getInt($startcol + 3);

      $this->product_options_filter_id = $rs->getInt($startcol + 4);

      $this->required = $rs->getBoolean($startcol + 5);

      $this->typ = $rs->getString($startcol + 6);

      $this->opt_name = $rs->getString($startcol + 7);

      $this->opt_default_value = $rs->getString($startcol + 8);

      $this->opt_stock = $rs->getInt($startcol + 9);

      $this->opt_value_id = $rs->getInt($startcol + 10);

      $this->field_order = $rs->getInt($startcol + 11);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsField.postHydrate', array('resultset' => $rs, 'startcol' => 12)));

            return $startcol + 12; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductOptionsField object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsField:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductOptionsFieldPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductOptionsField:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsField.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductOptionsField:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductOptionsFieldPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductOptionsFieldPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsField.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductOptionsField:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProductOptionsTemplate !== null) {
				if ($this->aProductOptionsTemplate->isModified() || $this->aProductOptionsTemplate->getCurrentProductOptionsTemplateI18n()->isModified()) {
					$affectedRows += $this->aProductOptionsTemplate->save($con);
				}
				$this->setProductOptionsTemplate($this->aProductOptionsTemplate);
			}

			if ($this->aProductOptionsFilter !== null) {
				if ($this->aProductOptionsFilter->isModified() || $this->aProductOptionsFilter->getCurrentProductOptionsFilterI18n()->isModified()) {
					$affectedRows += $this->aProductOptionsFilter->save($con);
				}
				$this->setProductOptionsFilter($this->aProductOptionsFilter);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductOptionsFieldPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductOptionsFieldPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductOptionsDefaultValues !== null) {
				foreach($this->collProductOptionsDefaultValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsValues !== null) {
				foreach($this->collProductOptionsValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsFieldI18ns !== null) {
				foreach($this->collProductOptionsFieldI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProductOptionsTemplate !== null) {
				if (!$this->aProductOptionsTemplate->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductOptionsTemplate->getValidationFailures());
				}
			}

			if ($this->aProductOptionsFilter !== null) {
				if (!$this->aProductOptionsFilter->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductOptionsFilter->getValidationFailures());
				}
			}


			if (($retval = ProductOptionsFieldPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductOptionsDefaultValues !== null) {
					foreach($this->collProductOptionsDefaultValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsValues !== null) {
					foreach($this->collProductOptionsValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsFieldI18ns !== null) {
					foreach($this->collProductOptionsFieldI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getProductOptionsTemplateId();
				break;
			case 4:
				return $this->getProductOptionsFilterId();
				break;
			case 5:
				return $this->getRequired();
				break;
			case 6:
				return $this->getTyp();
				break;
			case 7:
				return $this->getOptName();
				break;
			case 8:
				return $this->getOptDefaultValue();
				break;
			case 9:
				return $this->getOptStock();
				break;
			case 10:
				return $this->getOptValueId();
				break;
			case 11:
				return $this->getFieldOrder();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsFieldPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getProductOptionsTemplateId(),
			$keys[4] => $this->getProductOptionsFilterId(),
			$keys[5] => $this->getRequired(),
			$keys[6] => $this->getTyp(),
			$keys[7] => $this->getOptName(),
			$keys[8] => $this->getOptDefaultValue(),
			$keys[9] => $this->getOptStock(),
			$keys[10] => $this->getOptValueId(),
			$keys[11] => $this->getFieldOrder(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setProductOptionsTemplateId($value);
				break;
			case 4:
				$this->setProductOptionsFilterId($value);
				break;
			case 5:
				$this->setRequired($value);
				break;
			case 6:
				$this->setTyp($value);
				break;
			case 7:
				$this->setOptName($value);
				break;
			case 8:
				$this->setOptDefaultValue($value);
				break;
			case 9:
				$this->setOptStock($value);
				break;
			case 10:
				$this->setOptValueId($value);
				break;
			case 11:
				$this->setFieldOrder($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsFieldPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setProductOptionsTemplateId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setProductOptionsFilterId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRequired($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setTyp($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptName($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptDefaultValue($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setOptStock($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setOptValueId($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setFieldOrder($arr[$keys[11]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductOptionsFieldPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductOptionsFieldPeer::CREATED_AT)) $criteria->add(ProductOptionsFieldPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductOptionsFieldPeer::UPDATED_AT)) $criteria->add(ProductOptionsFieldPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductOptionsFieldPeer::ID)) $criteria->add(ProductOptionsFieldPeer::ID, $this->id);
		if ($this->isColumnModified(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID)) $criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->product_options_template_id);
		if ($this->isColumnModified(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID)) $criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->product_options_filter_id);
		if ($this->isColumnModified(ProductOptionsFieldPeer::REQUIRED)) $criteria->add(ProductOptionsFieldPeer::REQUIRED, $this->required);
		if ($this->isColumnModified(ProductOptionsFieldPeer::TYP)) $criteria->add(ProductOptionsFieldPeer::TYP, $this->typ);
		if ($this->isColumnModified(ProductOptionsFieldPeer::OPT_NAME)) $criteria->add(ProductOptionsFieldPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(ProductOptionsFieldPeer::OPT_DEFAULT_VALUE)) $criteria->add(ProductOptionsFieldPeer::OPT_DEFAULT_VALUE, $this->opt_default_value);
		if ($this->isColumnModified(ProductOptionsFieldPeer::OPT_STOCK)) $criteria->add(ProductOptionsFieldPeer::OPT_STOCK, $this->opt_stock);
		if ($this->isColumnModified(ProductOptionsFieldPeer::OPT_VALUE_ID)) $criteria->add(ProductOptionsFieldPeer::OPT_VALUE_ID, $this->opt_value_id);
		if ($this->isColumnModified(ProductOptionsFieldPeer::FIELD_ORDER)) $criteria->add(ProductOptionsFieldPeer::FIELD_ORDER, $this->field_order);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductOptionsFieldPeer::DATABASE_NAME);

		$criteria->add(ProductOptionsFieldPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setProductOptionsTemplateId($this->product_options_template_id);

		$copyObj->setProductOptionsFilterId($this->product_options_filter_id);

		$copyObj->setRequired($this->required);

		$copyObj->setTyp($this->typ);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDefaultValue($this->opt_default_value);

		$copyObj->setOptStock($this->opt_stock);

		$copyObj->setOptValueId($this->opt_value_id);

		$copyObj->setFieldOrder($this->field_order);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductOptionsDefaultValues() as $relObj) {
				$copyObj->addProductOptionsDefaultValue($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsValues() as $relObj) {
				$copyObj->addProductOptionsValue($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsFieldI18ns() as $relObj) {
				$copyObj->addProductOptionsFieldI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductOptionsFieldPeer();
		}
		return self::$peer;
	}

	
	public function setProductOptionsTemplate($v)
	{


		if ($v === null) {
			$this->setProductOptionsTemplateId(NULL);
		} else {
			$this->setProductOptionsTemplateId($v->getId());
		}


		$this->aProductOptionsTemplate = $v;
	}


	
	public function getProductOptionsTemplate($con = null)
	{
		if ($this->aProductOptionsTemplate === null && ($this->product_options_template_id !== null)) {
						$this->aProductOptionsTemplate = ProductOptionsTemplatePeer::retrieveByPK($this->product_options_template_id, $con);

			
		}
		return $this->aProductOptionsTemplate;
	}

	
	public function setProductOptionsFilter($v)
	{


		if ($v === null) {
			$this->setProductOptionsFilterId(NULL);
		} else {
			$this->setProductOptionsFilterId($v->getId());
		}


		$this->aProductOptionsFilter = $v;
	}


	
	public function getProductOptionsFilter($con = null)
	{
		if ($this->aProductOptionsFilter === null && ($this->product_options_filter_id !== null)) {
						$this->aProductOptionsFilter = ProductOptionsFilterPeer::retrieveByPK($this->product_options_filter_id, $con);

			
		}
		return $this->aProductOptionsFilter;
	}

	
	public function initProductOptionsDefaultValues()
	{
		if ($this->collProductOptionsDefaultValues === null) {
			$this->collProductOptionsDefaultValues = array();
		}
	}

	
	public function getProductOptionsDefaultValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				ProductOptionsDefaultValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				ProductOptionsDefaultValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
					$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;
		return $this->collProductOptionsDefaultValues;
	}

	
	public function countProductOptionsDefaultValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

		return ProductOptionsDefaultValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsDefaultValue(ProductOptionsDefaultValue $l)
	{
		$this->collProductOptionsDefaultValues[] = $l;
		$l->setProductOptionsField($this);
	}


	
	public function getProductOptionsDefaultValuesJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;

		return $this->collProductOptionsDefaultValues;
	}


	
	public function getProductOptionsDefaultValuesJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;

		return $this->collProductOptionsDefaultValues;
	}

	
	public function initProductOptionsValues()
	{
		if ($this->collProductOptionsValues === null) {
			$this->collProductOptionsValues = array();
		}
	}

	
	public function getProductOptionsValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
					$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;
		return $this->collProductOptionsValues;
	}

	
	public function countProductOptionsValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

		return ProductOptionsValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValue(ProductOptionsValue $l)
	{
		$this->collProductOptionsValues[] = $l;
		$l->setProductOptionsField($this);
	}


	
	public function getProductOptionsValuesJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsValueRelatedByProductOptionsValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}

	
	public function initProductOptionsFieldI18ns()
	{
		if ($this->collProductOptionsFieldI18ns === null) {
			$this->collProductOptionsFieldI18ns = array();
		}
	}

	
	public function getProductOptionsFieldI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFieldI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsFieldI18ns = array();
			} else {

				$criteria->add(ProductOptionsFieldI18nPeer::ID, $this->getId());

				ProductOptionsFieldI18nPeer::addSelectColumns($criteria);
				$this->collProductOptionsFieldI18ns = ProductOptionsFieldI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsFieldI18nPeer::ID, $this->getId());

				ProductOptionsFieldI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsFieldI18nCriteria) || !$this->lastProductOptionsFieldI18nCriteria->equals($criteria)) {
					$this->collProductOptionsFieldI18ns = ProductOptionsFieldI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsFieldI18nCriteria = $criteria;
		return $this->collProductOptionsFieldI18ns;
	}

	
	public function countProductOptionsFieldI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsFieldI18nPeer::ID, $this->getId());

		return ProductOptionsFieldI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsFieldI18n(ProductOptionsFieldI18n $l)
	{
		$this->collProductOptionsFieldI18ns[] = $l;
		$l->setProductOptionsField($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProductOptionsFieldI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProductOptionsFieldI18n()->setName($value);
  }

  public function getDefaultValue()
  {
    $obj = $this->getCurrentProductOptionsFieldI18n();

    return ($obj ? $obj->getDefaultValue() : null);
  }

  public function setDefaultValue($value)
  {
    $this->getCurrentProductOptionsFieldI18n()->setDefaultValue($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductOptionsFieldI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductOptionsFieldI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductOptionsFieldI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductOptionsFieldI18nForCulture(new ProductOptionsFieldI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductOptionsFieldI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductOptionsFieldI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductOptionsField.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductOptionsField:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductOptionsField::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 