<?php


abstract class BaseProductOptionsFilter extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $filter_type;


	
	protected $rank;


	
	protected $price_from;


	
	protected $price_to;

	
	protected $collProductOptionsFields;

	
	protected $lastProductOptionsFieldCriteria = null;

	
	protected $collProductOptionsFilterI18ns;

	
	protected $lastProductOptionsFilterI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getFilterType()
    {

            return $this->filter_type;
    }

    
    public function getRank()
    {

            return $this->rank;
    }

    
    public function getPriceFrom()
    {

            return $this->price_from;
    }

    
    public function getPriceTo()
    {

            return $this->price_to;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductOptionsFilterPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductOptionsFilterPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::OPT_NAME;
        }

	} 
	
	public function setFilterType($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->filter_type !== $v) {
          $this->filter_type = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::FILTER_TYPE;
        }

	} 
	
	public function setRank($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->rank !== $v) {
          $this->rank = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::RANK;
        }

	} 
	
	public function setPriceFrom($v)
	{

        if ($this->price_from !== $v) {
          $this->price_from = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::PRICE_FROM;
        }

	} 
	
	public function setPriceTo($v)
	{

        if ($this->price_to !== $v) {
          $this->price_to = $v;
          $this->modifiedColumns[] = ProductOptionsFilterPeer::PRICE_TO;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsFilter.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->filter_type = $rs->getInt($startcol + 4);

      $this->rank = $rs->getInt($startcol + 5);

      $this->price_from = $rs->getFloat($startcol + 6);

      $this->price_to = $rs->getFloat($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsFilter.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductOptionsFilter object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsFilter:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsFilterPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductOptionsFilterPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductOptionsFilter:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsFilter.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductOptionsFilter:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductOptionsFilterPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductOptionsFilterPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsFilterPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsFilter.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductOptionsFilter:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductOptionsFilterPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductOptionsFilterPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductOptionsFields !== null) {
				foreach($this->collProductOptionsFields as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsFilterI18ns !== null) {
				foreach($this->collProductOptionsFilterI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = ProductOptionsFilterPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductOptionsFields !== null) {
					foreach($this->collProductOptionsFields as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsFilterI18ns !== null) {
					foreach($this->collProductOptionsFilterI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsFilterPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getFilterType();
				break;
			case 5:
				return $this->getRank();
				break;
			case 6:
				return $this->getPriceFrom();
				break;
			case 7:
				return $this->getPriceTo();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsFilterPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getFilterType(),
			$keys[5] => $this->getRank(),
			$keys[6] => $this->getPriceFrom(),
			$keys[7] => $this->getPriceTo(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsFilterPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setFilterType($value);
				break;
			case 5:
				$this->setRank($value);
				break;
			case 6:
				$this->setPriceFrom($value);
				break;
			case 7:
				$this->setPriceTo($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsFilterPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setFilterType($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRank($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPriceFrom($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setPriceTo($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductOptionsFilterPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductOptionsFilterPeer::CREATED_AT)) $criteria->add(ProductOptionsFilterPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductOptionsFilterPeer::UPDATED_AT)) $criteria->add(ProductOptionsFilterPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductOptionsFilterPeer::ID)) $criteria->add(ProductOptionsFilterPeer::ID, $this->id);
		if ($this->isColumnModified(ProductOptionsFilterPeer::OPT_NAME)) $criteria->add(ProductOptionsFilterPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(ProductOptionsFilterPeer::FILTER_TYPE)) $criteria->add(ProductOptionsFilterPeer::FILTER_TYPE, $this->filter_type);
		if ($this->isColumnModified(ProductOptionsFilterPeer::RANK)) $criteria->add(ProductOptionsFilterPeer::RANK, $this->rank);
		if ($this->isColumnModified(ProductOptionsFilterPeer::PRICE_FROM)) $criteria->add(ProductOptionsFilterPeer::PRICE_FROM, $this->price_from);
		if ($this->isColumnModified(ProductOptionsFilterPeer::PRICE_TO)) $criteria->add(ProductOptionsFilterPeer::PRICE_TO, $this->price_to);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductOptionsFilterPeer::DATABASE_NAME);

		$criteria->add(ProductOptionsFilterPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setFilterType($this->filter_type);

		$copyObj->setRank($this->rank);

		$copyObj->setPriceFrom($this->price_from);

		$copyObj->setPriceTo($this->price_to);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductOptionsFields() as $relObj) {
				$copyObj->addProductOptionsField($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsFilterI18ns() as $relObj) {
				$copyObj->addProductOptionsFilterI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductOptionsFilterPeer();
		}
		return self::$peer;
	}

	
	public function initProductOptionsFields()
	{
		if ($this->collProductOptionsFields === null) {
			$this->collProductOptionsFields = array();
		}
	}

	
	public function getProductOptionsFields($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFields === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsFields = array();
			} else {

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->getId());

				ProductOptionsFieldPeer::addSelectColumns($criteria);
				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->getId());

				ProductOptionsFieldPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsFieldCriteria) || !$this->lastProductOptionsFieldCriteria->equals($criteria)) {
					$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsFieldCriteria = $criteria;
		return $this->collProductOptionsFields;
	}

	
	public function countProductOptionsFields($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->getId());

		return ProductOptionsFieldPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsField(ProductOptionsField $l)
	{
		$this->collProductOptionsFields[] = $l;
		$l->setProductOptionsFilter($this);
	}


	
	public function getProductOptionsFieldsJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFields === null) {
			if ($this->isNew()) {
				$this->collProductOptionsFields = array();
			} else {

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->getId());

				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID, $this->getId());

			if (!isset($this->lastProductOptionsFieldCriteria) || !$this->lastProductOptionsFieldCriteria->equals($criteria)) {
				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsFieldCriteria = $criteria;

		return $this->collProductOptionsFields;
	}

	
	public function initProductOptionsFilterI18ns()
	{
		if ($this->collProductOptionsFilterI18ns === null) {
			$this->collProductOptionsFilterI18ns = array();
		}
	}

	
	public function getProductOptionsFilterI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFilterI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsFilterI18ns = array();
			} else {

				$criteria->add(ProductOptionsFilterI18nPeer::ID, $this->getId());

				ProductOptionsFilterI18nPeer::addSelectColumns($criteria);
				$this->collProductOptionsFilterI18ns = ProductOptionsFilterI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsFilterI18nPeer::ID, $this->getId());

				ProductOptionsFilterI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsFilterI18nCriteria) || !$this->lastProductOptionsFilterI18nCriteria->equals($criteria)) {
					$this->collProductOptionsFilterI18ns = ProductOptionsFilterI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsFilterI18nCriteria = $criteria;
		return $this->collProductOptionsFilterI18ns;
	}

	
	public function countProductOptionsFilterI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsFilterI18nPeer::ID, $this->getId());

		return ProductOptionsFilterI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsFilterI18n(ProductOptionsFilterI18n $l)
	{
		$this->collProductOptionsFilterI18ns[] = $l;
		$l->setProductOptionsFilter($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProductOptionsFilterI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProductOptionsFilterI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductOptionsFilterI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductOptionsFilterI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductOptionsFilterI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductOptionsFilterI18nForCulture(new ProductOptionsFilterI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductOptionsFilterI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductOptionsFilterI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductOptionsFilter.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductOptionsFilter:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductOptionsFilter::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 