<?php


abstract class BaseProductOptionsTemplate extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;

	
	protected $collProductOptionsFields;

	
	protected $lastProductOptionsFieldCriteria = null;

	
	protected $collProductOptionsDefaultValues;

	
	protected $lastProductOptionsDefaultValueCriteria = null;

	
	protected $collProductOptionsValues;

	
	protected $lastProductOptionsValueCriteria = null;

	
	protected $collProductOptionsTemplateI18ns;

	
	protected $lastProductOptionsTemplateI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductOptionsTemplatePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductOptionsTemplatePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductOptionsTemplatePeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = ProductOptionsTemplatePeer::OPT_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsTemplate.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsTemplate.postHydrate', array('resultset' => $rs, 'startcol' => 4)));

            return $startcol + 4; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductOptionsTemplate object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsTemplate:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsTemplatePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductOptionsTemplatePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductOptionsTemplate:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsTemplate.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductOptionsTemplate:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductOptionsTemplatePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductOptionsTemplatePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsTemplatePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsTemplate.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductOptionsTemplate:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductOptionsTemplatePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductOptionsTemplatePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductOptionsFields !== null) {
				foreach($this->collProductOptionsFields as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsDefaultValues !== null) {
				foreach($this->collProductOptionsDefaultValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsValues !== null) {
				foreach($this->collProductOptionsValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsTemplateI18ns !== null) {
				foreach($this->collProductOptionsTemplateI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = ProductOptionsTemplatePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductOptionsFields !== null) {
					foreach($this->collProductOptionsFields as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsDefaultValues !== null) {
					foreach($this->collProductOptionsDefaultValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsValues !== null) {
					foreach($this->collProductOptionsValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsTemplateI18ns !== null) {
					foreach($this->collProductOptionsTemplateI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsTemplatePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsTemplatePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsTemplatePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsTemplatePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductOptionsTemplatePeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductOptionsTemplatePeer::CREATED_AT)) $criteria->add(ProductOptionsTemplatePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductOptionsTemplatePeer::UPDATED_AT)) $criteria->add(ProductOptionsTemplatePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductOptionsTemplatePeer::ID)) $criteria->add(ProductOptionsTemplatePeer::ID, $this->id);
		if ($this->isColumnModified(ProductOptionsTemplatePeer::OPT_NAME)) $criteria->add(ProductOptionsTemplatePeer::OPT_NAME, $this->opt_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductOptionsTemplatePeer::DATABASE_NAME);

		$criteria->add(ProductOptionsTemplatePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductOptionsFields() as $relObj) {
				$copyObj->addProductOptionsField($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsDefaultValues() as $relObj) {
				$copyObj->addProductOptionsDefaultValue($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsValues() as $relObj) {
				$copyObj->addProductOptionsValue($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsTemplateI18ns() as $relObj) {
				$copyObj->addProductOptionsTemplateI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductOptionsTemplatePeer();
		}
		return self::$peer;
	}

	
	public function initProductOptionsFields()
	{
		if ($this->collProductOptionsFields === null) {
			$this->collProductOptionsFields = array();
		}
	}

	
	public function getProductOptionsFields($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFields === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsFields = array();
			} else {

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsFieldPeer::addSelectColumns($criteria);
				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsFieldPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsFieldCriteria) || !$this->lastProductOptionsFieldCriteria->equals($criteria)) {
					$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsFieldCriteria = $criteria;
		return $this->collProductOptionsFields;
	}

	
	public function countProductOptionsFields($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

		return ProductOptionsFieldPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsField(ProductOptionsField $l)
	{
		$this->collProductOptionsFields[] = $l;
		$l->setProductOptionsTemplate($this);
	}


	
	public function getProductOptionsFieldsJoinProductOptionsFilter($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsFields === null) {
			if ($this->isNew()) {
				$this->collProductOptionsFields = array();
			} else {

				$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelectJoinProductOptionsFilter($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsFieldCriteria) || !$this->lastProductOptionsFieldCriteria->equals($criteria)) {
				$this->collProductOptionsFields = ProductOptionsFieldPeer::doSelectJoinProductOptionsFilter($criteria, $con);
			}
		}
		$this->lastProductOptionsFieldCriteria = $criteria;

		return $this->collProductOptionsFields;
	}

	
	public function initProductOptionsDefaultValues()
	{
		if ($this->collProductOptionsDefaultValues === null) {
			$this->collProductOptionsDefaultValues = array();
		}
	}

	
	public function getProductOptionsDefaultValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsDefaultValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsDefaultValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
					$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;
		return $this->collProductOptionsDefaultValues;
	}

	
	public function countProductOptionsDefaultValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

		return ProductOptionsDefaultValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsDefaultValue(ProductOptionsDefaultValue $l)
	{
		$this->collProductOptionsDefaultValues[] = $l;
		$l->setProductOptionsTemplate($this);
	}


	
	public function getProductOptionsDefaultValuesJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsDefaultValueRelatedByProductOptionsDefaultValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;

		return $this->collProductOptionsDefaultValues;
	}


	
	public function getProductOptionsDefaultValuesJoinProductOptionsField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsDefaultValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsDefaultValues = array();
			} else {

				$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsDefaultValueCriteria) || !$this->lastProductOptionsDefaultValueCriteria->equals($criteria)) {
				$this->collProductOptionsDefaultValues = ProductOptionsDefaultValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		}
		$this->lastProductOptionsDefaultValueCriteria = $criteria;

		return $this->collProductOptionsDefaultValues;
	}

	
	public function initProductOptionsValues()
	{
		if ($this->collProductOptionsValues === null) {
			$this->collProductOptionsValues = array();
		}
	}

	
	public function getProductOptionsValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
					$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;
		return $this->collProductOptionsValues;
	}

	
	public function countProductOptionsValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

		return ProductOptionsValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValue(ProductOptionsValue $l)
	{
		$this->collProductOptionsValues[] = $l;
		$l->setProductOptionsTemplate($this);
	}


	
	public function getProductOptionsValuesJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsValueRelatedByProductOptionsValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}

	
	public function initProductOptionsTemplateI18ns()
	{
		if ($this->collProductOptionsTemplateI18ns === null) {
			$this->collProductOptionsTemplateI18ns = array();
		}
	}

	
	public function getProductOptionsTemplateI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsTemplateI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsTemplateI18ns = array();
			} else {

				$criteria->add(ProductOptionsTemplateI18nPeer::ID, $this->getId());

				ProductOptionsTemplateI18nPeer::addSelectColumns($criteria);
				$this->collProductOptionsTemplateI18ns = ProductOptionsTemplateI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsTemplateI18nPeer::ID, $this->getId());

				ProductOptionsTemplateI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsTemplateI18nCriteria) || !$this->lastProductOptionsTemplateI18nCriteria->equals($criteria)) {
					$this->collProductOptionsTemplateI18ns = ProductOptionsTemplateI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsTemplateI18nCriteria = $criteria;
		return $this->collProductOptionsTemplateI18ns;
	}

	
	public function countProductOptionsTemplateI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsTemplateI18nPeer::ID, $this->getId());

		return ProductOptionsTemplateI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsTemplateI18n(ProductOptionsTemplateI18n $l)
	{
		$this->collProductOptionsTemplateI18ns[] = $l;
		$l->setProductOptionsTemplate($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentProductOptionsTemplateI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentProductOptionsTemplateI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductOptionsTemplateI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductOptionsTemplateI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductOptionsTemplateI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductOptionsTemplateI18nForCulture(new ProductOptionsTemplateI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductOptionsTemplateI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductOptionsTemplateI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductOptionsTemplate.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductOptionsTemplate:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductOptionsTemplate::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 