<?php


abstract class BaseProductOptionsValue extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_asset_id;


	
	protected $product_id;


	
	protected $product_options_template_id;


	
	protected $product_options_value_id;


	
	protected $product_options_field_id;


	
	protected $price;


	
	protected $lft;


	
	protected $rgt;


	
	protected $stock;


	
	protected $opt_value;


	
	protected $price_type;


	
	protected $depth;


	
	protected $opt_version = 0;


	
	protected $color;


	
	protected $opt_filter_id;


	
	protected $use_product;


	
	protected $old_price;


	
	protected $is_updated = false;

	
	protected $asfAsset;

	
	protected $aProduct;

	
	protected $aProductOptionsTemplate;

	
	protected $aProductOptionsValueRelatedByProductOptionsValueId;

	
	protected $aProductOptionsField;

	
	protected $collProductOptionsValuesRelatedByProductOptionsValueId;

	
	protected $lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = null;

	
	protected $collProductOptionsValueI18ns;

	
	protected $lastProductOptionsValueI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfAssetId()
    {

            return $this->sf_asset_id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getProductOptionsTemplateId()
    {

            return $this->product_options_template_id;
    }

    
    public function getProductOptionsValueId()
    {

            return $this->product_options_value_id;
    }

    
    public function getProductOptionsFieldId()
    {

            return $this->product_options_field_id;
    }

    
    public function getPrice()
    {

            return $this->price;
    }

    
    public function getLft()
    {

            return $this->lft;
    }

    
    public function getRgt()
    {

            return $this->rgt;
    }

    
    public function getStock()
    {

            return null !== $this->stock ? (string)$this->stock : null;
    }

    
    public function getOptValue()
    {

            return $this->opt_value;
    }

    
    public function getPriceType()
    {

            return $this->price_type;
    }

    
    public function getDepth()
    {

            return $this->depth;
    }

    
    public function getOptVersion()
    {

            return $this->opt_version;
    }

    
    public function getColor()
    {

            return $this->color;
    }

    
    public function getOptFilterId()
    {

            return $this->opt_filter_id;
    }

    
    public function getUseProduct()
    {

            return $this->use_product;
    }

    
    public function getOldPrice()
    {

            return null !== $this->old_price ? (string)$this->old_price : null;
    }

    
    public function getIsUpdated()
    {

            return $this->is_updated;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductOptionsValuePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductOptionsValuePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::ID;
        }

	} 
	
	public function setSfAssetId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_asset_id !== $v) {
          $this->sf_asset_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::SF_ASSET_ID;
        }

		if ($this->asfAsset !== null && $this->asfAsset->getId() !== $v) {
			$this->asfAsset = null;
		}

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setProductOptionsTemplateId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_options_template_id !== $v) {
          $this->product_options_template_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID;
        }

		if ($this->aProductOptionsTemplate !== null && $this->aProductOptionsTemplate->getId() !== $v) {
			$this->aProductOptionsTemplate = null;
		}

	} 
	
	public function setProductOptionsValueId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_options_value_id !== $v) {
          $this->product_options_value_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID;
        }

		if ($this->aProductOptionsValueRelatedByProductOptionsValueId !== null && $this->aProductOptionsValueRelatedByProductOptionsValueId->getId() !== $v) {
			$this->aProductOptionsValueRelatedByProductOptionsValueId = null;
		}

	} 
	
	public function setProductOptionsFieldId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_options_field_id !== $v) {
          $this->product_options_field_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID;
        }

		if ($this->aProductOptionsField !== null && $this->aProductOptionsField->getId() !== $v) {
			$this->aProductOptionsField = null;
		}

	} 
	
	public function setPrice($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->price !== $v) {
          $this->price = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRICE;
        }

	} 
	
	public function setLft($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->lft !== $v) {
          $this->lft = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::LFT;
        }

	} 
	
	public function setRgt($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->rgt !== $v) {
          $this->rgt = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::RGT;
        }

	} 
	
	public function setStock($v)
	{

        if ($this->stock !== $v) {
          $this->stock = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::STOCK;
        }

	} 
	
	public function setOptValue($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_value !== $v) {
          $this->opt_value = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::OPT_VALUE;
        }

	} 
	
	public function setPriceType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->price_type !== $v) {
          $this->price_type = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::PRICE_TYPE;
        }

	} 
	
	public function setDepth($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->depth !== $v) {
          $this->depth = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::DEPTH;
        }

	} 
	
	public function setOptVersion($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_version !== $v || $v === 0) {
          $this->opt_version = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::OPT_VERSION;
        }

	} 
	
	public function setColor($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->color !== $v) {
          $this->color = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::COLOR;
        }

	} 
	
	public function setOptFilterId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->opt_filter_id !== $v) {
          $this->opt_filter_id = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::OPT_FILTER_ID;
        }

	} 
	
	public function setUseProduct($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->use_product !== $v) {
          $this->use_product = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::USE_PRODUCT;
        }

	} 
	
	public function setOldPrice($v)
	{

        if ($this->old_price !== $v) {
          $this->old_price = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::OLD_PRICE;
        }

	} 
	
	public function setIsUpdated($v)
	{

        if ($this->is_updated !== $v || $v === false) {
          $this->is_updated = $v;
          $this->modifiedColumns[] = ProductOptionsValuePeer::IS_UPDATED;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsValue.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_asset_id = $rs->getInt($startcol + 3);

      $this->product_id = $rs->getInt($startcol + 4);

      $this->product_options_template_id = $rs->getInt($startcol + 5);

      $this->product_options_value_id = $rs->getInt($startcol + 6);

      $this->product_options_field_id = $rs->getInt($startcol + 7);

      $this->price = $rs->getString($startcol + 8);

      $this->lft = $rs->getInt($startcol + 9);

      $this->rgt = $rs->getInt($startcol + 10);

      $this->stock = $rs->getString($startcol + 11, null);

      $this->stock = $rs->getFloat($startcol + 11);

      $this->opt_value = $rs->getString($startcol + 12);

      $this->price_type = $rs->getString($startcol + 13);

      $this->depth = $rs->getInt($startcol + 14);

      $this->opt_version = $rs->getInt($startcol + 15);

      $this->color = $rs->getString($startcol + 16);

      $this->opt_filter_id = $rs->getInt($startcol + 17);

      $this->use_product = $rs->getString($startcol + 18);

      $this->old_price = $rs->getString($startcol + 19, null);

      $this->old_price = $rs->getFloat($startcol + 19);

      $this->is_updated = $rs->getBoolean($startcol + 20);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsValue.postHydrate', array('resultset' => $rs, 'startcol' => 21)));

            return $startcol + 21; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductOptionsValue object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsValue:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsValuePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductOptionsValuePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductOptionsValue:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsValue.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductOptionsValue:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductOptionsValuePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductOptionsValuePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsValuePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductOptionsValue.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductOptionsValue:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfAsset !== null) {
				if ($this->asfAsset->isModified()) {
					$affectedRows += $this->asfAsset->save($con);
				}
				$this->setsfAsset($this->asfAsset);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}

			if ($this->aProductOptionsTemplate !== null) {
				if ($this->aProductOptionsTemplate->isModified() || $this->aProductOptionsTemplate->getCurrentProductOptionsTemplateI18n()->isModified()) {
					$affectedRows += $this->aProductOptionsTemplate->save($con);
				}
				$this->setProductOptionsTemplate($this->aProductOptionsTemplate);
			}

			if ($this->aProductOptionsValueRelatedByProductOptionsValueId !== null) {
				if ($this->aProductOptionsValueRelatedByProductOptionsValueId->isModified() || $this->aProductOptionsValueRelatedByProductOptionsValueId->getCurrentProductOptionsValueI18n()->isModified()) {
					$affectedRows += $this->aProductOptionsValueRelatedByProductOptionsValueId->save($con);
				}
				$this->setProductOptionsValueRelatedByProductOptionsValueId($this->aProductOptionsValueRelatedByProductOptionsValueId);
			}

			if ($this->aProductOptionsField !== null) {
				if ($this->aProductOptionsField->isModified() || $this->aProductOptionsField->getCurrentProductOptionsFieldI18n()->isModified()) {
					$affectedRows += $this->aProductOptionsField->save($con);
				}
				$this->setProductOptionsField($this->aProductOptionsField);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductOptionsValuePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductOptionsValuePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collProductOptionsValuesRelatedByProductOptionsValueId !== null) {
				foreach($this->collProductOptionsValuesRelatedByProductOptionsValueId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsValueI18ns !== null) {
				foreach($this->collProductOptionsValueI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfAsset !== null) {
				if (!$this->asfAsset->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfAsset->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}

			if ($this->aProductOptionsTemplate !== null) {
				if (!$this->aProductOptionsTemplate->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductOptionsTemplate->getValidationFailures());
				}
			}

			if ($this->aProductOptionsValueRelatedByProductOptionsValueId !== null) {
				if (!$this->aProductOptionsValueRelatedByProductOptionsValueId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductOptionsValueRelatedByProductOptionsValueId->getValidationFailures());
				}
			}

			if ($this->aProductOptionsField !== null) {
				if (!$this->aProductOptionsField->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductOptionsField->getValidationFailures());
				}
			}


			if (($retval = ProductOptionsValuePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collProductOptionsValueI18ns !== null) {
					foreach($this->collProductOptionsValueI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsValuePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfAssetId();
				break;
			case 4:
				return $this->getProductId();
				break;
			case 5:
				return $this->getProductOptionsTemplateId();
				break;
			case 6:
				return $this->getProductOptionsValueId();
				break;
			case 7:
				return $this->getProductOptionsFieldId();
				break;
			case 8:
				return $this->getPrice();
				break;
			case 9:
				return $this->getLft();
				break;
			case 10:
				return $this->getRgt();
				break;
			case 11:
				return $this->getStock();
				break;
			case 12:
				return $this->getOptValue();
				break;
			case 13:
				return $this->getPriceType();
				break;
			case 14:
				return $this->getDepth();
				break;
			case 15:
				return $this->getOptVersion();
				break;
			case 16:
				return $this->getColor();
				break;
			case 17:
				return $this->getOptFilterId();
				break;
			case 18:
				return $this->getUseProduct();
				break;
			case 19:
				return $this->getOldPrice();
				break;
			case 20:
				return $this->getIsUpdated();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsValuePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfAssetId(),
			$keys[4] => $this->getProductId(),
			$keys[5] => $this->getProductOptionsTemplateId(),
			$keys[6] => $this->getProductOptionsValueId(),
			$keys[7] => $this->getProductOptionsFieldId(),
			$keys[8] => $this->getPrice(),
			$keys[9] => $this->getLft(),
			$keys[10] => $this->getRgt(),
			$keys[11] => $this->getStock(),
			$keys[12] => $this->getOptValue(),
			$keys[13] => $this->getPriceType(),
			$keys[14] => $this->getDepth(),
			$keys[15] => $this->getOptVersion(),
			$keys[16] => $this->getColor(),
			$keys[17] => $this->getOptFilterId(),
			$keys[18] => $this->getUseProduct(),
			$keys[19] => $this->getOldPrice(),
			$keys[20] => $this->getIsUpdated(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductOptionsValuePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfAssetId($value);
				break;
			case 4:
				$this->setProductId($value);
				break;
			case 5:
				$this->setProductOptionsTemplateId($value);
				break;
			case 6:
				$this->setProductOptionsValueId($value);
				break;
			case 7:
				$this->setProductOptionsFieldId($value);
				break;
			case 8:
				$this->setPrice($value);
				break;
			case 9:
				$this->setLft($value);
				break;
			case 10:
				$this->setRgt($value);
				break;
			case 11:
				$this->setStock($value);
				break;
			case 12:
				$this->setOptValue($value);
				break;
			case 13:
				$this->setPriceType($value);
				break;
			case 14:
				$this->setDepth($value);
				break;
			case 15:
				$this->setOptVersion($value);
				break;
			case 16:
				$this->setColor($value);
				break;
			case 17:
				$this->setOptFilterId($value);
				break;
			case 18:
				$this->setUseProduct($value);
				break;
			case 19:
				$this->setOldPrice($value);
				break;
			case 20:
				$this->setIsUpdated($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductOptionsValuePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfAssetId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setProductId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setProductOptionsTemplateId($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setProductOptionsValueId($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setProductOptionsFieldId($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setPrice($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setLft($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setRgt($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setStock($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setOptValue($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setPriceType($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setDepth($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setOptVersion($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setColor($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setOptFilterId($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setUseProduct($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setOldPrice($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setIsUpdated($arr[$keys[20]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductOptionsValuePeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductOptionsValuePeer::CREATED_AT)) $criteria->add(ProductOptionsValuePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductOptionsValuePeer::UPDATED_AT)) $criteria->add(ProductOptionsValuePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductOptionsValuePeer::ID)) $criteria->add(ProductOptionsValuePeer::ID, $this->id);
		if ($this->isColumnModified(ProductOptionsValuePeer::SF_ASSET_ID)) $criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->sf_asset_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRODUCT_ID)) $criteria->add(ProductOptionsValuePeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID)) $criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $this->product_options_template_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID)) $criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->product_options_value_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID)) $criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $this->product_options_field_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRICE)) $criteria->add(ProductOptionsValuePeer::PRICE, $this->price);
		if ($this->isColumnModified(ProductOptionsValuePeer::LFT)) $criteria->add(ProductOptionsValuePeer::LFT, $this->lft);
		if ($this->isColumnModified(ProductOptionsValuePeer::RGT)) $criteria->add(ProductOptionsValuePeer::RGT, $this->rgt);
		if ($this->isColumnModified(ProductOptionsValuePeer::STOCK)) $criteria->add(ProductOptionsValuePeer::STOCK, $this->stock);
		if ($this->isColumnModified(ProductOptionsValuePeer::OPT_VALUE)) $criteria->add(ProductOptionsValuePeer::OPT_VALUE, $this->opt_value);
		if ($this->isColumnModified(ProductOptionsValuePeer::PRICE_TYPE)) $criteria->add(ProductOptionsValuePeer::PRICE_TYPE, $this->price_type);
		if ($this->isColumnModified(ProductOptionsValuePeer::DEPTH)) $criteria->add(ProductOptionsValuePeer::DEPTH, $this->depth);
		if ($this->isColumnModified(ProductOptionsValuePeer::OPT_VERSION)) $criteria->add(ProductOptionsValuePeer::OPT_VERSION, $this->opt_version);
		if ($this->isColumnModified(ProductOptionsValuePeer::COLOR)) $criteria->add(ProductOptionsValuePeer::COLOR, $this->color);
		if ($this->isColumnModified(ProductOptionsValuePeer::OPT_FILTER_ID)) $criteria->add(ProductOptionsValuePeer::OPT_FILTER_ID, $this->opt_filter_id);
		if ($this->isColumnModified(ProductOptionsValuePeer::USE_PRODUCT)) $criteria->add(ProductOptionsValuePeer::USE_PRODUCT, $this->use_product);
		if ($this->isColumnModified(ProductOptionsValuePeer::OLD_PRICE)) $criteria->add(ProductOptionsValuePeer::OLD_PRICE, $this->old_price);
		if ($this->isColumnModified(ProductOptionsValuePeer::IS_UPDATED)) $criteria->add(ProductOptionsValuePeer::IS_UPDATED, $this->is_updated);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductOptionsValuePeer::DATABASE_NAME);

		$criteria->add(ProductOptionsValuePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfAssetId($this->sf_asset_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setProductOptionsTemplateId($this->product_options_template_id);

		$copyObj->setProductOptionsValueId($this->product_options_value_id);

		$copyObj->setProductOptionsFieldId($this->product_options_field_id);

		$copyObj->setPrice($this->price);

		$copyObj->setLft($this->lft);

		$copyObj->setRgt($this->rgt);

		$copyObj->setStock($this->stock);

		$copyObj->setOptValue($this->opt_value);

		$copyObj->setPriceType($this->price_type);

		$copyObj->setDepth($this->depth);

		$copyObj->setOptVersion($this->opt_version);

		$copyObj->setColor($this->color);

		$copyObj->setOptFilterId($this->opt_filter_id);

		$copyObj->setUseProduct($this->use_product);

		$copyObj->setOldPrice($this->old_price);

		$copyObj->setIsUpdated($this->is_updated);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getProductOptionsValuesRelatedByProductOptionsValueId() as $relObj) {
				if($this->getPrimaryKey() === $relObj->getPrimaryKey()) {
						continue;
				}

				$copyObj->addProductOptionsValueRelatedByProductOptionsValueId($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsValueI18ns() as $relObj) {
				$copyObj->addProductOptionsValueI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductOptionsValuePeer();
		}
		return self::$peer;
	}

	
	public function setsfAsset($v)
	{


		if ($v === null) {
			$this->setSfAssetId(NULL);
		} else {
			$this->setSfAssetId($v->getId());
		}


		$this->asfAsset = $v;
	}


	
	public function getsfAsset($con = null)
	{
		if ($this->asfAsset === null && ($this->sf_asset_id !== null)) {
						$this->asfAsset = sfAssetPeer::retrieveByPK($this->sf_asset_id, $con);

			
		}
		return $this->asfAsset;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}

	
	public function setProductOptionsTemplate($v)
	{


		if ($v === null) {
			$this->setProductOptionsTemplateId(NULL);
		} else {
			$this->setProductOptionsTemplateId($v->getId());
		}


		$this->aProductOptionsTemplate = $v;
	}


	
	public function getProductOptionsTemplate($con = null)
	{
		if ($this->aProductOptionsTemplate === null && ($this->product_options_template_id !== null)) {
						$this->aProductOptionsTemplate = ProductOptionsTemplatePeer::retrieveByPK($this->product_options_template_id, $con);

			
		}
		return $this->aProductOptionsTemplate;
	}

	
	public function setProductOptionsValueRelatedByProductOptionsValueId($v)
	{


		if ($v === null) {
			$this->setProductOptionsValueId(NULL);
		} else {
			$this->setProductOptionsValueId($v->getId());
		}


		$this->aProductOptionsValueRelatedByProductOptionsValueId = $v;
	}


	
	public function getProductOptionsValueRelatedByProductOptionsValueId($con = null)
	{
		if ($this->aProductOptionsValueRelatedByProductOptionsValueId === null && ($this->product_options_value_id !== null)) {
						$this->aProductOptionsValueRelatedByProductOptionsValueId = ProductOptionsValuePeer::retrieveByPK($this->product_options_value_id, $con);

			
		}
		return $this->aProductOptionsValueRelatedByProductOptionsValueId;
	}

	
	public function setProductOptionsField($v)
	{


		if ($v === null) {
			$this->setProductOptionsFieldId(NULL);
		} else {
			$this->setProductOptionsFieldId($v->getId());
		}


		$this->aProductOptionsField = $v;
	}


	
	public function getProductOptionsField($con = null)
	{
		if ($this->aProductOptionsField === null && ($this->product_options_field_id !== null)) {
						$this->aProductOptionsField = ProductOptionsFieldPeer::retrieveByPK($this->product_options_field_id, $con);

			
		}
		return $this->aProductOptionsField;
	}

	
	public function initProductOptionsValuesRelatedByProductOptionsValueId()
	{
		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			$this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
		}
	}

	
	public function getProductOptionsValuesRelatedByProductOptionsValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria) || !$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria->equals($criteria)) {
					$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = $criteria;
		return $this->collProductOptionsValuesRelatedByProductOptionsValueId;
	}

	
	public function countProductOptionsValuesRelatedByProductOptionsValueId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

		return ProductOptionsValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValueRelatedByProductOptionsValueId(ProductOptionsValue $l)
	{
		$this->collProductOptionsValuesRelatedByProductOptionsValueId[] = $l;
		$l->setProductOptionsValueRelatedByProductOptionsValueId($this);
	}


	
	public function getProductOptionsValuesRelatedByProductOptionsValueIdJoinsfAsset($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria) || !$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria->equals($criteria)) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinsfAsset($criteria, $con);
			}
		}
		$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = $criteria;

		return $this->collProductOptionsValuesRelatedByProductOptionsValueId;
	}


	
	public function getProductOptionsValuesRelatedByProductOptionsValueIdJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria) || !$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria->equals($criteria)) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = $criteria;

		return $this->collProductOptionsValuesRelatedByProductOptionsValueId;
	}


	
	public function getProductOptionsValuesRelatedByProductOptionsValueIdJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria) || !$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria->equals($criteria)) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = $criteria;

		return $this->collProductOptionsValuesRelatedByProductOptionsValueId;
	}


	
	public function getProductOptionsValuesRelatedByProductOptionsValueIdJoinProductOptionsField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValuesRelatedByProductOptionsValueId === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria) || !$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria->equals($criteria)) {
				$this->collProductOptionsValuesRelatedByProductOptionsValueId = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		}
		$this->lastProductOptionsValueRelatedByProductOptionsValueIdCriteria = $criteria;

		return $this->collProductOptionsValuesRelatedByProductOptionsValueId;
	}

	
	public function initProductOptionsValueI18ns()
	{
		if ($this->collProductOptionsValueI18ns === null) {
			$this->collProductOptionsValueI18ns = array();
		}
	}

	
	public function getProductOptionsValueI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValueI18ns === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValueI18ns = array();
			} else {

				$criteria->add(ProductOptionsValueI18nPeer::ID, $this->getId());

				ProductOptionsValueI18nPeer::addSelectColumns($criteria);
				$this->collProductOptionsValueI18ns = ProductOptionsValueI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValueI18nPeer::ID, $this->getId());

				ProductOptionsValueI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueI18nCriteria) || !$this->lastProductOptionsValueI18nCriteria->equals($criteria)) {
					$this->collProductOptionsValueI18ns = ProductOptionsValueI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueI18nCriteria = $criteria;
		return $this->collProductOptionsValueI18ns;
	}

	
	public function countProductOptionsValueI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValueI18nPeer::ID, $this->getId());

		return ProductOptionsValueI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValueI18n(ProductOptionsValueI18n $l)
	{
		$this->collProductOptionsValueI18ns[] = $l;
		$l->setProductOptionsValue($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getValue()
  {
    $obj = $this->getCurrentProductOptionsValueI18n();

    return ($obj ? $obj->getValue() : null);
  }

  public function setValue($value)
  {
    $this->getCurrentProductOptionsValueI18n()->setValue($value);
  }

  protected $current_i18n = array();

  public function getCurrentProductOptionsValueI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = ProductOptionsValueI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setProductOptionsValueI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setProductOptionsValueI18nForCulture(new ProductOptionsValueI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setProductOptionsValueI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addProductOptionsValueI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductOptionsValue.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductOptionsValue:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductOptionsValue::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 