<?php


abstract class BaseProductOptionsValuePeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_product_options_value';

	
	const CLASS_DEFAULT = 'plugins.stProductOptionsPlugin.lib.model.ProductOptionsValue';

	
	const NUM_COLUMNS = 21;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_product_options_value.CREATED_AT';

	
	const UPDATED_AT = 'st_product_options_value.UPDATED_AT';

	
	const ID = 'st_product_options_value.ID';

	
	const SF_ASSET_ID = 'st_product_options_value.SF_ASSET_ID';

	
	const PRODUCT_ID = 'st_product_options_value.PRODUCT_ID';

	
	const PRODUCT_OPTIONS_TEMPLATE_ID = 'st_product_options_value.PRODUCT_OPTIONS_TEMPLATE_ID';

	
	const PRODUCT_OPTIONS_VALUE_ID = 'st_product_options_value.PRODUCT_OPTIONS_VALUE_ID';

	
	const PRODUCT_OPTIONS_FIELD_ID = 'st_product_options_value.PRODUCT_OPTIONS_FIELD_ID';

	
	const PRICE = 'st_product_options_value.PRICE';

	
	const LFT = 'st_product_options_value.LFT';

	
	const RGT = 'st_product_options_value.RGT';

	
	const STOCK = 'st_product_options_value.STOCK';

	
	const OPT_VALUE = 'st_product_options_value.OPT_VALUE';

	
	const PRICE_TYPE = 'st_product_options_value.PRICE_TYPE';

	
	const DEPTH = 'st_product_options_value.DEPTH';

	
	const OPT_VERSION = 'st_product_options_value.OPT_VERSION';

	
	const COLOR = 'st_product_options_value.COLOR';

	
	const OPT_FILTER_ID = 'st_product_options_value.OPT_FILTER_ID';

	
	const USE_PRODUCT = 'st_product_options_value.USE_PRODUCT';

	
	const OLD_PRICE = 'st_product_options_value.OLD_PRICE';

	
	const IS_UPDATED = 'st_product_options_value.IS_UPDATED';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'SfAssetId', 'ProductId', 'ProductOptionsTemplateId', 'ProductOptionsValueId', 'ProductOptionsFieldId', 'Price', 'Lft', 'Rgt', 'Stock', 'OptValue', 'PriceType', 'Depth', 'OptVersion', 'Color', 'OptFilterId', 'UseProduct', 'OldPrice', 'IsUpdated', ),
		BasePeer::TYPE_COLNAME => array (ProductOptionsValuePeer::CREATED_AT, ProductOptionsValuePeer::UPDATED_AT, ProductOptionsValuePeer::ID, ProductOptionsValuePeer::SF_ASSET_ID, ProductOptionsValuePeer::PRODUCT_ID, ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsValuePeer::PRICE, ProductOptionsValuePeer::LFT, ProductOptionsValuePeer::RGT, ProductOptionsValuePeer::STOCK, ProductOptionsValuePeer::OPT_VALUE, ProductOptionsValuePeer::PRICE_TYPE, ProductOptionsValuePeer::DEPTH, ProductOptionsValuePeer::OPT_VERSION, ProductOptionsValuePeer::COLOR, ProductOptionsValuePeer::OPT_FILTER_ID, ProductOptionsValuePeer::USE_PRODUCT, ProductOptionsValuePeer::OLD_PRICE, ProductOptionsValuePeer::IS_UPDATED, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'sf_asset_id', 'product_id', 'product_options_template_id', 'product_options_value_id', 'product_options_field_id', 'price', 'lft', 'rgt', 'stock', 'opt_value', 'price_type', 'depth', 'opt_version', 'color', 'opt_filter_id', 'use_product', 'old_price', 'is_updated', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'SfAssetId' => 3, 'ProductId' => 4, 'ProductOptionsTemplateId' => 5, 'ProductOptionsValueId' => 6, 'ProductOptionsFieldId' => 7, 'Price' => 8, 'Lft' => 9, 'Rgt' => 10, 'Stock' => 11, 'OptValue' => 12, 'PriceType' => 13, 'Depth' => 14, 'OptVersion' => 15, 'Color' => 16, 'OptFilterId' => 17, 'UseProduct' => 18, 'OldPrice' => 19, 'IsUpdated' => 20, ),
		BasePeer::TYPE_COLNAME => array (ProductOptionsValuePeer::CREATED_AT => 0, ProductOptionsValuePeer::UPDATED_AT => 1, ProductOptionsValuePeer::ID => 2, ProductOptionsValuePeer::SF_ASSET_ID => 3, ProductOptionsValuePeer::PRODUCT_ID => 4, ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID => 5, ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID => 6, ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID => 7, ProductOptionsValuePeer::PRICE => 8, ProductOptionsValuePeer::LFT => 9, ProductOptionsValuePeer::RGT => 10, ProductOptionsValuePeer::STOCK => 11, ProductOptionsValuePeer::OPT_VALUE => 12, ProductOptionsValuePeer::PRICE_TYPE => 13, ProductOptionsValuePeer::DEPTH => 14, ProductOptionsValuePeer::OPT_VERSION => 15, ProductOptionsValuePeer::COLOR => 16, ProductOptionsValuePeer::OPT_FILTER_ID => 17, ProductOptionsValuePeer::USE_PRODUCT => 18, ProductOptionsValuePeer::OLD_PRICE => 19, ProductOptionsValuePeer::IS_UPDATED => 20, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'sf_asset_id' => 3, 'product_id' => 4, 'product_options_template_id' => 5, 'product_options_value_id' => 6, 'product_options_field_id' => 7, 'price' => 8, 'lft' => 9, 'rgt' => 10, 'stock' => 11, 'opt_value' => 12, 'price_type' => 13, 'depth' => 14, 'opt_version' => 15, 'color' => 16, 'opt_filter_id' => 17, 'use_product' => 18, 'old_price' => 19, 'is_updated' => 20, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stProductOptionsPlugin.lib.model.map.ProductOptionsValueMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = ProductOptionsValuePeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(ProductOptionsValuePeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(ProductOptionsValuePeer::CREATED_AT);

		$criteria->addSelectColumn(ProductOptionsValuePeer::UPDATED_AT);

		$criteria->addSelectColumn(ProductOptionsValuePeer::ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::SF_ASSET_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRODUCT_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRICE);

		$criteria->addSelectColumn(ProductOptionsValuePeer::LFT);

		$criteria->addSelectColumn(ProductOptionsValuePeer::RGT);

		$criteria->addSelectColumn(ProductOptionsValuePeer::STOCK);

		$criteria->addSelectColumn(ProductOptionsValuePeer::OPT_VALUE);

		$criteria->addSelectColumn(ProductOptionsValuePeer::PRICE_TYPE);

		$criteria->addSelectColumn(ProductOptionsValuePeer::DEPTH);

		$criteria->addSelectColumn(ProductOptionsValuePeer::OPT_VERSION);

		$criteria->addSelectColumn(ProductOptionsValuePeer::COLOR);

		$criteria->addSelectColumn(ProductOptionsValuePeer::OPT_FILTER_ID);

		$criteria->addSelectColumn(ProductOptionsValuePeer::USE_PRODUCT);

		$criteria->addSelectColumn(ProductOptionsValuePeer::OLD_PRICE);

		$criteria->addSelectColumn(ProductOptionsValuePeer::IS_UPDATED);

	}

	const COUNT = 'COUNT(st_product_options_value.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_product_options_value.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = ProductOptionsValuePeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return ProductOptionsValuePeer::populateObjects(ProductOptionsValuePeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsValuePeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseProductOptionsValuePeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			ProductOptionsValuePeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = ProductOptionsValuePeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinsfAsset(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinProduct(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinProductOptionsTemplate(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinProductOptionsField(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinsfAsset(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		sfAssetPeer::addSelectColumns($c);

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getSfAssetId())
                        {

			   $omClass = sfAssetPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProductOptionsValue($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinProduct(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		ProductPeer::addSelectColumns($c);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getProductId())
                        {

			   $omClass = ProductPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProductOptionsValue($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinProductOptionsTemplate(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		ProductOptionsTemplatePeer::addSelectColumns($c);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getProductOptionsTemplateId())
                        {

			   $omClass = ProductOptionsTemplatePeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProductOptionsValue($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinProductOptionsField(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		ProductOptionsFieldPeer::addSelectColumns($c);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getProductOptionsFieldId())
                        {

			   $omClass = ProductOptionsFieldPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addProductOptionsValue($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfAssetPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfAssetPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		ProductOptionsTemplatePeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsTemplatePeer::NUM_COLUMNS;

		ProductOptionsFieldPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + ProductOptionsFieldPeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = sfAssetPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfAsset(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}


					
			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}


					
			$omClass = ProductOptionsTemplatePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4 = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsTemplate(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}


					
			$omClass = ProductOptionsFieldPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5 = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getProductOptionsField(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addProductOptionsValue($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj5->initProductOptionsValues();
				$obj5->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptsfAsset(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProduct(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProductOptionsTemplate(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProductOptionsValueRelatedByProductOptionsValueId(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptProductOptionsField(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(ProductOptionsValuePeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$criteria->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$rs = ProductOptionsValuePeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptsfAsset(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		ProductPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + ProductPeer::NUM_COLUMNS;

		ProductOptionsTemplatePeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductOptionsTemplatePeer::NUM_COLUMNS;

		ProductOptionsFieldPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsFieldPeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getProduct(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsTemplatePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProductOptionsTemplate(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsFieldPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsField(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProduct(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfAssetPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfAssetPeer::NUM_COLUMNS;

		ProductOptionsTemplatePeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductOptionsTemplatePeer::NUM_COLUMNS;

		ProductOptionsFieldPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsFieldPeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfAssetPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfAsset(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsTemplatePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProductOptionsTemplate(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsFieldPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsField(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProductOptionsTemplate(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfAssetPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfAssetPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		ProductOptionsFieldPeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsFieldPeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfAssetPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfAsset(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsFieldPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsField(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProductOptionsValueRelatedByProductOptionsValueId(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfAssetPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfAssetPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		ProductOptionsTemplatePeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsTemplatePeer::NUM_COLUMNS;

		ProductOptionsFieldPeer::addSelectColumns($c);
		$startcol6 = $startcol5 + ProductOptionsFieldPeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, ProductOptionsFieldPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfAssetPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfAsset(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsTemplatePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsTemplate(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsFieldPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj5  = new $cls();
			$obj5->hydrate($rs, $startcol5);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj5 = $temp_obj1->getProductOptionsField(); 				if ($temp_obj5->getPrimaryKey() === $obj5->getPrimaryKey()) {
					$newObject = false;
					$temp_obj5->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj5->initProductOptionsValues();
				$obj5->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptProductOptionsField(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		ProductOptionsValuePeer::addSelectColumns($c);
		$startcol2 = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		sfAssetPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + sfAssetPeer::NUM_COLUMNS;

		ProductPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + ProductPeer::NUM_COLUMNS;

		ProductOptionsTemplatePeer::addSelectColumns($c);
		$startcol5 = $startcol4 + ProductOptionsTemplatePeer::NUM_COLUMNS;

		$c->addJoin(ProductOptionsValuePeer::SF_ASSET_ID, sfAssetPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_ID, ProductPeer::ID);

		$c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, ProductOptionsTemplatePeer::ID);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = ProductOptionsValuePeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = sfAssetPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getsfAsset(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initProductOptionsValues();
				$obj2->addProductOptionsValue($obj1);
			}

			$omClass = ProductPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3  = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getProduct(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj3->initProductOptionsValues();
				$obj3->addProductOptionsValue($obj1);
			}

			$omClass = ProductOptionsTemplatePeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj4  = new $cls();
			$obj4->hydrate($rs, $startcol4);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj4 = $temp_obj1->getProductOptionsTemplate(); 				if ($temp_obj4->getPrimaryKey() === $obj4->getPrimaryKey()) {
					$newObject = false;
					$temp_obj4->addProductOptionsValue($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj4->initProductOptionsValues();
				$obj4->addProductOptionsValue($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      ProductOptionsValuePeer::addSelectColumns($c);
      $startcol = (ProductOptionsValuePeer::NUM_COLUMNS - ProductOptionsValuePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      ProductOptionsValueI18nPeer::addSelectColumns($c);

      $c->addJoin(ProductOptionsValuePeer::ID, sprintf('%s AND %s = \'%s\'', ProductOptionsValueI18nPeer::ID, ProductOptionsValueI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = ProductOptionsValuePeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = ProductOptionsValueI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setProductOptionsValueI18nForCulture($obj2, $culture);
         $obj2->setProductOptionsValue($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return ProductOptionsValuePeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsValuePeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductOptionsValuePeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(ProductOptionsValuePeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseProductOptionsValuePeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseProductOptionsValuePeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseProductOptionsValuePeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseProductOptionsValuePeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(ProductOptionsValuePeer::ID);
			$selectCriteria->add(ProductOptionsValuePeer::ID, $criteria->remove(ProductOptionsValuePeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseProductOptionsValuePeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseProductOptionsValuePeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += ProductOptionsValuePeer::doOnDeleteCascade(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(ProductOptionsValuePeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(ProductOptionsValuePeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof ProductOptionsValue) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(ProductOptionsValuePeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += ProductOptionsValuePeer::doOnDeleteCascade($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = ProductOptionsValuePeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(ProductOptionsValueI18nPeer::ID, $obj->getId());
			$affectedRows += ProductOptionsValueI18nPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	public static function doValidate(ProductOptionsValue $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(ProductOptionsValuePeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(ProductOptionsValuePeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(ProductOptionsValuePeer::DATABASE_NAME, ProductOptionsValuePeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = ProductOptionsValuePeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(ProductOptionsValuePeer::DATABASE_NAME);

		$criteria->add(ProductOptionsValuePeer::ID, $pk);


		$v = ProductOptionsValuePeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(ProductOptionsValuePeer::ID, $pks, Criteria::IN);
			$objs = ProductOptionsValuePeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseProductOptionsValuePeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stProductOptionsPlugin.lib.model.map.ProductOptionsValueMapBuilder');
}
