<?php

/**
 * Optimized version of product options managment
 */
class stNewProductOptions
{
   protected static $cachePool = array();

   protected static $list_pager = null;

    protected static $list_criteria = null;

   public static function updateProduct($product, $selected_ids = array())
   {
      $debug = sfConfig::get('sf_logging_enabled') && sfConfig::get('sf_debug');

      if ($debug)
      {
         $timer = sfTimerManager::getTimer('__SOTE stNewProductOptions::updateProduct()');
      }

      if (!isset(self::$cachePool[$product->getId()]))
      {
         $options = ProductOptionsValuePeer::doSelectByProduct($product);

         $price_type = ProductOptionsValuePeer::getPriceType($product);

         self::updateProductRecursive($product, $options, $price_type, $selected_ids, $asset_image_id);

         self::updateProductImage($product, $asset_image_id);

         self::$cachePool[$product->getId()] = array(
                 'price_modifiers' => $product->getPriceModifiers(),
                 'stock' => $product->getStock(),
                 'selected_options' => $selected_ids,
                 'asset_image' => $product->getDefaultAssetImage(),
                 'image' => $product->getOptImage(),
                 'old_price' => $product->getOldPriceBrutto(),
         );
      }
      else
      {
         $cache = self::$cachePool[$product->getId()];

         $product->setPriceModifiers($cache['price_modifiers']);

         $product->setStock($cache['stock']);

         $product->setDefaultAssetImage($cache['asset_image']);

         $product->setOptImage($cache['image']);
        
         $product->setOldPriceBrutto($cache['old_price']);

         $selected_ids = $cache['selected_options'];
      }

      if ($debug)
      {
         $timer->addTime();
      }

      return $selected_ids;
   }

   public static function getSelectedOptions($product)
   {
      return isset(self::$cachePool[$product->getId()]) ? self::$cachePool[$product->getId()]['selected_options'] : array();
   }

   /**
    *
    * @param Product $product
    * @param <type> $options
    * @param <type> $price_type
    * @return <type>
    */
   public static function updateProductRecursive($product, $options, $price_type, &$selected_ids, &$asset_image_id)
   {
      if (empty($options))
      {
         return;
      }

      $selected = $options[0];

      $field_id = $options[0]->getProductOptionsFieldId();

      $last_option_id = end($options)->getId();

      foreach ($options as $option)
      {
       
         $option_id = $option->getId();

         $field = $option->getProductOptionsField();

         $selected_id = isset($selected_ids[$field_id]) ? $selected_ids[$field_id] : null;

         if ($field->getId() != $field_id)
         {
            if (null === $selected_id)
            {
               $selected_ids[$field_id] = $selected->getId();
            }

            if ($selected->getsfAssetId())
            {
               $asset_image_id = $selected->getsfAssetId();
            }

            self::addProductPriceModifier($product, $selected->getUseProductPrice($price_type), $selected->getDepth(), $price_type);

            if ($selected->hasChildren())
            {
               self::updateProductRecursive($product, $selected->getChildOptions($product->getConfiguration()->get('hide_options_with_empty_stock')), $price_type, $selected_ids, $asset_image_id);
            }
            else
            {
               self::updateProductStock($product, $selected->getUseProductStock());
               self::updateProductOldPrice($product, $selected);
            }

            $selected = $option;

            $field_id = $field->getId();
         }
         elseif ($selected_id && $selected_id == $option_id || null === $selected_id && $option->getOptValue() == $field->getOptDefaultValue() && $option->getStock()>0)
         {
             $selected = $option;
         }
        
         if (null === $selected_id && $selected->getStock()==0 && $option->getStock()>0) $selected = $option;

         if ($last_option_id == $option_id)
         {
            if (null === $selected_id)
            {
               $selected_ids[$field_id] = $selected->getId();
            }

            if ($selected->getsfAssetId())
            {
               $asset_image_id = $selected->getsfAssetId();
            }

            self::addProductPriceModifier($product, $selected->getUseProductPrice($price_type), $selected->getDepth(), $price_type);

            if ($selected->hasChildren())
            {
               self::updateProductRecursive($product, $selected->getChildOptions($product->getConfiguration()->get('hide_options_with_empty_stock')), $price_type, $selected_ids, $asset_image_id);
            }
            else
            {
               self::updateProductStock($product, $selected->getUseProductStock());
               self::updateProductOldPrice($product, $selected);
            }
         }
      }
   }

   public static function addProductPriceModifier($product, $price, $depth, $price_type, $custom = array())
   {
      if (!$price)
      {
         $value = null;

         $type = null;

         $prefix = null;
      }
      else
      {
         $prefix = $price{0} == '+' || $price{0} == '-' ? $price{0} : null;

         $type = substr($price, -1) == '%' ? 'percent' : 'numeric';

         if ($type == 'numeric')
         {
            $price = ltrim($price, '+-');

            $tax = $product->getVatValue();

            $type = 'numeric';

            if ($product->getCurrencyExchange() != 1)
            {
               $value = array('currency_brutto' => $price, 'tax' => $tax);

               $value['brutto'] = stCurrency::calculateCurrencyPrice($price, $product->getCurrencyExchange(), true);

               $value['netto'] = stPrice::extract($value['brutto'], $tax);

               $value['currency_netto'] = stCurrency::calculateCurrencyPrice($value['netto'], $product->getCurrencyExchange());
            }
            else
            {
               $value = array($price_type => $price, 'tax' => $tax);

               if ($price_type == 'netto')
               {
                  $value['brutto'] = stPrice::calculate($price, $tax);
               }
               else
               {
                  $value['netto'] = stPrice::extract($price, $tax);
               }
            }
         }
         else
         {
            $value = trim($price, '+-%');

            $type = 'percent';
         }
      }

      $product->addPriceModifier($value, $type, $prefix, $depth, $custom);
   }

   public static function updateProductStock($product, $stock)
   {
      $stock = intval($stock);

      if ($product->getStock() !== null)
      {
         $product->setStock($stock);
      }
   }

   public static function updateProductOldPrice($product, $selected)
   {
      $oldPrice = floatval($selected->getOldPrice());

      if ($oldPrice>0)
      {
         if (ProductOptionsValuePeer::getPriceType($product)== 'netto' ) $product->setOldPriceBrutto(stPrice::calculate($oldPrice, $product->getOptVat()));
         else $product->setOldPriceBrutto($oldPrice);
      }
   }

   public static function updateProductImage($product, $asset)
   {
      if ($asset)
      {
         $product->setDefaultAssetImage($asset);

         $default = $product->getDefaultAssetImage();

         if ($default)
         {
            $product->setOptImage($default->getRelativePath());
         }
      }
   }
   
   public static function copyOptions($event)
   {
   	
		$src = ProductOptionsValuePeer::getRoot($event['id']);
		if (is_object($src))
		{
			$dest = ProductOptionsValuePeer::getRoot($event['duplicate_id']);
			if (!is_object($dest))
			{
				$dest = new ProductOptionsValue();
				$dest->setProductId($event['duplicate_id']);
				$dest->makeRoot();
				$dest->save();
			}
   			self::copyDescendands($src,$dest);
   			$product = ProductPeer::retrieveByPk($event['duplicate_id']);
   			if ($product->getOptHasOptions()>1 && is_null($product->getAvailabilityId()))
   			{
   				$product->setStock(ProductOptionsValuePeer::updateStock($product));
   				$product->save();
   			}
		}
   }

   /**
   	 * Kopiowanie opcji produktu
   	 * @param object $source  element zrodlowy
   	 * @param object $dest element docelowy
   	 */
    static public function copyDescendands($source, $dest)
	{
		if(count($source->getChildren())!=0)
		{
			$transform_fields = array();
			foreach($source->getChildren() as $srcValue)
			{
				$dest = $dest->reload();

				$newChild = new ProductOptionsValue();
				$newChild->setProductId($dest->getProductId());
				$newChild->setProductOptionsTemplateId(0);

				$newChild->setCulture($srcValue->getCulture());
				$newChild->setValue($srcValue->getValue());
				$newChild->setStock($srcValue->getStock());
				$newChild->setPrice($srcValue->getPrice());
				$newChild->setPriceType($srcValue->getPriceType());
				$newChild->setSfAsset(self::getDuplicatedImageId($dest->getProductId(), $srcValue));
				$newChild->insertAsLastChildOf($dest);
				$newChild->save();

				if(empty($transform_fields[$srcValue->getProductOptionsFieldId()]))
				{
					$newField = new ProductOptionsField();
					$oldField = $srcValue->getProductOptionsField();

					$newField->setRequired($oldField->getRequired());
					$newField->setTyp($oldField->getTyp());
					$newField->setProductOptionsTemplateId(0);
					$newField->setCulture($oldField->getCulture());
					$newField->setName($oldField->getName());
					$newField->setDefaultValue($newField->getDefaultValue());
					$newField->setOptValueId($newChild->getParentId());
					$newField->save();

					foreach($oldField->getProductOptionsFieldI18ns() as $i18n)
					{
						$newField->setCulture($i18n->getCulture());
						$newField->setName($i18n->getName());
						$newField->setDefaultValue($i18n->getDefaultValue());
						$newField->save();
					}

					$transform_fields[$srcValue->getProductOptionsFieldId()] = $newField->getId();
				}
				$newChild->setProductOptionsFieldId($transform_fields[$srcValue->getProductOptionsFieldId()]);
				$newChild->save();

				foreach($srcValue->getProductOptionsValueI18ns() as $sourceI18n)
				{
					$newChild->setCulture($sourceI18n->getCulture());
					$newChild->setValue($sourceI18n->getValue());
					$newChild->setId($newChild->getId());
					$newChild->save();
				}

				self::copyDescendands($srcValue, $newChild);
				
			}
		}
	}

	public static function getDuplicatedImageId($dest_product_id, $src_option)
	{
		$src_asset = $src_option->getSfAsset();
		if (is_object($src_asset))
		{
			$src_filename = $src_asset->getFilename();
			$c = new Criteria();
			$c->add(ProductHasSfAssetPeer::PRODUCT_ID, $dest_product_id);
			$c->add(SfAssetPeer::FILENAME, $src_filename);
			$c->addJoin(SfAssetPeer::ID, ProductHasSfAssetPeer::SF_ASSET_ID);
			return SfAssetPeer::doSelectOne($c);
		}
		return null;
	}
	
	public static function clearCache($product)
	{
		$product->setPriceModifiers(array());
		if (isset(self::$cachePool[$product->getId()])) unset(self::$cachePool[$product->getId()]);
	}

    public static function getFilters($category) {
        $c = self::$list_criteria;
        $pConfig = stConfig::getInstance(null, 'stProduct');

        $old_offset = $c->getOffset();
        $old_limit = $c->getLimit();
        $c->setLimit(null);
        $c->setOffset(null);

        $c->clearSelectColumns()->clearOrderByColumns();
        if(intval($pConfig->get('hide_options_with_empty_stock'))!=0)$c->add(ProductOptionsValuePeer::STOCK,0,Criteria::GREATER_THAN);

        $c->addJoin(ProductPeer::ID, ProductOptionsValuePeer::PRODUCT_ID);
        $c->addJoin(ProductOptionsValuePeer::OPT_FILTER_ID,ProductOptionsFilterPeer::ID);
        $c->addGroupByColumn(ProductOptionsFilterPeer::ID);
        $filters = ProductOptionsFilterPeer::doSelect($c);
        $c->setLimit($old_limit);
        $c->setOffset($old_offset);        

        return $filters;
    }

    public static function getOptionsForFilter($filter, $category)
    {
        $pConfig = stConfig::getInstance(null, 'stProduct');
        $c = self::getCriteriaForFilter($category);
        $old_offset = $c->getOffset();
        $old_limit = $c->getLimit();
        $c->setLimit(null);
        $c->setOffset(null);

        $c->add(ProductOptionsValuePeer::OPT_FILTER_ID, $filter->getId());
        $c->addAscendingOrderByColumn(ProductOptionsValuePeer::OPT_VALUE);
        if(intval($pConfig->get('group_options_by_color'))!=0) $c->addGroupByColumn(ProductOptionsValuePeer::COLOR);
        else $c->addGroupByColumn(ProductOptionsValuePeer::OPT_VALUE);
        if(intval($pConfig->get('hide_options_with_empty_stock'))!=0) $c->add(ProductOptionsValuePeer::STOCK,0,Criteria::GREATER_THAN);
        $options = ProductOptionsValuePeer::doSelect($c);
        $c->setLimit($old_limit);
        $c->setOffset($old_offset);      
        return $options;
    }

    protected static function getCriteriaForFilter($category)
    {

        $c = self::$list_pager->getCriteria();
        $c->clearSelectColumns()->clearOrderByColumns();
        $c->addJoin(ProductPeer::ID, ProductOptionsValuePeer::PRODUCT_ID);
        $c->addJoin(ProductOptionsValuePeer::OPT_FILTER_ID,ProductOptionsFilterPeer::ID);
        return $c;
    }

    protected static function getFiltersForOptions($options = array())
    {
        $c = new Criteria();
        $c->add(ProductOptionsFilterPeer::ID, $options, Criteria::IN);
        return ProductOptionsFilterPeer::doSelect($c);
    }

    public static function listFilter($event)
    {
        if ($event->getSubject()->getActionName()=='list')
        {   
            $params = array();
            $price_params = array();
            foreach ($event->getSubject()->getRequest()->getParameterHolder()->getAll() as $key=>$param)
            {
                if (strpos($key,'of_')===0) {
                    $tmp = explode('_', $key);
                    $params[$tmp[1]][] = $param;
                }

                if (strpos($key,'pf_')===0) {
                    $tmp = explode('_', $key);
                    $price_params[$param] = $param;
                }
            }
            $pConfig = stConfig::getInstance(null, 'stProduct');
            $c = $event->getSubject()->product_pager->getCriteria();
            if (count($params)) {
                foreach (self::getFiltersForOptions(array_keys($params)) as $filter) {

                    $query = "((SELECT COUNT(".ProductOptionsValuePeer::ID.") FROM ".ProductOptionsValuePeer::TABLE_NAME.
                             " WHERE ".
                             ProductOptionsValuePeer::PRODUCT_ID." = ".ProductPeer::ID." AND ".
                             (intval($pConfig->get('hide_options_with_empty_stock'))!=0?ProductOptionsValuePeer::STOCK.">0 AND ":'').
                             ProductOptionsValuePeer::OPT_FILTER_ID." = ".$filter->getId()." AND ".
                             (intval($pConfig->get('group_options_by_color'))!=0?ProductOptionsValuePeer::COLOR." IN ('".implode("', '", $params[$filter->getId()]) ."')":ProductOptionsValuePeer::OPT_VALUE." IN ('".implode("', '", $params[$filter->getId()]) ."')").
                             ")>0)";
                    $cnew = $c->getNewCriterion(ProductPeer::ID,$query, Criteria::CUSTOM);
                    $c->addAnd($cnew);
                }
            }

            if (count($price_params)) {
                $c2 = new Criteria();
                $c2->add(ProductOptionsFilterPeer::FILTER_TYPE, ProductOptionsFilterPeer::PRICE_FILTER);
                $c2->add(ProductOptionsFilterPeer::ID, $price_params, Criteria::IN);

                $n2 = null;
                foreach (ProductOptionsFilterPeer::doSelect($c2) as $filter) {
                    $pcr = $c->getNewCriterion(ProductPeer::OPT_PRICE_BRUTTO, $filter->getPriceFrom(false), Criteria::GREATER_THAN);
                    $pcr->addAnd($c->getNewCriterion(ProductPeer::OPT_PRICE_BRUTTO, $filter->getPriceTo(false),Criteria::LESS_EQUAL));
                    if (is_null($n2)) $n2 = $pcr; else $n2->addOr($pcr);
                }

                $c->addAnd($n2);
            }

            self::$list_criteria = $event->getSubject()->product_pager->getCriteria();
            self::$list_pager = $event->getSubject()->product_pager;
        }
    }
    
    public static function pagerModify($event, $arguments)
    {
        foreach (sfContext::getInstance()->getRequest()->getParameterHolder()->getAll() as $key=>$param)
        {
            if (strpos($key,'of_')===0 || strpos($key,'pf_')===0) {
                $arguments['custom_for_link'][$key] = $param;
            }
        }
        return $arguments;
    }

    public static function hasFilters()
    {
        foreach (sfContext::getInstance()->getRequest()->getParameterHolder()->getAll() as $key=>$param)
        {
            if (strpos($key,'of_')===0 || strpos($key,'pf_')===0)  return true;
        }
        return false;
    }

    public static function hasFilter($fitlter_id)
    {
        foreach (sfContext::getInstance()->getRequest()->getParameterHolder()->getAll() as $key=>$param)
        {
            if (strpos($key,'of_'.$fitlter_id)===0 || strpos($key,'pf_'.$fitlter_id)===0)  return true;
        }
        return false;
    }

    public static function saveProductColors($event) 
    {
        $product = $event->getSubject();
        if (!$product->isNew()) {
            $c = new Criteria();
            $c->addJoin(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID,ProductOptionsFieldPeer::ID);
            $c->addJoin(ProductOptionsFieldPeer::PRODUCT_OPTIONS_FILTER_ID,ProductOptionsFilterPeer::ID);
            $c->add(ProductOptionsValuePeer::LFT, ProductOptionsValuePeer::RGT."-".ProductOptionsValuePeer::LFT.">0", Criteria::CUSTOM );
            $c->add(ProductOptionsValuePeer::PRODUCT_ID,$product->getId());
            $c->add(ProductOptionsFilterPeer::FILTER_TYPE,2);
            $c->addDescendingOrderByColumn(ProductOptionsValuePeer::STOCK);
            $options = ProductOptionsValuePeer::doSelect($c);
        } else {
            $options = array();
        }
        $colors = array();
        foreach ($options as $option) {
            $colors[] = array('color'=>$option->getColor(), 'stock'=>$option->getStock());
        }

        $product->setOptionsColor($colors);
    }
}
