<?php
/**
 * Klasa rozszerzająca metody modelu Product.
 * 
 * @package lib
 * @author Daniel Mendalka
 */
class stProductOptBehavior
{
    /**
     * Metoda zwraca ilość opcji jakie posiada produkt.
     * Gdy w tabeli st_product nie ma zapisanej wartości, wykonywane jest
     * odpowiednie zapytanie do bazy i zapamiętane.
     *
     * @param BaseProduct $product 
     * @return int
     */
    public function getHasOptions(BaseProduct $product)
    {
        if($product->getOptHasOptions()!==null)
        {
            return $product->getOptHasOptions();
        }
        else
        {
            $product->setOptHasOptions($product->countProductOptionsValues());
            $product->save();
            return $count;
        }
    }
    
    /**
     * Zapisuje w polu opt_has_options wartość 0
     * przy tworzeniu nowego produktu.
     *
     **/
    public function preSaveProduct(BaseProduct $product)
    {
        $product->setOptHasOptions($product->countProductOptionsValues());
    }
}