<?php
/**
 * SOTESHOP/stProductOptionsPlugin
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  libs
 */
class stProductOptionsImportExport {


    public static $toDeleteValues = array();

    public static $toDeleteFields = array();

    public static $unsetTemplate = false;
    
    public static $useLogger = true;

    /**
     * Pobiera lub tworzy dzieci dla opcji produktu
     * @param $root - id produktu lub opcji
     * @param $name - Nazwa Opcji
     * @param $optionName - Wartość opcji
     * @param $culture - werska jezykowa
     * @return object - obiekt opcji
     */
    public static function getChildForRoot($root,$name = '', $optionName = '', $culture='pl_PL' ) {
//        $filter_id = null;        
//        if (strpos($name,"~")) list($filter_id, $name) = explode('~',$name,2);
        $childs = $root->getChildren();
        $option = null;
        $optionMatch = null;
        foreach ($childs as $child) {
            $child->setCulture($culture);
            $option = $child->getProductOptionsField();
            if (is_object($option)) $option->setCulture($culture);
            if (is_object($option) && trim($option->getName()) == trim($name)) {
                $optionMatch = $option;
                if (trim($child->getValue())==trim($optionName)) {
                    if (isset(stProductOptionsImportExport::$toDeleteFields[$child->getProductOptionsField()->getId()]))
                        unset(stProductOptionsImportExport::$toDeleteFields[$child->getProductOptionsField()->getId()]);
                    if (isset(stProductOptionsImportExport::$toDeleteValues[$child->getId()]))
                        unset(stProductOptionsImportExport::$toDeleteValues[$child->getId()]);
//                    $option->setProductOptionsFilterId($filter_id);
                    $option->save();
                    return $child;
                }
            } else {
                $option = null;
            }
        }

        stProductOptionsImportExport::$unsetTemplate = true;

        if (!$optionMatch) {
            $option = new ProductOptionsField();
            $option->setCulture($culture);
            $option->setName($name);
            $option->setProductOptionsTemplateId(0);
//            $option->setProductOptionsFilterId($filter_id);
            $option->save();
        } else {
            $option = $optionMatch;
//            $option->setProductOptionsFilterId($filter_id);
            $option->save();
        }

        $child = new ProductOptionsValue();
        $child->setCulture($culture);
        $child->setValue($optionName);
        $child->setProductOptionsField($option);
        $child->insertAsLastChildOf($root);
        $child->setProductOptionsTemplateId(0);
        $child->save();

        return $child;
    }

    /**
     * Pobiera drzewo opcji dla produktu
     * @param $product_id - id produktu
     * @return object
     */
    public static function getRootForProduct($product_id) {
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, null, Criteria::ISNULL);
        $c->add(ProductOptionsValuePeer::PRODUCT_ID,$product_id);
        $optionRoot = ProductOptionsValuePeer::doSelectOne($c);

        if (!$optionRoot) {
            $optionRoot = new ProductOptionsValue();
            $optionRoot->setProductId($product_id);
            $optionRoot->makeRoot();
            $optionRoot->save();

        }
        return $optionRoot;
    }


    /**
     * Pobiera opcje danego produktu
     * @param $object - obiekt produktu
     * @return string
     */
    public static function getProductOptions(Product $object) {

        $options = $object->getProductOptionsValues();
        $optionsStock = array();

        foreach ($options as $option) {
            $pathArray = array();
            foreach($option->getPath() as $path) {
                if($path->getProductOptionsField()) {
                    $pathArray[] = stProductOptionsImportExport::encodeChar($path->getProductOptionsField()->getName());
                    $pathArray[] = stProductOptionsImportExport::encodeChar($path->getValue());
                }
            }
            if($option->getProductOptionsField()) {
                $pathArray[] = stProductOptionsImportExport::encodeChar($option->getProductOptionsField()->getName());
                $pathArray[] = stProductOptionsImportExport::encodeChar($option->getValue());

                $data = array();
                $data[]=$option->getPrice();
                $data[]=$option->getPriceType();
                $data[]=$option->getsfAssetId();
                $data[]=$option->getStock();
                $data[]=($option->getProductOptionsField()->getOptDefaultValue()==$option->getValue())?1:0;
                $optionsStock[] = implode('|',$pathArray).":".implode(',',$data);
            }

        }
        return implode("\n",$optionsStock);
    }

    /**
     * Zmiana : i | na &#58; i &#124
     * @param $text
     * @return string
     */
    public static function encodeChar($text) {
        return str_replace(array(':','|'),array('&#58;','&#124'), $text);
    }

    public static function decodeChar($text) {
        return str_replace(array('&#58;','&#124'),array(':','|'), $text);
    }

    /**
     * Ustawia dane dla opcji
     * @param $root - glowny element drzewa opcji
     * @param $path - sciezka opcji
     * @param $data - tablica z danymi
     * @param $culture - wersja jezykowa
     * @return null
     */
    public static function setDataFor($root, $path = array(), $data=array(), $culture = 'pl_PL') {
        if(!preg_match('/(^\s*[-+]\s*[0-9]+(\.[0-9]{2})?\s*$)|(^\s*[-+]\s*[0-9]+(\.[0-9]{2})?\s*%\s*$)|(^\s*[0-9]+(\.[0-9]{2})?\s*$)/', $data[0]) && strlen(trim($data[0]))) {
            stImportExportLog::getActiveLogger()->add($root->getProduct()->getCode(), sfContext::getInstance()->getI18n()->__('Niepoprawny format ceny "%data%".',array('%data%'=>$data[0])));
            return false;
        }


        for($i = 0; $i<count($path)/2; $i++) {
            $root = self::getChildForRoot($root,stProductOptionsImportExport::decodeChar($path[$i*2]),stProductOptionsImportExport::decodeChar($path[$i*2+1]), $culture);
        }

        $root->setPrice($data[0]);
        $root->setPriceType($data[1]);
        $c_asset = new Criteria();
        $c_asset->add(ProductHasSfAssetPeer::PRODUCT_ID, $root->getProduct()->getId());
        $c_asset->add(ProductHasSfAssetPeer::SF_ASSET_ID, $data[2]);
		$asset = sfAssetPeer::doSelectOne($c_asset);
        if (is_object($asset)) {
            $root->setsfAssetId($data[2]);
        }

        if ($root->isLeaf()) {
            $root->setStock($data[3]);
        }

        if ($data[4]!=0) {
            $root->getProductOptionsField()->setOptDefaultValue($root->getValue());
        }

        $root->save();
    }


    /**
     * Ustawia opcji dla produktu
     * @param $object - obiekt produktu
     * @param $value - wartosc
     * @return null
     */
    public static function setProductOptions(Product $object, $value) {
        $root = null;

        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::PRODUCT_ID,$object->getId());
        $options = ProductOptionsValuePeer::doSelect($c);

        stProductOptionsImportExport::$toDeleteValues = array();
        stProductOptionsImportExport::$toDeleteFields = array();
        stProductOptionsImportExport::$unsetTemplate = false;


        foreach ($options as $option) {
            if ($option->getOptVersion()!=ProductOptionsValuePeer::version) $option->save();
            if (!$option->isRoot()) {
                stProductOptionsImportExport::$toDeleteValues[$option->getId()] = $option;
            }
        }

        unset($options);

        $c->add(ProductOptionsValuePeer::PRODUCT_ID,$object->getId());
        $c->addJoin(ProductOptionsValuePeer::ID,ProductOptionsFieldPeer::OPT_VALUE_ID);
        $c->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID,0);
        $fields = ProductOptionsFieldPeer::doSelect($c);

        foreach ($fields as $field) {
            stProductOptionsImportExport::$toDeleteFields[$field->getId()] = $field;
        }

        unset($fields);

        $values = explode("\n",$value);
        if (count($values)) {
            foreach ($values as $option) {
                $split_pos = strrpos($option,":");
                $alldata = array(substr($option, 0, $split_pos), substr($option, $split_pos+1));
                if (isset($alldata[1])) {
                    $path = explode("|",$alldata[0]);
                    if (count($path)%2 == 0) {
                        $data = explode(",",$alldata[1]);
                        if (count($data)==5) {
                            $root = self::getRootForProduct($object->getId());
                            $root->setPriceType($data[1]);
                            $root->save();         
                            self::setDataFor($root,$path,$data, $object->getCulture());
                        } else {
                        	if (self::$useLogger) stImportExportLog::getActiveLogger()->add($object->getCode(), sfContext::getInstance()->getI18n()->__('Niewystarczająca liczba parametrów opcji, proszę podać modyfikator ceny,netto,identyfikator obrazka,stan magazynowy,domyślna opcja'));
                        	else throw new Exception('Niewystarczająca liczba parametrów opcji, proszę podać modyfikator ceny,netto,identyfikator obrazka,stan magazynowy,domyślna opcja');
                        }
                    } else {
                        if (self::$useLogger) stImportExportLog::getActiveLogger()->add($object->getCode(), sfContext::getInstance()->getI18n()->__('Błędna lina danych dla opcji produktu "%line%"', array('%line%'=>$option)));
                        else throw new Exception('Niewystarczająca liczba parametrów opcji, proszę podać modyfikator ceny,netto,identyfikator obrazka,stan magazynowy,domyślna opcja');
                    }
                } else {
                    if (self::$useLogger) stImportExportLog::getActiveLogger()->add($object->getCode(), sfContext::getInstance()->getI18n()->__('Błędna lina danych dla opcji produktu "%line%"', array('%line%'=>$option)));
                    else throw new Exception('Niewystarczająca liczba parametrów opcji, proszę podać modyfikator ceny,netto,identyfikator obrazka,stan magazynowy,domyślna opcja');
                }
            }
        }

        foreach (stProductOptionsImportExport::$toDeleteValues as $option) {
            stProductOptionsImportExport::$unsetTemplate = true;
            $option->delete();
        }

        foreach (stProductOptionsImportExport::$toDeleteFields as $field) {
            stProductOptionsImportExport::$unsetTemplate = true;
            $field->delete();
        }
        if (stProductOptionsImportExport::$unsetTemplate) {
            $root = self::getRootForProduct($object->getId());
            $root->setProductOptionsTemplateId(0);
            $root->save();
        }
        self::updateProductOptHasOptions($object);
    }

    public static function updateStockForOptions(sfEvent $event) {
        $tmp = $event->getParameters();
        $object = $tmp['modelInstance'];
        ProductOptionsValuePeer::updateTotalStock($object->getId());
    }

    public static function updateProductOptHasOptions($product) {
        $product->setOptHasOptions($product->countProductOptionsValues());
        $product->save();
    }
}
