<?php
/** 
 * SOTESHOP/stProductOptionsPlugin
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  libs
 */
class stProductOptionsPluginListener
{
    static $postClear = array();
    static $inBasket = array();
    /**
     * Podpięcie zdarzenia do generatora produktu.
     *
     * @param       sfEvent     $event
     */
    public static function generate(sfEvent $event)
    {
        // możemy wywoływać podaną metodę wielokrotnie co powoduje dołączenie kolejnych plików
        $event->getSubject()->attachAdminGeneratorFile('stProductOptionsPlugin', 'stProduct.yml');
    }

    /**
     *
     * @param sfEvent $event
     */
    public static function preExecuteOptionsEdit(sfEvent $event)
    {
        $subject = $event->getSubject();
        if(!$subject->getRequest()->hasParameter('id'))
        {
            $forward_parameters = $subject->getUser()->getAttributeHolder()->getAll('sf_admin/autoStProduct/options_forward_parameters');
            $subject->redirectIf(isset($forward_parameters['id']), 'stProduct/optionsEdit?id='.$forward_parameters['id']);
        }
    }

    /**
     * Podpięcie zdarzenia dla edycji opcji produktu.
     *
     * @param       sfEvent     $event
     */
    public static function postExecuteOptionsEdit(sfEvent $event)
    {
        $product_id = $event->getSubject()->getRequestParameter('id');

        //fix w przypadku zmiany wartosci opcji
        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::OPT_VERSION, ProductOptionsValuePeer::version, Criteria::NOT_EQUAL);
        $c->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
        $all_options = ProductOptionsValuePeer::doSelect($c);
        foreach ($all_options as $option)
        {
            $option->save();
        }

        $user = $event->getSubject()->getUser();
        if($user->hasAttribute('remeber', 'symfony/user/sfUser/attributes'))
        {
            $user->getAttributeHolder()->remove('remeber', 'symfony/user/sfUser/attributes');
            $product_id = empty($product_id) ? $user->getAttribute('id') : $product_id;
            $event->getSubject()->redirect('stProduct/optionsEdit?id='.$product_id);
        }

        $c = new Criteria();
        $c->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
        $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, null, Criteria::ISNULL);

        $root = ProductOptionsValuePeer::doSelectOne($c);

        if(!$root)
        {
            $root = new ProductOptionsValue();
            $root->setProductId($product_id);
            $root->setPriceType('netto');
            $root->makeRoot();
            $root->save();
        }

        $event->getSubject()->getContext()->root = $root;
    }

    /**
     * Podpięcie zdarzenia dla edycji szablonów opcji.
     *
     * @param sfEvent $event
     */
    public static function preExecuteOptionsTemplatesEdit(sfEvent $event)
    {
        $id = $event->getSubject()->getRequestParameter('id');

        if($event->getSubject()->getRequest()->hasParameter('remeber'))
        {
            $event->getSubject()->getUser()->setAttribute('remeber', 1);
            $event->getSubject()->redirect('stProduct/optionsTemplatesCreate');
        }

        if($id)
        {
            $c = new Criteria();
            $c->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $id);
            $c->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_DEFAULT_VALUE_ID, null, Criteria::ISNULL);
            $root = ProductOptionsDefaultValuePeer::doSelectOne($c);

            if($root === null)
            {
                $root = new ProductOptionsDefaultValue();
                $root->setProductOptionsTemplateId($id);
                $root->setPriceType('netto');
                $root->makeRoot();
                $root->save();
            }

            $event->getSubject()->getContext()->root = $root;
        }

    }

    /**
     * Funkcja wywoływana przed wyświetleniem listy szablonów opcji.
     * Usuwa szablony które nie mają określonej nazwy.
     *
     * @param sfEvent $event
     */
    public static function preExecuteOptionsTemplatesList(sfEvent $event)
    {
        if($event->getSubject()->getRequest()->hasParameter('remeber'))
        {
            $event->getSubject()->getUser()->setAttribute('remeber', 1);
            $event->getSubject()->redirect('stProduct/optionsTemplatesList');
        }
    }

    /**
     * Ustawia zawartość pola opcji przy dodawaniu nowego produtku do koszyka
     * lub oznacza produkt do usunięcia, jeśli istnieje inny z takimi samymi opcjami.
     *
     * @TODO Zweryfikowac dzialanie dla nowego frontendu
     * @TODO Usunac zbedny kod.
     */
    public static function modBasketExecuteAddItem(sfEvent $event)
    {
        if(sfContext::getInstance()->getRequest()->hasParameter('options_list'))
        {
            $options_list = sfContext::getInstance()->getRequest()->getParameter('options_list');
            sfLoader::loadHelpers(array('stProductOptions'));

            $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
            $config->load();

            $options_ids = explode('-', $options_list);

            $last_option = ProductOptionsValuePeer::retrieveByPk(end($options_ids));
            if (is_object($last_option))
            {

                if(!$event->getSubject()->getItem($event['product']->getId().'-'.$options_list))
                {
                    $event['item']->setOptions(self::createStringOptions($options_ids).$options_list);
                    $event['item']->setProductId($event['product']->getId(). '-' .$options_list);
                    if($config->get('depository_basket')==1)
                    {
                        $max_stock = get_stock_for_options($options_list);
                        $event['item']->setMaxQuantity($max_stock);
                    }
                } else
                {
                    $item = $event->getSubject()->getItem($event['product']->getId().'-'.$options_list);
                    $quantity = sfContext::getInstance()->getRequest()->getParameter('quantity',1);
                    $item->setQuantity($item->getQuantity()+$quantity);
                    $event['item']->setProductId(-1);
                }
            }
        }
        elseif($event['item']->getProduct()->getHasOptions()>1)
        {
            $event['item']->setProductId(-1);
        }
    }

    /**
     * Usuwa produkt z koszyka oznaczony przez funkcję modBasketExecuteAddItem()
     *
     * @param sfEvent $event
     */
    public static function postBasketExecuteAddItem(sfEvent $event)
    {
        if($event->getSubject()->getItem(-1))
        {
            $event->getSubject()->removeItem(-1);
        }
    }

    /**
     * Wyłącza wyświetlanie koszyka dla produktu z opcjami.
     *
     * @param sfEvent $event
     */
    public static function basketPostComponentAdd(sfEvent $event)
    {
        $subject = $event->getSubject();

        if($subject->product->getHasOptions()>1)
        {
            if(($subject->getModuleName() == 'stProduct') && ($subject->getActionName() == 'show'))
            {
                $subject->show_basket += 2;
            }
            else
            {
                $subject->enabled = false;
                if(!$subject->simple)
                {
                    $subject->show_basket += 2;
                }
            }
        }
    }

    /**
     *
     *
     * @param sfEvent $event
     */
    public static function filterMirrorOrderProduct(sfEvent $event)
    {
        $event['order_product']->setOptions($event['basket_product']->getOptions());

        return $event['order_product'];
    }

    /**
     * Tworzy łańcuch znaków z tablicy zawierającej idki opcji dla produktu.
     *
     * @param $options_ids - tablica id opcji
     */
    public static function createStringOptions($options_ids)
    {
        if(!empty($options_ids))
        {
            $result = '<ul>';
            foreach($options_ids as $option_id)
            {
                $option = ProductOptionsValuePeer::retrieveByPk($option_id);
                $result .= '<li>'.$option->getValue().'</li>';
                if($option->isLeaf())
                {
                    $id = $option->getId();
                }
            }
            $result .= '</ul>';

            return $result;
        }
    }

    public static function overrideProductPrice(sfEvent $event)
    {
        if (sfContext::hasInstance())
        {
            $product = $event->getSubject();

            if ($product->getOptHasOptions() <= 1) return;

            $request = sfContext::getInstance()->getRequest();

            if ($request->getParameter('module') == 'stProduct' && $request->getParameter('action') == 'show' && $product->getFriendlyUrl() == $request->getParameter('url'))
            {
                stNewProductOptions::updateProduct($product);
            }
        }
    }

    public static function basketGenerateItemId(sfEvent $event, $id)
    {
        if (sfContext::getInstance()->getRequest()->hasParameter('option_list')){ 
            $ids = explode('-',sfContext::getInstance()->getRequest()->getParameter('option_list'));
            $c = new Criteria();
            $c->add(ProductOptionsValuePeer::ID, $ids, Criteria::IN);
            $c->addJoin(ProductOptionsValuePeer::USE_PRODUCT, ProductPeer::CODE);
            $c->setDistinct(true);
            $quantity = sfContext::getInstance()->getRequest()->getParameter('quantity', 1);
            $subProducts = ProductPeer::doSelect($c);
            $basket = stBasket::getInstance(sfContext::getInstance()->getUser());
            if (count($subProducts)) {
                sfContext::getInstance()->getRequest()->setParameter('option_list','');
                self::$postClear = array();     
                $tmp = 0;         
                foreach ($subProducts as $product) {
                    if ($basket->getItem($product->getId())) {
                        $basket->getItem($product->getId())->setQuantity($basket->getItem($product->getId())->getQuantity()+$quantity);
                        self::$postClear = array('item'=>$product->getId(), 'quantity'=>$basket->getItem($product->getId())->getQuantity());
                    } else {
                        if (!isset(self::$inBasket[$product->getId()])) {
                            self::$inBasket[$product->getId()] = true;
                            $basket->addItem($product->getId(), $quantity, $error);
                            self::$postClear = array('item'=>$product->getId(), 'quantity'=>$quantity);
                        }
                    }
                    $tmp=$product->getId();
                }
                return $tmp;
            }
        }

        $ids = self::getRequest()->getParameter('option_list');

        if ($ids && $id == self::getRequest()->getParameter('product_id'))
        {
            return md5($id.$ids);
        }

        return $id;
    }

    public static function basketModAddItem(sfEvent $event)
    {
        $item = $event['item'];

        $product = $event['product'];

        $ids = self::getRequest()->getParameter('option_list');

        if ($ids)
        {
            $options = ProductOptionsValuePeer::retrieveByPKs(explode('-', $ids));

            $price_type = ProductOptionsValuePeer::getPriceType($product);

            $image = null;

            $stock = $item->getMaxQuantity();

            foreach ($options as $option)
            {
                $productCode = $option->getUseProduct();
                if (empty($productCode)) stNewProductOptions::addProductPriceModifier($item, $option->getUseProductPrice(), $option->getDepth(), $price_type, array('id' => $option->getId(), 'label' => $option->getValue(), 'type' => 'product_options'));

                if ($option->getsfAssetId())
                {
                    $image = $option->getsfAssetId();
                }

                if (null !== $option->getStock() && $stock > $option->getUseProductStock())
                {
                    $stock = $option->getStock();
                }
            }

            if ($image && ($sf_asset = sfAssetPeer::retrieveByPK($image)))
            {
                $item->setImage($sf_asset->getRelativePath());
            }

            if ($stock)
            {
                $item->setMaxQuantity($stock);
            }
        }
    }

    public static function preBasketExecuteAddItem(sfEvent $event)
    {
        if (sfContext::getInstance()->getRequest()->hasParameter('options_list'))
            ProductOptionsValuePeer::setSelectedItems($event['id_product'], explode('-',sfContext::getInstance()->getRequest()->getParameter('options_list')));
    }

    public static function getRequest()
    {
        static $request = null;

        if (null === $request)
        {
            $request = sfContext::getInstance()->getRequest();
        }

        return $request;
    }

    public static function postAddItem(sfEvent $event)
    {
        if (!empty(self::$postClear['item'])) {
           stBasket::getInstance(sfContext::getInstance()->getUser())->updateItem(self::$postClear['item'], self::$postClear['quantity']);
        }
    }
}
