<?php
/**
 * SOTESHOP/stProductOptionsPlugin
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  libs
 */
class stProductOptionsStockListener
{
    public static function preDecrease(sfEvent $event)
    {
        $first = true;
        if(preg_match('/[0-9\-]+$/', $event['order_product']->getOptions(), $option_list))
        {
            $option_ids = explode('-', $option_list[0]);
            foreach(ProductOptionsValuePeer::retrieveByPks($option_ids) as $option)
            {
                if($option->isLeaf() && ($option->getStock() !== null))
                {
                    $option->setStock($option->getStock() - $event['order_product']->getQuantity());
                    $option->save();
                }
            }
            $event['order_product']->getProduct()->setStock(ProductOptionsValuePeer::updateStock($event['order_product']->getProduct()));
            $event['order_product']->getProduct()->save();
        }
    }

    public static function preIncrease(sfEvent $event)
    {
        if(preg_match('/[0-9\-]+$/', $event['order_product']->getOptions(), $option_list))
        {
            $option_ids = explode('-', $option_list[0]);
            foreach(ProductOptionsValuePeer::retrieveByPks($option_ids) as $option)
            {
                if($option->isLeaf() && ($option->getStock() !== null))
                {
                    $option->setStock($option->getStock() + $event['order_product']->getQuantity());
                    $option->save();
                }
            }
            $event['order_product']->getProduct()->setStock(ProductOptionsValuePeer::updateStock($event['order_product']->getProduct()));
            $event['order_product']->getProduct()->save();
        }
    }

    public static function filterQuantityValidator(sfEvent $event)
    {
        $validator = $event['quantity_validator'];
        $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
        $config->load();
        if ($config->get('depository_basket')==1)
        {
            $id = $event['product_id'];

            if (strpos($id, '-')!==false)
            {
                sfLoader::loadHelpers(array('stProductOptions'));
                $optionsIds = explode('-', $id, 2);
                $depository = get_stock_for_options($optionsIds[1]);

                if($depository !== null)
                {
                    $validator->getParameterHolder()->set('max', $depository);
                    $validator->getParameterHolder()->set('max_error', $event->getSubject()->getContext()->getI18N()->__('W tej chwili dostępnych jest tylko %depository% sztuk tego produktu', array("%depository%" => $depository), 'stProductOptionsFrontend'));
                    $event->setReturnValue($validator);
                }
            } elseif (sfContext::getInstance()->getRequest()->hasParameter('options_list') && strlen(sfContext::getInstance()->getRequest()->getParameter('options_list'))) {
                sfLoader::loadHelpers(array('stProductOptions'));
                
                $options_list = sfContext::getInstance()->getRequest()->getParameter('options_list');
                $quantity = sfContext::getInstance()->getRequest()->getParameter('quantity',1);
                $options_ids = explode('-', $options_list);
                
                $max_stock = get_stock_for_options($options_list);
                sfContext::getInstance()->getRequest()->setError('basket{products}{'.$event['product_id'].'-'.$options_list.'}',
                        sfContext::getInstance()->getI18n()->__('W tej chwili dostępnych jest tylko %depository% sztuk tego produktu',
                        array("%depository%" => $max_stock), 'stDepositoryFrontend'));
                sfContext::getInstance()->getRequest()->setParameter('basket[products]['.$event['product_id'].'-'.$options_list.']', $quantity);

                $validator->getParameterHolder()->set('max', $max_stock);
                $validator->getParameterHolder()->set('max_error', $event->getSubject()->getContext()->getI18N()->__('W tej chwili dostępnych jest tylko %depository% sztuk tego produktu', array("%depository%" => $max_stock), 'stProductOptionsFrontend'));
                $event->setReturnValue($validator);
            }
        }
    }

    /**
     * Funkcja zapisuje dane z formularza stProduct/optionsStockList
     *
     * @param sfEvent $event
     */
    public static function preExecuteOptionsStockList(sfEvent $event)
    {
        $event->getSubject()->setFlash('notice', null);
        $event->getSubject()->getRequest()->setErrors(array());
        if(($stock_options = $event->getSubject()->getRequestParameter('stock')) &&
        !($event->getSubject()->getRequest()->hasParameter('commit_x')) &&
        !($event->getSubject()->getRequest()->getParameter('filters') == 'filters'))
        {

            foreach($stock_options as $index => $stock_option)
            {
                if(is_numeric($stock_option))
                {
                    if($stock_option < 0)
                    {
                        $event->getSubject()->getRequest()->setError('stock{'.$index.'}', 'Wprowadź nieujemną wartość');
                    }
                }
                else
                {
                    if(!empty($stock_option))
                    {
                        $event->getSubject()->getRequest()->setError('stock{'.$index.'}', 'Wporwadź wartość liczbową');
                    }
                }
            }

            if(!$event->getSubject()->getRequest()->hasErrors())
            {
                foreach($stock_options as $index => $stock_option)
                {
                    $option = ProductOptionsValuePeer::retrieveByPk($index);
                    if($stock_option === '')
                    {
                        $option->setStock(null);
                    }
                    else
                    {
                        $option->setStock($stock_option);
                    }
                    $option->save();
                }

                $product = ProductPeer::retrieveByPk($event->getSubject()->getRequestParameter('id'));
                $total = ProductOptionsValuePeer::updateStock($product);

                if(isset($total))
                {
                    $product->setStock($total);
                }
                else
                {
                    $product->setStock(null);
                }
                $product->save();
                $event->getSubject()->setFlash('notice', 'Zmiany zostały zapisane');
            }
            else
            {
                $event->getSubject()->getContext()->stock_options = $stock_options;
            }
        }

        $request = $event->getSubject()->getRequest();
        if(!$request->hasParameter('page'))
        {
            $from_params = explode('/', $request->getReferer());
            if(in_array('page', $from_params))
            {
                $request->setParameter('page', $from_params[array_search('page', $from_params)+1]);
            }
        }
    }

    public static function postExecuteOptionsStockList(sfEvent $event)
    {
       $action = $event->getSubject();

       $c = $action->pager->getCriteria();

       $c->add(ProductOptionsValuePeer::PRODUCT_ID, $action->forward_parameters['id']);

       $action->pager->init();
    }

    public static function preExecuteOptionsStockDelete(sfEvent $event)
    {
        $options = $event->getSubject()->getRequest()->getParameter('product_options_value');
        $value = $event->getSubject()->getRequest()->getParameter('value', null);
        if(count($options['selected']) > 0)
        {
            foreach($options['selected'] as $selected)
            {
                $option = ProductOptionsValuePeer::retrieveByPk($selected);
                $option->setStock($value);
                $option->save();
            }
            $product = $option->getProduct();

            foreach($product->getProductOptionsValues() as $option)
            {
                if(empty($total))
                {
                    $total = $option->getStock();
                }
                else
                {
                    $total += $option->getStock();
                }
            }
            if(empty($total))
            {
                $product->setStock(null);
            }
            else
            {
                $product->setStock($total);
            }
            $product->save();
            $event->getSubject()->getRequest()->setParameter('product_options_value', array('selected' => array()));
        }
        $request = $event->getSubject()->getRequest();
        $params = '?id='.$request->getParameter('id');
        if($request->hasParameter('page'))
        {
            $params .= '&page='.$request->getParameter('page');
        }

        $event->getSubject()->redirect('stProduct/optionsStockList'.$params);
    }

    public static function importUpdateStock(sfEvent $event) {
        $params = $event->getParameters();
        $object = $params['modelInstance'];
        if ($object->getOptHasOptions()>1 && is_null($object->getAvailabilityId()))
        {
            $object->setStock(ProductOptionsValuePeer::updateStock($object));
        }
    }
    public static function postProductSave(sfEvent $event) {
        $product = $event['modelInstance'];

        if ($product->getOptHasOptions()>1 && $event->getSubject()->getRequestParameter('product[is_depository]')==1) {
            $product->setStock(ProductOptionsValuePeer::getProductOptionsStock($product));
            $product->save();
        }
    }

    public static function validateProductConfig(sfEvent $event,$args) {
        $context = sfContext::getInstance();
        $request = $context->getRequest();

        if ($request->getMethod() == sfRequest::POST &&  $request->hasParameter('config[nb_colors_on_list]')) {
            if (intval($request->getParameter('config[nb_colors_on_list]'))<0 || !is_numeric($request->getParameter('config[nb_colors_on_list]'))) {
                $request->setError('config{nb_colors_on_list}',$context->getI18n()->__('Proszę podać liczbę całkowitą nieujemną',null,'stProductOptionsBackend'));
                $args = false;
            }
        }

        
        return $args;
    }
}
