<?php
/**
 * SOTESHOP/stProductOptionsPlugin
 *
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 13793 2011-06-22 11:29:24Z piotr $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/**
 * Akcje modułu stProductOptionsBackend
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 */
class stProductOptionsBackendActions extends autoStProductOptionsBackendActions
{
	/**
	 * Funkcja kopiująca atrybuty i wartości z szablonu do produktu.
	 */
	public function executeUseTemplate()
	{
		$template_id = $this->getRequestParameter('template');
		$option_id = $this->getRequestParameter('optionId');
		 
		$root = ProductOptionsValuePeer::retrieveByPk($option_id);

		if(!$root)
		{
			return sfView::NONE;
		}

		$c = new Criteria();
		$c->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_TEMPLATE_ID, $template_id);
		$c->add(ProductOptionsDefaultValuePeer::PRODUCT_OPTIONS_DEFAULT_VALUE_ID, null, Criteria::ISNULL);
		 
		if($root_template = ProductOptionsDefaultValuePeer::doSelectOne($c))
		{
			$this->copyDescendands($root_template, $root);
		}
		
		$root->getProduct()->setStock(ProductOptionsValuePeer::updateStock($root->getProduct()));
		$root->getProduct()->save();
		
		return sfView::HEADER_ONLY;
	}
	 
	/**
	 *
	 * @param     $source
	 * @param     $dest
	 */
	private function copyDescendands($source, $dest)
	{
		if(count($source->getChildren())!=0)
		{
			$transform_fields = array();
			foreach($source->getChildren() as $defaultValue)
			{
				$dest = $dest->reload();

				$newChild = new ProductOptionsValue();
				$newChild->setProductId($dest->getProductId());
				$newChild->setProductOptionsTemplateId(0);
                $newChild->setColor($defaultValue->getColor());

				$newChild->setCulture($defaultValue->getCulture());
				$newChild->setValue($defaultValue->getValue());
				$newChild->setPrice($defaultValue->getPrice());
				$newChild->setPriceType($defaultValue->getPriceType());
				$newChild->insertAsLastChildOf($dest);
				$newChild->save();

				if(empty($transform_fields[$defaultValue->getProductOptionsFieldId()]))
				{
					$newField = new ProductOptionsField();
					$oldField = $defaultValue->getProductOptionsField();

					$newField->setRequired($oldField->getRequired());
					$newField->setTyp($oldField->getTyp());
					$newField->setProductOptionsTemplateId(0);
					$newField->setCulture($oldField->getCulture());
					$newField->setName($oldField->getName());
                    $newField->setProductOptionsFilter($oldField->getProductOptionsFilter());    
					$newField->setDefaultValue($newField->getDefaultValue());
					$newField->setOptValueId($newChild->getParentId());
					$newField->save();

					foreach($oldField->getProductOptionsFieldI18ns() as $i18n)
					{
						$newField->setCulture($i18n->getCulture());
						$newField->setName($i18n->getName());
						$newField->setDefaultValue($i18n->getDefaultValue());
						$newField->save();
					}

					$transform_fields[$defaultValue->getProductOptionsFieldId()] = $newField->getId();
				}
				$newChild->setProductOptionsFieldId($transform_fields[$defaultValue->getProductOptionsFieldId()]);
				$newChild->save();

				foreach($defaultValue->getProductOptionsDefaultValueI18ns() as $sourceI18n)
				{
					$newChild->setCulture($sourceI18n->getCulture());
					$newChild->setValue($sourceI18n->getValue());
					$newChild->setId($newChild->getId());
					$newChild->save();
				}

				$this->copyDescendands($defaultValue, $newChild);
			}
		}
	}
	 
	/**
	 * Funkcja zwracająca component _showOption po przekazaniu do niego parametrów.
	 */
	public function executeShowOption()
	{
		$this->product_id = $this->getRequestParameter('product_id');
		$this->model = $this->getRequestParameter('model');
		$this->culture = $this->getRequestParameter('language','pl_PL');

		$config = stConfig::getInstance(sfContext::getInstance(), array('price_type' => stConfig::STRING), 'stProduct');
		$config->load();
		$this->price_type = $config->get('price_type');
	}

	/**
	 * Funkcja wyświetlająca formularz dla root'a
	 *
	 * @return sfView
	 **/
	public  function executeShowRoot()
	{
		$this->product_id = $this->getRequestParameter('product_id');
		$this->model = $this->getRequestParameter('model');
		$this->culture = $this->getRequestParameter('language','pl_PL');

		$config = stConfig::getInstance(sfContext::getInstance(), array('price_type' => stConfig::STRING), 'stProduct');
		$config->load();
		$this->price_type = $config->get('price_type');

	}

	/**
	 * Funkcja zwracająca component _showField po przekazaniu do niego parametrów.
	 */
	public function executeShowField()
	{
		$this->field_id = $this->getRequestParameter('field_id');
		$this->culture = $this->getRequestParameter('language','pl_PL');
	}

	/**
	 * Akcja która usuwa wszystkie atrybuty i wartości dla danego produktu.
	 */
	public function executeDelete()
	{
		self::delete($this->getRequestParameter('product_id'));
		$this->redirect('stProductOptionsTemplateBackend/addTemplateToProductList');
	}

	/**
	 * Funkcja usuwająca wszystkie wartości.
	 */
	public static function delete($product_id)
	{
		$c = new Criteria();
		$c->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
		$product_options = ProductOptionsValuePeer::doSelect($c);
		foreach($product_options as $product_option)
		{
			$product_option->delete();
		}
	}

	public function deleteRecurrence($model, $option_id) {
		$option = call_user_func($model.'Peer::retrieveByPk', $option_id);

		$c2 = new Criteria();
		$c2->add(constant($model.'Peer::PRODUCT_ID'),$option->getProductId());
		$c2->add(constant($model.'Peer::LFT'),$option->getLft(),Criteria::GREATER_THAN);
		$c2->add(constant($model.'Peer::RGT'),$option->getRgt(),Criteria::LESS_THAN);
		$c2->addAscendingOrderByColumn(constant($model.'Peer::RGT'));
		$options = call_user_func($model.'Peer::doSelect', $c2);

		$fields_to_delete = array();
		foreach($options as $item) {
			$fields_to_delete[$item->getProductOptionsFieldId()] = $item->getProductOptionsFieldId();
			//$item->delete();
		}

		$c3 = new Criteria();
		$c3->add(ProductOptionsFieldPeer::ID, $fields_to_delete, Criteria::IN);
		ProductOptionsFieldPeer::doDelete($c3);

		call_user_func($model.'Peer::doDelete', $c2);
		$option->delete();
	}

	public function executeFixOptions() {

	}
}
