<?php
/**
 * SOTESHOP/stProductOptionsPlugin
 *
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 16050 2011-11-10 09:16:47Z piotr $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/**
 * Akcje modułu stProductOptionsTemplateFrontend
 *
 * @package stProductOptionsPlugin
 * @subpackage stProductOptionsFrontend
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 */

class stProductOptionsFrontendActions extends stActions
{
    /**
     *
     */
    public function executeUpdateProductData()
    {
        $this->forward404Unless(SF_DEBUG || $this->getRequest()->isXmlHttpRequest());

        $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
        $hide_no_stock = $config->get('hide_options_with_empty_stock');
        ProductOptionsValuePeer::$hide_no_stock = $this->hide_no_stock = empty($hide_no_stock) ? 0 : $hide_no_stock;


        $product_id = $this->getRequestParameter('product_id');
        $result = array();

        $changed_field_id = $this->getRequestParameter('commit');
        $option_ids = $this->getRequestParameter('Options');

        if(!empty($option_ids) && !empty($changed_field_id) && !empty($product_id))
        {

            $deleted_options = array();
            foreach($option_ids as $path => $option_id)
            {
                if(preg_match('/^'.$changed_field_id.'_/', $path))
                {
                    $field_ids = explode('_', $path);
                    $field_id = end($field_ids);

                    $deleted_field = ProductOptionsFieldPeer::retrieveByPk($field_id);
                    $deleted_option = ProductOptionsValuePeer::retrieveByPk($option_id);

                    $deleted_options[$deleted_field->getName()] = $deleted_option->getValue();
                    unset($option_ids[$path]);
                }
            }

            $c = new Criteria();
            $c->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
            if ($this->hide_no_stock)
            {
                $c->add(ProductOptionsValuePeer::STOCK,0,Criteria::GREATER_THAN);
            }
            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);
            // $c->addJoin(ProductOptionsValuePeer::ID, ProductOptionsValueI18nPeer::ID);
            // $c->add(ProductOptionsValueI18nPeer::CULTURE, $this->getUser()->getCulture() ? $this->getUser()->getCulture() : 'pl_PL');

            $criteria_for_root = new Criteria();
            $criteria_for_root->add(ProductOptionsValuePeer::PRODUCT_ID, $product_id);
            $criteria_for_root->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, null, Criteria::ISNULL);
            if($root = ProductOptionsValuePeer::doSelectOne($criteria_for_root))
            {
                $parent_id = array($root->getId());
                foreach($root->getFields(null, $option_ids, $deleted_options) as $field_object)
                {
                    if($f = $this->parseObjectToArray($field_object, $c, $deleted_options, null, $parent_id))
                    {
                        $new_form[] = $f;
                    }

                    $parent_id[] = $field_object->selected;
                }
            }

            $path = '';
            foreach($new_form as $index => $new_field)
            {
                $path .= '-'.$new_field['selected'];
                if($new_field['name']==null || !count($new_field['options']))
                {
                    unset($new_form[$index]);
                }
            }

            $path = trim($path, '-');

            if(empty($selected_option))
            {
                $selected_option = ProductOptionsValuePeer::retrieveByPk($option_ids[$changed_field_id]);
            }

            sfLoader::loadHelpers(array('stProductOptions'));
            $update_data = get_update_data($selected_option, $path);
            $parts = explode('?', @$update_data['src']);

            $update_data['src'] = $parts[0];
            @$update_data['src_timestamp'] = $parts[1];
            if($this->hide_no_stock && isset($this->hided_field) && $this->hided_field)
            {
                $update_data['check_stock'] = 1;
                $update_data['stock'] = 0;
            }

            $result = array(
                    'new_form' => $new_form,
                    'to_update' => array_merge(array('options_list' => $path), $update_data)
            );
        }

        if (SF_DEBUG && !$this->getRequest()->isXmlHttpRequest())
        {
            sfLoader::loadHelpers(array('Partial', 'stPartial'));
            $json = st_get_partial('stProductOptionsFrontend/json', array('data' => $result));
        }
        else
        {
            $this->getResponse()->setHttpHeader('Content-type', 'application/json');
            $json = json_encode($result);
        }
        $this->setLayout(false);
        return $this->renderText($json);
    }

    private function parseObjectToArray($new_field, $c, $selected = null, $field_path = null, $parent_id)
    {
        sfLoader::loadHelpers(array('stProductOptions', 'stCurrency'));
        $new_array = array();
        $new_options = $new_field->getProductOptionsValues($c);

        if(count($new_options)==0)
        {
            return null;
        }

        foreach($new_options as $index => $new_option)
        {
            $tmp = array();

            if($new_option->getValue()!=null
                    && (!$this->hide_no_stock || ($new_option->getStock() === null) || ($new_option->getStock() > 0))
                    && (empty($parent_id) || in_array($new_option->getProductOptionsValueId(), $parent_id)))
            {
                $tmp['label'] = urlencode(htmlentities(str_replace('+', '_plus_',$new_option->getValue()),ENT_QUOTES,'UTF-8'));

                ProductOptionsValuePeer::setSelectedItems($new_option->getProduct()->getId(), array($new_option->getId()));
                $tmp['price'] = $new_option->getProduct()->getPriceNetto();
                ProductOptionsValuePeer::setSelectedItems($new_option->getProduct()->getId(), array($new_option->getId()));
                $tmp['price_brutto'] = $new_option->getProduct()->getPriceBrutto();
//$tmp['price'] = $new_option->isLeaf()?", ".st_price(modify_price($new_option,null,null,'brutto'),true, true):"";
                $tmp['modify'] = urlencode($new_option->getPrice());
                $tmp['stock'] = $new_option->getStock();
                $tmp['id'] = $new_option->getId();
                $new_array[$new_option->getId()] = $tmp;
            }
            else
            {
                unset($new_options[$index]);
            }
        }

        if(!is_array($new_options) || (count($new_options) == 0))
        {
            $this->hided_field = true;
            return null;
        }

        $new['options'] = $new_array;
        $new['name'] = urlencode(htmlentities(str_replace('+', '_plus_',$new_field->getName()),ENT_QUOTES,'UTF-8'));

        if(is_array($selected))
        {
            if(!empty($selected[$new_field->getName()]))
            {
                $value = htmlentities(str_replace('+', '_plus_', $selected[$new_field->getName()]), ENT_NOQUOTES, 'UTF-8');
                foreach($new_array as $check_option)
                {
                    if(array_search($value, $check_option, true) == 'label')
                    {
                        $new['selected'] = $check_option['id'];
                    }
                }
            }

            if(empty($new['selected']))
            {
                $new['selected'] = $new_field->selected;
            }
        }
        else
        {
            if($selected)
            {
                $new['selected'] = $selected;
            }
            elseif($new_field->selected!=null)
            {
                $new['selected'] = $new_field->selected;
            }

            if($new['selected']==null)
            {
                $new['selected'] = key(current($new['options']));
            }
        }
        $new['path'] = $field_path ? $field_path : $new_field->path;

        return $new;
    }



    public function executeChangeOptionFromGallery()
    {
        $product_id = $this->getRequestParameter('product_id');
        $image_id = $this->getRequestParameter('image_id');

        $options = $this->getRequestParameter('st_product_options');

        $field_ids = array_keys($options);



        $c = new Criteria();

        $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_FIELD_ID, $field_ids, Criteria::IN);

        $c->add(ProductOptionsValuePeer::SF_ASSET_ID, $image_id);

        $option = ProductOptionsValuePeer::doSelectOne($c);


        //die($option->getProductOptionsFieldId().':'.$option->getId());

        $options[$option->getProductOptionsFieldId()] = $option->getId();

        $this->getRequest()->setParameter('st_product_options', $options);

        $this->getRequest()->setParameter('change_field', $option->getProductOptionsFieldId());

        return $this->executeAjaxNewUpdateProduct();
    }


    public function executeUpdateProductOptions()
    {
        $tmp = json_decode($this->getRequestParameter('json'));
        $this->fields = $tmp->new_form;
        $this->smarty = new stSmarty('stProductOptionsFrontend');
    }

    public function executeAjaxNewUpdateProduct()
    {
        $product = ProductPeer::retrieveByPK($this->getRequestParameter('product_id'));

        if (null === $product)
        {
            return sfView::HEADER_ONLY;
        }

        $options = $this->getRequestParameter('st_product_options');

        $selected_field = $this->getRequestParameter('change_field');

        $selected_ids = array();

        foreach ($options as $field_id => $option_id)
        {
            $selected_ids[$field_id] = $option_id;

            if ($field_id == $selected_field)
            {
                break;
            }
        }

        sfLoader::loadHelpers(array('Helper','stCurrency', 'stUrl', 'stProductImage'));

        $selected_options = stNewProductOptions::updateProduct($product, $selected_ids);

        $smarty = new stSmarty('stBasket');

        $this->responseUpdateElement('st_product_options-modify-basket', array(
                'module' => 'stProductOptionsFrontend',
                'component' => 'modifyBasketView',
                'params' => array(
                        'product' => $product,
                        'selected_options' => $selected_options,
                        'smarty' => $smarty,
                        'info' => true)), false);
        
        $this->responseUpdateElement('st_depository_stock_amount-value', $product->getStock(), false);

        $this->responseUpdateElement('st_availability_info', array(
                'module' => 'stAvailabilityFrontend',
                'component' => 'availability',
                'params' => array('product' => $product)
                    ),false);

        //$this->responseUpdateElement('st_availability_info-value', $product->getFrontendAvailability(), false);
        
        //if ($product->getFrontendAvailability()->getColor()) $this->responseEvalJs("$('st_availability_info-value').style.color = '#".$product->getFrontendAvailability()->getColor()."'");

        $this->responseUpdateElement('st_product_options-old_price', st_currency_format($product->getOldPriceBrutto(true)), false);

        $this->responseUpdateElement('st_product_options-old_price_net', st_currency_format($product->getOldPriceNetto(true)), false);

        $this->responseUpdateElement('st_product_options-price-netto', st_currency_format($product->getPriceNetto(true)), false);

        $this->responseUpdateElement('st_product_options-price-brutto', st_currency_format($product->getPriceBrutto(true)), false);

        if ($product->hasDiscount())
        {
            $this->responseUpdateElement('st_product_options-discount-netto', st_currency_format($product->getDiscountNetto(true)), false);

            $this->responseUpdateElement('st_product_options-discount-brutto', st_currency_format($product->getDiscountBrutto(true)), false);

            $this->responseUpdateElement('st_product_options-catalogue-netto', st_currency_format($product->getPriceNetto(true, false)), false);

            $this->responseUpdateElement('st_product_options-catalogue-brutto', st_currency_format($product->getPriceBrutto(true, false)), false);
        }

$js =<<<JS
jQuery(function($)
{

$('#st_product-default-image-link').removeData('jqzoom');

$('#st_product-default-image-link').jqzoom({
        zoomType: 'innerzoom',
        lens:true,
        preloadImages: true,
        zoomWidth: 260,
        zoomHeight: 260,
        showEffect : 'fadein',
        hideEffect: 'fadeout'
        });
});


JS;

        $this->responseEvalJs(sprintf("$('st_product-default-image').src = '%s'; $('st_product-default-image-link').href= '%s'", st_product_image_path($product, 'large'), st_url_for('@stProductShowImage?folder=' . $product->getOptImageFolderId() . '&image=' . $product->getOptImageFilename())));

        if ($this->getController()->getTheme()->getVersion() >= 2)
        {
            $this->responseEvalJs($js);
        }

        return $this->renderResponse();
    }

}
