<?php
/** 
 * SOTESHOP/stProductOptionsPlugin
 *
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: components.class.php 16186 2011-11-23 09:25:51Z piotr $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/** 
 * Komponenty dla modułu stProductOptionsFrontend
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 */
class stProductOptionsFrontendComponents extends sfComponents
{


   /**
    *
    */
   public function executeBasketProductImage()
   {
      sfLoader::loadHelpers(array('stProductOptions'));
      if(preg_match('/[0-9\-]+$/', $this->product->getOptions(), $option_ids)
              && $asset = get_asset_data_for_options($option_ids[0], null, true))
      {
         $this->asset = $asset;
      }
      elseif($this->product->getProduct())
      {
         $this->asset = $this->product->getProduct()->getOptImage();
      }
   }

   /**
    *
    */
   public function executeModifyBasketView()
   {
      $this->basket_config = stConfig::getInstance($this->getContext(), 'stBasket');

      $this->product_config = $this->product->getConfiguration();

      if (null === $this->selected_options)
      {
         $this->selected_options = stNewProductOptions::getSelectedOptions($this->product);
      }

      if (null === $this->info)
      {
         $this->info = false;
      }

      if (null === $this->enabled)
      {
         $this->enabled = $this->product_config->get('depository_basket') == false || $this->product->getStock() > 0;
      }

      $this->options_smarty = new stSmarty('stProductOptionsFrontend');

//        $this->getController()->getDispatcher()->notify(new sfEvent($this, 'stProductOptionsFrontendComponents.modifyBasketView'));
   }

   public function executeProductOptionsTemplate()
   {
      $this->smarty = new stSmarty('stProductOptionsFrontend');
   }

   /**
    *
    */
   public function executeProductOptions()
   {
      if($this->product)
      {
         $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
         $hide_no_stock = $config->get('hide_options_with_empty_stock');
         ProductOptionsValuePeer::$hide_no_stock = $this->hide_no_stock = empty($hide_no_stock) ? 0 : $hide_no_stock;

         $c = new Criteria();
         $c->add(ProductOptionsValuePeer::PRODUCT_ID, $this->product->getId());
         $c->add(ProductOptionsValuePeer::PRODUCT_OPTIONS_VALUE_ID, null, Criteria::ISNULL);
         $root = ProductOptionsValuePeer::doSelectOne($c);

         if($root)
         {
            $root->setCulture($this->getUser()->getCulture());
            $fields = $root->getFields();
            $c = new Criteria();
            $c->add(ProductOptionsValuePeer::PRODUCT_ID, $this->product->getId());
            if ($this->hide_no_stock)
            {
               $c->add(ProductOptionsValuePeer::STOCK,0,Criteria::GREATER_THAN);
            }
            $c->addAscendingOrderByColumn(ProductOptionsValuePeer::LFT);
            // $c->addJoin(ProductOptionsValuePeer::ID, ProductOptionsValueI18nPeer::ID);
            // $c->add(ProductOptionsValueI18nPeer::CULTURE, $this->getUser()->getCulture() ? $this->getUser()->getCulture() : 'pl_PL');
            $this->c = $c;
         }

         $path = '';
         if(!empty($fields) && count($fields) > 0)
         {
            foreach($fields as $index => $field)
            {
               if($field->getName()==null || $field->countProductOptionsValues($c) == 0)
               {
                  unset($fields[$index]);
               }
               else
               {
                  $path .= '-'.$field->selected;
               }
            }

            $path = trim($path, '-');

            if(!empty($fields) && count($fields) > 0)
            {
               $last_field = end($fields);

               $last_option = ProductOptionsValuePeer::retrieveByPkWithProduct($last_field->selected);

               sfLoader::loadHelpers(array('stProductOptions'));
               $this->update_data = json_encode(array_merge(array('options_list' => $path), get_update_data($last_option, $path)));
               $this->fields = $fields;
            }
         } else
         {
            $c = new Criteria();
            $c->add(ProductOptionsValuePeer::PRODUCT_ID,$this->product->getId());
            $c->add(ProductOptionsValuePeer::DEPTH,0);
            $last_option = ProductOptionsValuePeer::doSelectOne($c);



            sfLoader::loadHelpers(array('stProductOptions'));
            $this->update_data = json_encode(array_merge(array('options_list' => $path), get_update_data($last_option, null)));
         }
      }

      $this->smarty = new stSmarty('stProductOptionsFrontend');
   }

   /**
    * Displays hidden inputs inside basket_form
    * for passing selected options ids
    */
   public function executeGetProductOptions()
   {
      $this->smarty = new stSmarty('stProductOptionsFrontend');
   }


    public function executeFilter()
    {
        $this->productConfig = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
        if ($this->getContext()->getModuleName() != 'stProduct' || $this->getContext()->getActionName() != 'list') return sfView::NONE;
        $url = $this->getRequest()->getParameter('url');
        $c = new Criteria();
        $c->addJoin(CategoryI18nPeer::ID, CategoryPeer::ID);
        $c->add(CategoryI18nPeer::URL, $url);
        $this->category = CategoryPeer::doSelectOne($c);
        $this->filters = stNewProductOptions::getFilters($this->category);
        $this->smarty = new stSmarty('stProductOptionsFrontend');

        $this->action = $this->getContext()->getActionName();
        $this->module = $this->getContext()->getModuleName();
        $this->url = $this->getRequestParameter('url');

        $this->params = array();
        foreach ($this->filters as $filter)
        {
            $this->params[$filter->getId()] = array();
        }

        foreach ($this->getRequest()->getParameterHolder()->getAll() as $key=>$param)
        {
            if (strpos($key,'of_')===0) {
               $tmp = explode('_', $key);
               $this->params[$tmp[1]][] = $param;
            }
        }
        $c = new Criteria();
        $c->add(ProductOptionsFilterPeer::FILTER_TYPE, ProductOptionsFilterPeer::PRICE_FILTER);
        $c->addAscendingOrderByColumn(ProductOptionsFilterPeer::PRICE_FROM);

        $this->price_filters = ProductOptionsFilterPeer::doSelect($c);

        if (count($this->filters)+count($this->price_filters)==0) return sfView::NONE;

    }

    public function executeColors() {
        $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
        $hide_no_stock = $config->get('hide_options_with_empty_stock');
        $nb_colors_on_list = $config->get('nb_colors_on_list');
        $show_colors_on_list = $config->get('show_colors_on_list',0);
        if ($show_colors_on_list == 0) return sfView::NONE;

        $colors = $this->product->getOptionsColor();
        $this->avail_colors = array();

        foreach ($colors as $key=>$value) {
            if ($hide_no_stock && $value['stock']>0) $this->avail_colors[] = $value;
            elseif (!$hide_no_stock) $this->avail_colors[] = $value;
        }

        if (count($this->avail_colors) == 0) return sfView::NONE;

        if($nb_colors_on_list>0 ) $this->avail_colors = array_slice($this->avail_colors, 0, $nb_colors_on_list);
        
        $this->smarty = new stSmarty('stProductOptionsFrontend');
    }
}
