<?php
use_helper('stUrl', 'stProductOptions');

sfLoader::loadHelpers('stProduct', 'stProduct');

use_javascript('stPrice.js');

st_theme_use_stylesheet('stProductOptionsPlugin.css');

if ($info)
{    
   $options_smarty->assign('options', st_product_options_get_form($product, $selected_options));

   $options_smarty->display('options_form.html');


   if (!$product_config->get('hide_basket'))
   {
      $smarty->assign('product_id', $product->getId());

      if ($product_config->get('show_basket_quantity'))
      {
         $smarty->assign('form_action', st_secure_url_for('stBasket/addReferer?product_id='.$product->getId().'&option_list='.implode('-', $selected_options)));
         
         if ($product->getStepQty())
         {
            $smarty->assign('quantity_field', st_product_quantity_list('quantity', $product, null, array('disabled' => !$enabled)).' '.st_product_uom($product));
         }
         else
         {
            $smarty->assign('quantity_field', input_tag('quantity', $product->getMinQty(), array(
                                'size' => 3,
                                'maxlength' => 11,
                                'style' => 'text-align:right',
                                'disabled' => !$enabled,
                                'onchange' => 'this.value = stPrice.fixNumberFormat(this.value, '.($product->getStockInDecimals() ? 2 : 0).');'                
                            )).' '.st_product_uom($product));
         }
      }
      else
      {
         $smarty->assign('form_action', st_secure_url_for('stBasket/addReferer?product_id='.$product->getId().'&quantity='.$product->getMinQty().'&option_list='.implode('-', $selected_options)));
      }
      
      $smarty->assign('submit_button', submit_tag(__('Dodaj do koszyka', null, 'stBasket'), array('class' => 'st_button-basket-submit-enabled', 'disabled' => $enabled == false)));

      $smarty->display('basket_add_quantity_enabled.html');
   }
}
else
{
   if (!$simple && !$product_config->get('hide_basket'))
   {
      $smarty->assign('basket_add_enable', st_link_to(__('Wybierz opcje produktu'), 'stProduct/show?url='.$product->getFriendlyUrl(), array('class' => "st_button_options_basket")));

      $smarty->display('basket_add_enabled.html');
   }
}
?>
<?php if ($info): ?>
   <script type="text/javascript">
      function send_form() {}
      function change_color(field, option_id) {
         $(field).value = option_id;
      }
      $$('div.product_options-color-filter-box').each(function(e) {
         e.observe('click', function() {
            var parent = $('st_update_product_options_form');

            var params = parent.serialize(true);

            params.change_field = this.id.replace('color_st_product_options_', '');

            $('st_basket-add-to-basket-form').disable();
            new Ajax.Request('<?php echo url_for('stProductOptionsFrontend/ajaxNewUpdateProduct?product_id='.$product->getId()) ?>',
            {
               onSuccess: function()
               {
                  parent.enable();

                  $('st_basket-add-to-basket-form').enable();
               },
               evalJS: true,
               parameters: params
            });
         });
      });

      $$('select.st_product_options_select').each(function(e) {
         e.observe('change', function() {

            var parent = $(this.form);

            var params = parent.serialize(true);

            params.change_field = this.id.replace('st_product_options_', '');

            parent.disable();

            $('st_basket-add-to-basket-form').disable();

            new Ajax.Request('<?php echo url_for('stProductOptionsFrontend/ajaxNewUpdateProduct?product_id='.$product->getId()) ?>',
            {
               onSuccess: function()
               {
                  parent.enable();

                  $('st_basket-add-to-basket-form').enable();
               },
               evalJS: true,
               parameters: params
            });
         });
      });
   </script>
<?php endif; ?>
