<?php
/**
 * SOTESHOP/stProductOptionsPlugin
 *
 * Ten plik należy do aplikacji stProductOptionsPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 15992 2011-11-07 14:35:09Z piotr $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

include(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'backend'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'stProduct'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'stProductNumberValidator.class.php');

/**
 * Klasa zawierające akcje obsługujące działania na drzewie wartości produktu.
 * W parametrach requesta należy zawsze podawać model bazy danych na którym ma być\
 * dokonywana operacja (ProductOptionsDefaultValue lub ProductOptionsValue).
 *
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stProductOptionsPlugin
 * @subpackage  actions
 */
class stProductOptionsTreeBackendActions extends sfActions
{
    public function executeSaveProductOption()
    {
        $this->setLayout(false);
        $id = $this->getRequestParameter('id');
        $product_option_values = $this->getRequest()->getParameterHolder()->get('product_option');
        $field_values = $this->getRequest()->getParameterHolder()->get('field');

        if($id)
        {
            $errors = array('values'=>array(), 'errors'=>array());

            if(!empty($product_option_values))
            {
            	$product_option_values['price'] = trim(str_replace(',','.',$product_option_values['price']));
            	if(strlen($product_option_values['price']) && floatval($product_option_values['price'])>0.0)
            	{
            		$new_price = sprintf("%.2f",floatval($product_option_values['price']));
            		if ($product_option_values['price'][0] == '+' || $product_option_values['price'][0] == '-') $new_price = $product_option_values['price'][0] . $new_price;
            		if ($product_option_values['price'][strlen($product_option_values['price'])-1] == '%') $new_price .='%';
		        	$product_option_values['price'] = $new_price;
            	}     	
                $errors['errors'] = $this->verifyOptionData($product_option_values, $id);
                if(count($errors['errors']) == 0)
                {
                	$errors['values'][] = array('id'=>'product_option_price', 'value'=>$product_option_values['price']);
                    $product_option = call_user_func($product_option_values['model'].'Peer::retrieveByPk',$id);
                    $product_option->setCulture($product_option_values['culture']);
                    if ($product_option_values['model'] == 'ProductOptionsValue') $product_option->setUseProduct($product_option_values['use_product']);
                    if ($product_option_values['model'] == 'ProductOptionsValue' && isset($product_option_values['old_price'])) $product_option->setOldPrice($product_option_values['old_price']);
                    if(!empty($product_option_values['value'])) $product_option->setValue($product_option_values['value']);
                    if(!empty($product_option_values['price']))
                    {
                        $product_option->setPrice($product_option_values['price']);
                    }
                    else
                    {
                        $product_option->setPrice(null);
                    }
                    if(!empty($product_option_values['color'])) $product_option->setColor(trim($product_option_values['color']));
                    else $product_option->setColor(null);
                    if(!empty($product_option_values['price_type'])) $product_option->setPriceType($product_option_values['price_type']);
                    if(!empty($product_option_values['sf_asset_id'])) $product_option->setsfAssetId($product_option_values['sf_asset_id']);
                    if ($product_option_values['model'] == 'ProductOptionsValue' && isset($product_option_values['stock'])) {
                        $product_option->setStock($product_option_values['stock']);
                        $product_option->save();
                        $product = $product_option->getProduct();
                        $stock = ProductOptionsValuePeer::updateStock($product);
                        if (is_null($product->getAvailabilityId())) $product->setStock($stock);
                        $product->save();
                    }
                                        
                    stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stProductOptionsBackend.preSaveOption', array('product_option'=>$product_option)));
                    $product_option->save();
                }
            }

            if(!empty($field_values))
            {
                $errors['errors'] = $this->verifyFieldData($field_values, $id);
                if(count($errors['errors']) == 0)
                {
                    $field = ProductOptionsFieldPeer::retrieveByPk($id);
                    $field->setCulture($field_values['culture']);
                    
                    if(!empty($field_values['name'])) $field->setName(trim($field_values['name']));
                    if(!empty($field_values['filter_type'])) $field->setProductOptionsFilterId(trim($field_values['filter_type']));
                    else $field->setProductOptionsFilterId(null);
                    if(!empty($field_values['typ'])) $field->setTyp(trim($field_values['typ']));
                    if(!empty($field_values['default_value'])) $field->setDefaultValue(trim($field_values['default_value']));
                    $field->save();
                }
            }

            $this->getResponse()->setHttpHeader('Content-type', 'application/json');
            $json = json_encode($errors);
            return $this->renderText($json);
        }
        return sfView::HEADER_ONLY;
    }

    /**
     * Sprawdza poprawność danych wprowadzonych
     * w formularzu dotyczącym właściwości pola.
     *
     * @return array()
     */
    private function verifyFieldData($data, $id)
    {
        $errors = array();
        $i18n = $this->getContext()->getI18n();

        if(empty($data['name']) ||  trim($data['name']) == '')
        {
            $error['id'] = 'error_for_field_name';
            $error['msg'] = $i18n->__('Podaj nazwe pola');
            $errors[] = $error;
        }

        if(!empty($data['default_value']))
        {
            $field_object = ProductOptionsFieldPeer::retrieveByPk($id);
            $field_object->setCulture($data['culture']);
            $matched = false;
            foreach($field_object->getProductOptionsValues() as $option)
            {
                $option->setCulture($data['culture']);
                if(trim($data['default_value']) == html_entity_decode($option->getValue(), ENT_QUOTES, 'UTF-8'))
                {
                    $matched = true;
                    break;
                }
            }

            if(!$matched)
            {
                foreach($field_object->getProductOptionsDefaultValues() as $default_option)
                {
                    $default_option->setCulture($data['culture']);
                    if(trim($data['default_value']) == html_entity_decode($default_option->getValue(), ENT_QUOTES, 'UTF-8'))
                    {
                        $matched = true;
                        break;
                    }
                }
            }

            if(!$matched)
            {
                $error['id'] = 'error_for_field_default_value';
                $error['msg'] = $i18n->__('Nie ma takiej opcji dla tego pola');
                $errors[] = $error;
            }
        }

        return $errors;
    }
    /**
     * Sprawdza poprawność danych wprowadzonych
     * w formularzu dotyczącym właściwości opcji.
     *
     * @return array()
     */
    private function verifyOptionData($data, $id)
    {
        $errors = array();
        $i18n = $this->getContext()->getI18n();

        if(empty($data['root']) && (empty($data['value']) || trim($data['value']) == ''))
        {
            $error['id'] = 'error_for_product_option_value';
            $error['msg'] = $i18n->__('Podaj nazwe opcji');
            $errors[] = $error;
        }
        else
        {
            
            if(isset($data['model']) && $option_object = call_user_func($data['model'].'Peer::retrieveByPk',$id))
            {
                if(!$option_object->isRoot())
                {
                    $parent = $option_object->getParent();
                    foreach($parent->getChildren() as $sibling)
                    {
                        if($sibling->getId() != $id && $sibling->getValue() == $data['value'] && $sibling->getProductOptionsFieldId() == $option_object->getProductOptionsFieldId())
                        {
                            $error['id'] = 'error_for_product_option_value';
                            $error['msg'] = $i18n->__('Istnieje już opcja dla tego pola o podanej wartości');
                            $errors[] = $error;
                        }
                    }
                }
            }
        }

        if(!empty($data['price']))
        {
            if(!preg_match('/(^\s*[-+]\s*[0-9]+(\.[0-9]{2})?\s*$)|(^\s*[-+]\s*[0-9]+(\.[0-9]{2})?\s*%\s*$)|(^\s*[0-9]+(\.[0-9]{2})?\s*$)/', $data['price']))
            {
                $error['id'] = 'error_for_product_option_price';
                $error['msg'] = $i18n->__('Niewłaściwy format modyfikatora ceny');
                $errors[] = $error;
            }
        }
        if(!empty($data['old_price']))
        {
            if(!is_numeric($data['old_price'])){
                $error['id'] = 'error_for_product_option_old_price';
                $error['msg'] = $i18n->__('Niewłaściwy format starej ceny');
                $errors[] = $error;
            }
        }

        if(!empty($data['color'])) 
        {
            if (strlen(trim($data['color']))!=6) {
                $error['id'] = 'error_for_product_option_filter';
                $error['msg'] = $i18n->__('Niewłaściwy format koloru opcji, proszę podać w postaci #123456');
                $errors[] = $error;
            }
        }

        if(!empty($data['use_product'])) 
        {
            $code = trim($data['use_product']);
            $c = new Criteria();
            $c->add(ProductPeer::CODE, $code);
            $use_product = ProductPeer::doSelectOne($c);

            if (!is_object($use_product)) {
                $error['id'] = 'error_for_product_option_use_product';
                $error['msg'] = $i18n->__('Niepoprawny kod produktu');
                $errors[] = $error;
                return $errors;
            }

            if ($option_object->getProduct()->getCode() == $code) {
                $error['id'] = 'error_for_product_option_use_product';
                $error['msg'] = $i18n->__('Opcja nie może wskazywać na produkt który edytujesz.');
                $errors[] = $error;
            }

            if ($use_product->getOptHasOptions()>1) {
                $error['id'] = 'error_for_product_option_use_product';
                $error['msg'] = $i18n->__('Opcja nie może wskazywać na produkt który posiada opcje.');
                $errors[] = $error;
            }

        }

        return $errors;
    }

    /**
     * Zmienia wartość/nazwe wartości/pola.
     *
     * @return   sfView::HEADER_ONLY
     */
    public function executeChangeProductOptionValue()
    {
        $model = $this->getRequestParameter("model");
        $value = $this->getRequestParameter("value");
        $id = $this->getRequestParameter("id");
        $field = $this->getRequestParameter('field');

        if (! empty($value))
        {
            if($field==null || $field=='undefined')
            {

                $product_option = call_user_func($model.'Peer::retrieveByPK',$id);

                $product_option->setCulture($this->getRequestParameter('language','pl_PL'));
                
                $product_option->setValue($value);

                $product_option->save();
                
                //Zmiany w szablonie wiec usuwanie informaji na temat szablonu w root
                if ($model == 'ProductOptionsValue') {
                    stProductOptionsTreeBackendActions::clearTemplateInfo($product_option);
                }
            }
            else
            {
                $field = ProductOptionsFieldPeer::retrieveByPk($field);
                $field->setCulture($this->getRequestParameter('language','pl_PL'));
                $field->setName($value);
                $field->save();
                if ($model == 'ProductOptionsValue') {
                    stProductOptionsTreeBackendActions::clearTemplateInfo($field);
                }
                
                //Zmiany w szablonie wiec usuwanie informaji na temat szablonu w root
            }
        }

        
        return sfView::HEADER_ONLY;
    }

    /**
     * Akcja usuwająca wartość z drzewa.
     *
     * @return   sfView
     */
    public function executeRemoveProductOption()
    {
        $model = $this->getRequestParameter("model");
        $field = $this->getRequestParameter("field");
        $parent_id = $this->getRequestParameter("parent_id");
        $id = $this->getRequestParameter("id");

        if($field==null || $field=='undefined')
        {
            $product_options = call_user_func($model.'Peer::retrieveByPk',$id);
            if ($product_options)
            {
                $this->deleteRecurrence($model,$product_options->getId());
                if($model == 'ProductOptionsValue')
                {
                    $product = $product_options->getProduct();
                    $stock = ProductOptionsValuePeer::updateStock($product);
                    if (is_null($product->getAvailabilityId())) $product->setStock($stock);
                    ProductOptionsValuePeer::unsetTemplate($product);
                    $product->save();
                }
                $output = json_encode(array('id' => $product_options->getId()));
            }
        }
        else
        {
            $product_options = call_user_func($model.'Peer::retrieveByPk', $parent_id);
            if($product_options)
            {
                $c2 = new Criteria();
                if($model == 'ProductOptionsValue') {
                    $c2->add(constant($model.'Peer::PRODUCT_ID'),$product_options->getProductId());
                } elseif ($model == 'ProductOptionsDefaultValue') {
                    $c2->add(constant($model.'Peer::PRODUCT_OPTIONS_TEMPLATE_ID'),$product_options->getProductOptionsTemplateId());
                }
                $c2->add(constant($model.'Peer::PRODUCT_OPTIONS_FIELD_ID'),$field);
                $items = call_user_func($model.'Peer::doSelect', $c2);

                foreach($items as $child) {
                    $this->deleteRecurrence($model,$child->getId());
                }
                
                $rootField = ProductOptionsFieldPeer::retrieveByPk($field);
                if ($rootField) {$rootField->delete();}

                if($model == 'ProductOptionsValue')
                {
                    $product = $product_options->getProduct();
                    $stock = ProductOptionsValuePeer::updateStock($product);
                    if (is_null($product->getAvailabilityId())) $product->setStock($stock);
                    ProductOptionsValuePeer::unsetTemplate($product);
                    $product->save();
                }
                
                $output = json_encode(array('id' => $id));
            }
        }

        
        $this->getResponse()->setHttpHeader('Content-Type', 'application/json');
        return $this->renderText($output);
    }
    
    public function deleteRecurrence($model, $option_id) {
        $option = call_user_func($model.'Peer::retrieveByPk', $option_id);
        
        $c2 = new Criteria(); 
        if ($model == 'ProductOptionsDefaultValue') $c2->add(constant($model.'Peer::PRODUCT_OPTIONS_TEMPLATE_ID'), $option->getProductOptionsTemplateId()); 
        else $c2->add(constant($model.'Peer::PRODUCT_ID'),$option->getProductId());
        $c2->add(constant($model.'Peer::LFT'),$option->getLft(),Criteria::GREATER_THAN);
        $c2->add(constant($model.'Peer::RGT'),$option->getRgt(),Criteria::LESS_THAN);
        $c2->addAscendingOrderByColumn(constant($model.'Peer::RGT'));
        $options = call_user_func($model.'Peer::doSelect', $c2);
        
        $fields_to_delete = array();
        foreach($options as $item) {
            $fields_to_delete[$item->getProductOptionsFieldId()] = $item->getProductOptionsFieldId();
            //$item->delete();
        }

        $c3 = new Criteria();
        $c3->add(ProductOptionsFieldPeer::ID, $fields_to_delete, Criteria::IN);
        ProductOptionsFieldPeer::doDelete($c3);
        
        call_user_func($model.'Peer::doDelete', $c2);
        $option->delete();
    }
    
    /**
     * Dodaje nowy atrybut lub wartość
     *
     * @return   sfView
     */
    public function executeAppendProductOption()
    {
        $output = '';

        $model = $this->getRequestParameter("model");
        $id = $this->getRequestParameter('id');
        $parent_id = $this->getRequestParameter('parent_id');
        $field = $this->getRequestParameter('field');
        $value = $this->getRequestParameter('name');

        if($field==null || $field=='undefined')
        {
            $field = new ProductOptionsField();
            $parent = call_user_func($model.'Peer::retrieveByPk', $id);
            $field->setCulture($parent->getCulture());
            $field->setName($value);
            
            $field->setProductOptionsTemplateId($parent->getProductOptionsTemplateId());
            if ($model == 'ProductOptionsValue') {
                $field->setProductOptionsTemplateId(0);
            }
            $field->setOptValueId($parent->getId());
            $field->save();
            stProductOptionsTreeBackendActions::clearTemplateInfo($field);

            $output = json_encode(array('name' => $field->getName(), 'field' => $field->getId(), 'text' => $field->getName(), 'parent_id' => $id, 'cls' => 'st_product_options-tree-root'));
        }
        else
        {
            //dodawanie nowej wartości
            $parent = call_user_func($model.'Peer::retrieveByPk',$this->getRequestParameter('parent_id'));
            if($model == 'ProductOptionsValue')
            {
                if($parent->isRoot() && !$parent->hasChildren() && $parent->getProduct()->getStock() != null)
                {
                    $parent->getProduct()->setStock(0);
                }
            }
            if ($parent)
            {
                $product_options = new $model;
                $product_options->setCulture($parent->getCulture());
                $product_options->setProductOptionsFieldId($field);
                $product_options->setValue($value);
                $product_options->insertAsLastChildOf($parent);
                $product_options->save();

                $output = json_encode(array('id' => $product_options->getId(), 'name' => $product_options->getValue(), 'parent_id' => $id));
            }
            
            if($model == 'ProductOptionsValue') $parent->getProduct()->save();
            stProductOptionsTreeBackendActions::clearTemplateInfo($parent);            
        }
        $this->getResponse()->setHttpHeader('Content-Type', 'application/json');
        return $this->renderText($output);
    }

    /**
     * Pobiera atrybuty lub wartości atrybutów dla danego rodzica
     *
     * @return   sfView
     */
    public function executeFetchProductOptionValues()
    {
        $i18n = $this->getContext()->getI18n();

        $model = $this->getRequestParameter("model");
        $node = $this->getRequestParameter('node');
        $parent_id = $this->getRequestParameter('parent_id');

        $field = $this->getRequestParameter('field');

        $output = '';

        $extjs_data = array();
        if ($field==null || $field=='undefined')
        {
            //wyświetlanie pól
            $value0 = call_user_func($model.'Peer::retrieveByPk', $node);

            $c = new Criteria();
            $c->add(ProductOptionsFieldPeer::OPT_VALUE_ID, $value0->getId());
            
            if ($model == 'ProductOptionsDefaultValue') $c->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID,$value0->getProductOptionsTemplateId()); 
            else $c->add(ProductOptionsFieldPeer::PRODUCT_OPTIONS_TEMPLATE_ID,0);

            $c->addAscendingOrderByColumn(ProductOptionsFieldPeer::FIELD_ORDER);
            $fields = ProductOptionsFieldPeer::doSelect($c);

            foreach ($fields as $field)
            {

                $field->setCulture($this->getRequestParameter('language','pl_PL'));
                $qtip = '<ul type="hidden"><li>'.$i18n->__('Nazwa pola').': '.$field->getName().'<li/>';
                if($field->getTyp())
                {
                    $qtip .= '<li>'.$i18n->__('Typ').': '.$field->getTyp().'<li/>';
                }
                if($field->getDefaultValue())
                {
                    $qtip .= '<li>'.$i18n->__('Domyślna wartość').': '.$field->getDefaultValue().'</li></ul>';
                }
                $extjs_data[] = array('field' => $field->getId(),
                                        'language' => $this->getRequestParameter('language','pl_PL'),
                                        'text' => $field->getName() ? $field->getName() : $i18n->__('opcja',array(),'stProductOptionsTreeBackend'),
                                        'cls' => 'st_product_options-tree-root', 
                                        'qtip' => $qtip);
            }
        }
        else
        {
            $product_options = call_user_func($model.'Peer::retrieveByPk',$parent_id);
            $product_options = $product_options->getChildren();
            foreach($product_options as $product_options)
            {
                $product_options->setCulture($this->getRequestParameter('language','pl_PL'));
                if($product_options->getProductOptionsFieldId()==$field)
                {
                    sfLoader::loadHelpers(array('Helper','stAsset'));
                    $qtip  = '<ul type="hidden"><li>'.$i18n->__('Wartość').': '.$product_options->getValue().'<li/>';
                    if($product_options->getPrice())
                    {
                        $qtip .= '<li>'.$i18n->__('Cena').': '.$product_options->getPrice().'</li>';
                    }
                    if($model=='ProductOptionsValue')
                    {
                        if($asset = $product_options->getsfAsset())
                        {
                            $qtip .= '<li>'.$i18n->__('Zdjęcie').': '.st_asset_image_tag($asset, 'icon').'</li>';
                        }
                    }
                    $qtip .= '</ul>';
                    $extjs_data[] = array('id' => $product_options->getId(),
                                            'language' => $this->getRequestParameter('language','pl_PL'),
                                            'text' => $product_options->getValue() ? $product_options->getValue() : $i18n->__('wartość'),
                                            'qtip' => $qtip);
                }
            }
        }

        $output = json_encode($extjs_data);

        $this->getResponse()->setHttpHeader('Content-Type', 'application/json');
        return $this->renderText($output);
    }

    /**
     * Przenosi wartości w drzewie
     *
     * @return   sfView
     */
    public function executeMoveProductOption()
    {
        $parameters = $this->getRequest()->getParameterHolder()->getAll();

        if ($parameters['field']) {
            $c = new Criteria();
            $c->add(ProductOptionsFieldPeer::OPT_VALUE_ID,$parameters['new_parent_id']);
            $c->add(ProductOptionsFieldPeer::ID,$parameters['field'],Criteria::NOT_EQUAL);
            $c->addAscendingOrderByColumn(ProductOptionsFieldPeer::FIELD_ORDER);
            
            $fields = ProductOptionsFieldPeer::doSelect($c);
            
            $order = 0;
            $moved = ProductOptionsFieldPeer::retrieveByPk($parameters['field']);
            if ($parameters['prev_field_sibling_id']==0) {
                $moved->setFieldOrder($order);
                $order++;    
            }
            foreach ($fields as $field) {
                $field->setFieldOrder($order);
                if ($parameters['prev_field_sibling_id'] == $field->getId()) {
                    $order++;
                    $moved->setFieldOrder($order);
                }
                $order++;
                $field->save();
            }
            $moved->save();
            
        } else {
            $product_options = call_user_func($parameters['model'].'Peer::retrieveByPK',$parameters['id']);
            if ($product_options)
            {
                if ($parameters['prev_sibling_id'])
                {
                    $product_options->moveToNextSiblingOf(call_user_func($parameters['model'].'Peer::retrieveByPK',$parameters['prev_sibling_id']));
                }
                else if($parameters['next_sibling_id'])
                {
                    $product_options->moveToPrevSiblingOf(call_user_func($parameters['model'].'Peer::retrieveByPK',$parameters['next_sibling_id']));
                }
                else
                {
                    $product_options->moveToLastChildOf(call_user_func($parameters['model'].'Peer::retrieveByPK',$parameters['new_parent_id']));
                }
                $product_options->save();
            }
        }
        return sfView::HEADER_ONLY;
    }

    public static function clearTemplateInfo($item) {
        if ($item instanceof  ProductOptionsValue ) {
            $c = new Criteria();
            $c->add(ProductOptionsValuePeer::DEPTH, 0);
            $c->add(ProductOptionsValuePeer::PRODUCT_ID, $item->getProductId());
            $root = ProductOptionsValuePeer::doSelectOne($c);
            $root->setProductOptionsTemplateId(0);
            $root->save();
        }
        
        if ($item instanceof  ProductOptionsField ) {
            $subItem = ProductOptionsValuePeer::retrieveByPk($item->getOptValueId());
            
            
            if ($subItem) {
                $c = new Criteria();
                $c->add(ProductOptionsValuePeer::DEPTH, 0);
                $c->add(ProductOptionsValuePeer::PRODUCT_ID, $subItem->getProductId());
                $root = ProductOptionsValuePeer::doSelectOne($c);
                $root->setProductOptionsTemplateId(0);
                $root->save();
            }
        }
    }
}
