<?php

/**
 * SOTESHOP/stPropelSeoUrlBehaviorPlugin
 *
 * Ten plik należy do aplikacji stPropelSeoUrlBehaviorPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stPropelSeoUrlBehaviorPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stPropelSeoUrlBehavior.class.php 13231 2011-05-31 09:07:01Z marcin $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * Zachowanie propela dodajace obsluge przyjaznych linkow na poziomie modelu bazy danych
 *
 * @package     stPropelSeoUrlBehaviorPlugin
 * @subpackage  libs
 */
class stPropelSeoUrlBehavior
{

   protected static $methods = array();
   protected static $autoGenerateUrl = false;

   /**
    *
    * Zwraca wartość zgodna z url i seo
    *
    * @param BaseObject $object
    * @return string
    */
   public function getFriendlyUrl(BaseObject $object)
   {
      $object_class = get_class($object);

      $method = self::getMethodName($object_class, 'target_column', 'get');

      return $object->$method();
   }

   /**
    *
    * Ustala konfiguracje dla stPropelSeoUrlBehavior
    *
    * @param $params Parametry konfiguracyjne
    */
   public static function configuration($params = array())
   {
      if (isset($params['auto_generate_url']))
      {
         self::$autoGenerateUrl = $params['auto_generate_url'];
      }
   }

   /**
    *
    * Zamienia wartość kolumny na odpowiednik zgodny ze specyfikacja url i seo
    *
    * @param BaseObject $object Obiekt do ktorego przypisane jest zachowanie
    * @param CreoleConnection $con Połączenie z bazą danych
    */
   public function preSave(BaseObject $object, $con = null)
   {
      if ($object->getCulture())
      {
         $object_class = get_class($object);

         $s_getter = self::getMethodName($object_class, 'source_column', 'get');

         $t_setter = self::getMethodName($object_class, 'target_column', 'set');

         $t_getter = self::getMethodName($object_class, 'target_column', 'get');


         if (self::$autoGenerateUrl || $object->isNew())
         {
            $object->$t_setter(self::makeSeoFriendly($object->$s_getter()));
         }

         $filter = self::getMethodName($object_class, 'target_column_filter');

         $url = $object->$filter($object->$t_getter());

         if ($url !== false)
         {
            $object->$t_setter($url);
         }
      }
   }

   /**
    *
    * Zwraca nazwę metody
    *
    * @param string $object_class Klasa modelu dla którego będzie generowana metoda
    * @param string $method_type Typ metody
    * @param string $type Określa czy dana metoda ma być zwrócona w formacie "getter" lub "setter" (wartości: "get" lub "set")
    * @return string nazwa metody
    */
   protected static function getMethodName($object_class, $method_type, $type = null)
   {
      $conf_directive = sprintf('propel_behavior_stPropelSeoUrlBehavior_%s_%s', $object_class, $method_type);

      if (!isset(self::$methods[$conf_directive . '_' . $type]))
      {
         $col = sfConfig::get($conf_directive);

         if (!$col)
         {
            throw new stPropelSeoUrlBehaviorException(sprintf('Musisz podać wartość dla parametru "%s" dla modelu "%s"', $method_type, $object_class));
         }

         try
         {
            self::$methods[$conf_directive . '_' . $type] = $type . call_user_func($object_class . 'Peer::translateFieldName', $col, BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
         } catch (PropelException $e)
         {
            self::$methods[$conf_directive . '_' . $type] = $type . $col;
         }
      }

      return self::$methods[$conf_directive . '_' . $type];
   }

   /**
    *
    * Zamienia podany tekst na tekst zgodny z seo
    *
    * @param string $str Tekst do zamiany
    * @return string Tekst zgodny z seo
    */
   public static function makeSeoFriendly($str)
   {
      mb_internal_encoding('UTF-8');

      mb_regex_encoding("UTF-8");

      $search = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
          '/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/', '/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
          '/Š/', '/Ž/', '/š/', '/ž/', '/Ÿ/', '/Ŕ/', '/Á/', '/Â/', '/Ă/', '/Ä/', '/Ĺ/', '/Ç/', '/Č/', '/É/', '/Ę/', '/Ë/', '/Ě/', '/Í/', '/Î/', '/Ď/', '/Ń/',
          '/Ň/', '/Ó/', '/Ô/', '/Ő/', '/Ö/', '/Ř/', '/Ů/', '/Ú/', '/Ű/', '/Ü/', '/Ý/', '/ŕ/', '/á/', '/â/', '/ă/', '/ä/', '/ĺ/', '/ç/', '/č/', '/é/', '/ę/',
          '/ë/', '/ě/', '/í/', '/î/', '/ď/', '/ń/', '/ň/', '/ó/', '/ô/', '/ő/', '/ö/', '/ř/', '/ů/', '/ú/', '/ű/', '/ü/', '/ý/', '/˙/',
          '/Ţ/', '/ţ/', '/Đ/', '/đ/', '/ß/', '/Œ/', '/œ/', '/Ć/', '/ć/', '/ľ/');

      $replace = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
          'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
          'S', 'Z', 's', 'z', 'Y', 'A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'N',
          'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 'a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e',
          'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y',
          'TH', 'th', 'DH', 'dh', 'ss', 'OE', 'oe', 'AE', 'ae', 'u');


      $str = preg_replace($search, $replace, $str);

      $str = preg_replace('/\W+/i', '-', $str);

      $str = trim($str, '-');

      return strtolower($str);
   }

}

class stPropelSeoUrlBehaviorException extends sfException
{
   
}
