<?php


abstract class BaseQuestionStatus extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $status_type;


	
	protected $is_default;


	
	protected $is_system_default;

	
	protected $collQuestionss;

	
	protected $lastQuestionsCriteria = null;

	
	protected $collQuestionStatusI18ns;

	
	protected $lastQuestionStatusI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getStatusType()
    {

            return $this->status_type;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = QuestionStatusPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = QuestionStatusPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = QuestionStatusPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = QuestionStatusPeer::OPT_NAME;
        }

	} 
	
	public function setStatusType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->status_type !== $v) {
          $this->status_type = $v;
          $this->modifiedColumns[] = QuestionStatusPeer::STATUS_TYPE;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v) {
          $this->is_default = $v;
          $this->modifiedColumns[] = QuestionStatusPeer::IS_DEFAULT;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = QuestionStatusPeer::IS_SYSTEM_DEFAULT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'QuestionStatus.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->status_type = $rs->getString($startcol + 4);

      $this->is_default = $rs->getBoolean($startcol + 5);

      $this->is_system_default = $rs->getBoolean($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'QuestionStatus.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating QuestionStatus object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseQuestionStatus:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(QuestionStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			QuestionStatusPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseQuestionStatus:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'QuestionStatus.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseQuestionStatus:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(QuestionStatusPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(QuestionStatusPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(QuestionStatusPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'QuestionStatus.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseQuestionStatus:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = QuestionStatusPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += QuestionStatusPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collQuestionss !== null) {
				foreach($this->collQuestionss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collQuestionStatusI18ns !== null) {
				foreach($this->collQuestionStatusI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = QuestionStatusPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collQuestionss !== null) {
					foreach($this->collQuestionss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collQuestionStatusI18ns !== null) {
					foreach($this->collQuestionStatusI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = QuestionStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getStatusType();
				break;
			case 5:
				return $this->getIsDefault();
				break;
			case 6:
				return $this->getIsSystemDefault();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = QuestionStatusPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getStatusType(),
			$keys[5] => $this->getIsDefault(),
			$keys[6] => $this->getIsSystemDefault(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = QuestionStatusPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setStatusType($value);
				break;
			case 5:
				$this->setIsDefault($value);
				break;
			case 6:
				$this->setIsSystemDefault($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = QuestionStatusPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setStatusType($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setIsDefault($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setIsSystemDefault($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(QuestionStatusPeer::DATABASE_NAME);

		if ($this->isColumnModified(QuestionStatusPeer::CREATED_AT)) $criteria->add(QuestionStatusPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(QuestionStatusPeer::UPDATED_AT)) $criteria->add(QuestionStatusPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(QuestionStatusPeer::ID)) $criteria->add(QuestionStatusPeer::ID, $this->id);
		if ($this->isColumnModified(QuestionStatusPeer::OPT_NAME)) $criteria->add(QuestionStatusPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(QuestionStatusPeer::STATUS_TYPE)) $criteria->add(QuestionStatusPeer::STATUS_TYPE, $this->status_type);
		if ($this->isColumnModified(QuestionStatusPeer::IS_DEFAULT)) $criteria->add(QuestionStatusPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(QuestionStatusPeer::IS_SYSTEM_DEFAULT)) $criteria->add(QuestionStatusPeer::IS_SYSTEM_DEFAULT, $this->is_system_default);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(QuestionStatusPeer::DATABASE_NAME);

		$criteria->add(QuestionStatusPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setStatusType($this->status_type);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setIsSystemDefault($this->is_system_default);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getQuestionss() as $relObj) {
				$copyObj->addQuestions($relObj->copy($deepCopy));
			}

			foreach($this->getQuestionStatusI18ns() as $relObj) {
				$copyObj->addQuestionStatusI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new QuestionStatusPeer();
		}
		return self::$peer;
	}

	
	public function initQuestionss()
	{
		if ($this->collQuestionss === null) {
			$this->collQuestionss = array();
		}
	}

	
	public function getQuestionss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collQuestionss === null) {
			if ($this->isNew()) {
			   $this->collQuestionss = array();
			} else {

				$criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->getId());

				QuestionsPeer::addSelectColumns($criteria);
				$this->collQuestionss = QuestionsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->getId());

				QuestionsPeer::addSelectColumns($criteria);
				if (!isset($this->lastQuestionsCriteria) || !$this->lastQuestionsCriteria->equals($criteria)) {
					$this->collQuestionss = QuestionsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastQuestionsCriteria = $criteria;
		return $this->collQuestionss;
	}

	
	public function countQuestionss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->getId());

		return QuestionsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addQuestions(Questions $l)
	{
		$this->collQuestionss[] = $l;
		$l->setQuestionStatus($this);
	}


	
	public function getQuestionssJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collQuestionss === null) {
			if ($this->isNew()) {
				$this->collQuestionss = array();
			} else {

				$criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->getId());

				$this->collQuestionss = QuestionsPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->getId());

			if (!isset($this->lastQuestionsCriteria) || !$this->lastQuestionsCriteria->equals($criteria)) {
				$this->collQuestionss = QuestionsPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastQuestionsCriteria = $criteria;

		return $this->collQuestionss;
	}

	
	public function initQuestionStatusI18ns()
	{
		if ($this->collQuestionStatusI18ns === null) {
			$this->collQuestionStatusI18ns = array();
		}
	}

	
	public function getQuestionStatusI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collQuestionStatusI18ns === null) {
			if ($this->isNew()) {
			   $this->collQuestionStatusI18ns = array();
			} else {

				$criteria->add(QuestionStatusI18nPeer::ID, $this->getId());

				QuestionStatusI18nPeer::addSelectColumns($criteria);
				$this->collQuestionStatusI18ns = QuestionStatusI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(QuestionStatusI18nPeer::ID, $this->getId());

				QuestionStatusI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastQuestionStatusI18nCriteria) || !$this->lastQuestionStatusI18nCriteria->equals($criteria)) {
					$this->collQuestionStatusI18ns = QuestionStatusI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastQuestionStatusI18nCriteria = $criteria;
		return $this->collQuestionStatusI18ns;
	}

	
	public function countQuestionStatusI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(QuestionStatusI18nPeer::ID, $this->getId());

		return QuestionStatusI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addQuestionStatusI18n(QuestionStatusI18n $l)
	{
		$this->collQuestionStatusI18ns[] = $l;
		$l->setQuestionStatus($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentQuestionStatusI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentQuestionStatusI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentQuestionStatusI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = QuestionStatusI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setQuestionStatusI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setQuestionStatusI18nForCulture(new QuestionStatusI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setQuestionStatusI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addQuestionStatusI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'QuestionStatus.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseQuestionStatus:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseQuestionStatus::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 