<?php


abstract class BaseQuestions extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $item_id;


	
	protected $question_status_id;


	
	protected $email;


	
	protected $type;


	
	protected $item_name;


	
	protected $text;


	
	protected $answer_text;

	
	protected $aProduct;

	
	protected $aQuestionStatus;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getItemId()
    {

            return $this->item_id;
    }

    
    public function getQuestionStatusId()
    {

            return $this->question_status_id;
    }

    
    public function getEmail()
    {

            return $this->email;
    }

    
    public function getType()
    {

            return $this->type;
    }

    
    public function getItemName()
    {

            return $this->item_name;
    }

    
    public function getText()
    {

            return $this->text;
    }

    
    public function getAnswerText()
    {

            return $this->answer_text;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = QuestionsPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = QuestionsPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = QuestionsPeer::ID;
        }

	} 
	
	public function setItemId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->item_id !== $v) {
          $this->item_id = $v;
          $this->modifiedColumns[] = QuestionsPeer::ITEM_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setQuestionStatusId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->question_status_id !== $v) {
          $this->question_status_id = $v;
          $this->modifiedColumns[] = QuestionsPeer::QUESTION_STATUS_ID;
        }

		if ($this->aQuestionStatus !== null && $this->aQuestionStatus->getId() !== $v) {
			$this->aQuestionStatus = null;
		}

	} 
	
	public function setEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->email !== $v) {
          $this->email = $v;
          $this->modifiedColumns[] = QuestionsPeer::EMAIL;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = QuestionsPeer::TYPE;
        }

	} 
	
	public function setItemName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->item_name !== $v) {
          $this->item_name = $v;
          $this->modifiedColumns[] = QuestionsPeer::ITEM_NAME;
        }

	} 
	
	public function setText($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->text !== $v) {
          $this->text = $v;
          $this->modifiedColumns[] = QuestionsPeer::TEXT;
        }

	} 
	
	public function setAnswerText($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->answer_text !== $v) {
          $this->answer_text = $v;
          $this->modifiedColumns[] = QuestionsPeer::ANSWER_TEXT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Questions.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->item_id = $rs->getInt($startcol + 3);

      $this->question_status_id = $rs->getInt($startcol + 4);

      $this->email = $rs->getString($startcol + 5);

      $this->type = $rs->getString($startcol + 6);

      $this->item_name = $rs->getString($startcol + 7);

      $this->text = $rs->getString($startcol + 8);

      $this->answer_text = $rs->getString($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Questions.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Questions object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseQuestions:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(QuestionsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			QuestionsPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseQuestions:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Questions.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseQuestions:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(QuestionsPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(QuestionsPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(QuestionsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Questions.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseQuestions:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}

			if ($this->aQuestionStatus !== null) {
				if ($this->aQuestionStatus->isModified() || $this->aQuestionStatus->getCurrentQuestionStatusI18n()->isModified()) {
					$affectedRows += $this->aQuestionStatus->save($con);
				}
				$this->setQuestionStatus($this->aQuestionStatus);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = QuestionsPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += QuestionsPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}

			if ($this->aQuestionStatus !== null) {
				if (!$this->aQuestionStatus->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aQuestionStatus->getValidationFailures());
				}
			}


			if (($retval = QuestionsPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = QuestionsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getItemId();
				break;
			case 4:
				return $this->getQuestionStatusId();
				break;
			case 5:
				return $this->getEmail();
				break;
			case 6:
				return $this->getType();
				break;
			case 7:
				return $this->getItemName();
				break;
			case 8:
				return $this->getText();
				break;
			case 9:
				return $this->getAnswerText();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = QuestionsPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getItemId(),
			$keys[4] => $this->getQuestionStatusId(),
			$keys[5] => $this->getEmail(),
			$keys[6] => $this->getType(),
			$keys[7] => $this->getItemName(),
			$keys[8] => $this->getText(),
			$keys[9] => $this->getAnswerText(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = QuestionsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setItemId($value);
				break;
			case 4:
				$this->setQuestionStatusId($value);
				break;
			case 5:
				$this->setEmail($value);
				break;
			case 6:
				$this->setType($value);
				break;
			case 7:
				$this->setItemName($value);
				break;
			case 8:
				$this->setText($value);
				break;
			case 9:
				$this->setAnswerText($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = QuestionsPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setItemId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setQuestionStatusId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setEmail($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setType($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setItemName($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setText($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setAnswerText($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(QuestionsPeer::DATABASE_NAME);

		if ($this->isColumnModified(QuestionsPeer::CREATED_AT)) $criteria->add(QuestionsPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(QuestionsPeer::UPDATED_AT)) $criteria->add(QuestionsPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(QuestionsPeer::ID)) $criteria->add(QuestionsPeer::ID, $this->id);
		if ($this->isColumnModified(QuestionsPeer::ITEM_ID)) $criteria->add(QuestionsPeer::ITEM_ID, $this->item_id);
		if ($this->isColumnModified(QuestionsPeer::QUESTION_STATUS_ID)) $criteria->add(QuestionsPeer::QUESTION_STATUS_ID, $this->question_status_id);
		if ($this->isColumnModified(QuestionsPeer::EMAIL)) $criteria->add(QuestionsPeer::EMAIL, $this->email);
		if ($this->isColumnModified(QuestionsPeer::TYPE)) $criteria->add(QuestionsPeer::TYPE, $this->type);
		if ($this->isColumnModified(QuestionsPeer::ITEM_NAME)) $criteria->add(QuestionsPeer::ITEM_NAME, $this->item_name);
		if ($this->isColumnModified(QuestionsPeer::TEXT)) $criteria->add(QuestionsPeer::TEXT, $this->text);
		if ($this->isColumnModified(QuestionsPeer::ANSWER_TEXT)) $criteria->add(QuestionsPeer::ANSWER_TEXT, $this->answer_text);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(QuestionsPeer::DATABASE_NAME);

		$criteria->add(QuestionsPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setItemId($this->item_id);

		$copyObj->setQuestionStatusId($this->question_status_id);

		$copyObj->setEmail($this->email);

		$copyObj->setType($this->type);

		$copyObj->setItemName($this->item_name);

		$copyObj->setText($this->text);

		$copyObj->setAnswerText($this->answer_text);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new QuestionsPeer();
		}
		return self::$peer;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setItemId(NULL);
		} else {
			$this->setItemId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->item_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->item_id, $con);

			
		}
		return $this->aProduct;
	}

	
	public function setQuestionStatus($v)
	{


		if ($v === null) {
			$this->setQuestionStatusId(NULL);
		} else {
			$this->setQuestionStatusId($v->getId());
		}


		$this->aQuestionStatus = $v;
	}


	
	public function getQuestionStatus($con = null)
	{
		if ($this->aQuestionStatus === null && ($this->question_status_id !== null)) {
						$this->aQuestionStatus = QuestionStatusPeer::retrieveByPK($this->question_status_id, $con);

			
		}
		return $this->aQuestionStatus;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Questions.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseQuestions:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseQuestions::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 