<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  configs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: config.php 12100 2011-04-08 07:18:36Z bartek $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/** 
 * Włączanie modułów
 */
stPluginHelper::addEnableModule('stRecommendSendBackend', 'backend');
stPluginHelper::addEnableModule('stRecommendShopSendBackend', 'backend');

stPluginHelper::addEnableModule('stRecommendProductFrontend', 'frontend');
stPluginHelper::addEnableModule('stRecommendShopFrontend', 'frontend');

/** 
 * Dodawanie routingów
 */

stPluginHelper::addRouting('stRecommendPlugin', '/recommend_send/:action/*', 'stRecommendSendBackend', 'list', 'backend');
stPluginHelper::addRouting('stRecommendSendPlugin', '/recommend_send/:action/*', 'stRecommendSendBackend', 'list', 'backend');
stPluginHelper::addRouting('recommend_shop_send', '/recommend_shop_send/:action/*', 'stRecommendShopSendBackend', 'list', 'backend');
stPluginHelper::addRouting('recommend_send', '/recommend_send/:action/*', 'stRecommendSendBackend', 'list', 'backend');
stPluginHelper::addRouting('stRecommendSendConfig', '/recommend_config/:action/*', 'stRecommendSendBackend', 'config', 'backend');
stPluginHelper::addRouting('recommend_config', '/recommend_config/:action/*', 'stRecommendSendBackend', 'config', 'backend');

stPluginHelper::addRouting('recommend', '/recommend/:action/*', 'stRecommendProductFrontend', 'index', 'frontend');
stPluginHelper::addRouting('recommend_shop', '/recommend_shop/:action/*', 'stRecommendShopFrontend', 'index', 'frontend');