<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  helpers
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stRecommendPluginHelper.php 1221 2009-10-07 13:45:16Z pawel $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/** 
 * Sprawdź polecone zamówienia
 *
 * @param        string      $uniqid
 */
function checkRecommendedUserOrder($uniqid)
{
	$c = new Criteria();
	$c->add(RecommendSendPeer::UNIQID, $uniqid);
	$recommend = RecommendSendPeer::doSelectOne($c);
	$recommend->getUserId();
	$user = UserPeer::retrieveByPK($recommend->getUserId());
	if ($user)
	{
		return link_to($user->getEmail(), 'user_data/editPage?id='.$user->getEmail());
	}
}

/** 
 * Sprawdź poleconych użytkowników
 *
 * @param        string      $email
 */
function checkRecommendedUser($email)
{
	$c = new Criteria();
	$c->add(UserPeer::EMAIL, $email);
	$user = UserPeer::doSelectOne($c);
	if ($user)
	{
		return link_to($user->getEmail(), 'user_data/editPage?id='.$user->getEmail());
	}
}

?>