<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: RecommendSend.php 9867 2010-12-17 15:02:27Z piotr $
 */

/** 
 * Klasa rekomendacje
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>  
 *
 * @package     stRecommendPlugin
 * @subpackage  libs
 */
class RecommendSend extends BaseRecommendSend
{
    
    /** 
     * Zmiana id na nazwe
     *
     * @return   $this->getSubject()
     */
    public function __toString()
    {
        return $this->getSubject();
    }
    
	public function getRecommendFrom()
	{
		return stXssSafe::clean($this->recommend_from);
	}

	public function getFriendEmail()
	{
		return stXssSafe::clean($this->friend_email);
	}

	public function getAdditionalInfo()
	{
		return stXssSafe::clean($this->additional_info);
	}
	
	public function getRecommendContent()
	{
		return stXssSafe::clean($this->recommend_content);
	}
	
}
