<?php


abstract class BaseRecommendSend extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $product_id;


	
	protected $recommend_from;


	
	protected $friend_email;


	
	protected $recommend_link;


	
	protected $visited = false;


	
	protected $uniqid;


	
	protected $recommend_content;


	
	protected $additional_info;


	
	protected $product_name;

	
	protected $asfGuardUser;

	
	protected $aProduct;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getRecommendFrom()
    {

            return $this->recommend_from;
    }

    
    public function getFriendEmail()
    {

            return $this->friend_email;
    }

    
    public function getRecommendLink()
    {

            return $this->recommend_link;
    }

    
    public function getVisited()
    {

            return $this->visited;
    }

    
    public function getUniqid()
    {

            return $this->uniqid;
    }

    
    public function getRecommendContent()
    {

            return $this->recommend_content;
    }

    
    public function getAdditionalInfo()
    {

            return $this->additional_info;
    }

    
    public function getProductName()
    {

            return $this->product_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = RecommendSendPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = RecommendSendPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = RecommendSendPeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = RecommendSendPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = RecommendSendPeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setRecommendFrom($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_from !== $v) {
          $this->recommend_from = $v;
          $this->modifiedColumns[] = RecommendSendPeer::RECOMMEND_FROM;
        }

	} 
	
	public function setFriendEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->friend_email !== $v) {
          $this->friend_email = $v;
          $this->modifiedColumns[] = RecommendSendPeer::FRIEND_EMAIL;
        }

	} 
	
	public function setRecommendLink($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_link !== $v) {
          $this->recommend_link = $v;
          $this->modifiedColumns[] = RecommendSendPeer::RECOMMEND_LINK;
        }

	} 
	
	public function setVisited($v)
	{

        if ($this->visited !== $v || $v === false) {
          $this->visited = $v;
          $this->modifiedColumns[] = RecommendSendPeer::VISITED;
        }

	} 
	
	public function setUniqid($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->uniqid !== $v) {
          $this->uniqid = $v;
          $this->modifiedColumns[] = RecommendSendPeer::UNIQID;
        }

	} 
	
	public function setRecommendContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_content !== $v) {
          $this->recommend_content = $v;
          $this->modifiedColumns[] = RecommendSendPeer::RECOMMEND_CONTENT;
        }

	} 
	
	public function setAdditionalInfo($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->additional_info !== $v) {
          $this->additional_info = $v;
          $this->modifiedColumns[] = RecommendSendPeer::ADDITIONAL_INFO;
        }

	} 
	
	public function setProductName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->product_name !== $v) {
          $this->product_name = $v;
          $this->modifiedColumns[] = RecommendSendPeer::PRODUCT_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'RecommendSend.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->product_id = $rs->getInt($startcol + 4);

      $this->recommend_from = $rs->getString($startcol + 5);

      $this->friend_email = $rs->getString($startcol + 6);

      $this->recommend_link = $rs->getString($startcol + 7);

      $this->visited = $rs->getBoolean($startcol + 8);

      $this->uniqid = $rs->getString($startcol + 9);

      $this->recommend_content = $rs->getString($startcol + 10);

      $this->additional_info = $rs->getString($startcol + 11);

      $this->product_name = $rs->getString($startcol + 12);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'RecommendSend.postHydrate', array('resultset' => $rs, 'startcol' => 13)));

            return $startcol + 13; 
    } catch (Exception $e) {
      throw new PropelException("Error populating RecommendSend object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseRecommendSend:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RecommendSendPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			RecommendSendPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseRecommendSend:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'RecommendSend.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseRecommendSend:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(RecommendSendPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(RecommendSendPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RecommendSendPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'RecommendSend.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseRecommendSend:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = RecommendSendPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += RecommendSendPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}


			if (($retval = RecommendSendPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RecommendSendPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getProductId();
				break;
			case 5:
				return $this->getRecommendFrom();
				break;
			case 6:
				return $this->getFriendEmail();
				break;
			case 7:
				return $this->getRecommendLink();
				break;
			case 8:
				return $this->getVisited();
				break;
			case 9:
				return $this->getUniqid();
				break;
			case 10:
				return $this->getRecommendContent();
				break;
			case 11:
				return $this->getAdditionalInfo();
				break;
			case 12:
				return $this->getProductName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = RecommendSendPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getProductId(),
			$keys[5] => $this->getRecommendFrom(),
			$keys[6] => $this->getFriendEmail(),
			$keys[7] => $this->getRecommendLink(),
			$keys[8] => $this->getVisited(),
			$keys[9] => $this->getUniqid(),
			$keys[10] => $this->getRecommendContent(),
			$keys[11] => $this->getAdditionalInfo(),
			$keys[12] => $this->getProductName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RecommendSendPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setProductId($value);
				break;
			case 5:
				$this->setRecommendFrom($value);
				break;
			case 6:
				$this->setFriendEmail($value);
				break;
			case 7:
				$this->setRecommendLink($value);
				break;
			case 8:
				$this->setVisited($value);
				break;
			case 9:
				$this->setUniqid($value);
				break;
			case 10:
				$this->setRecommendContent($value);
				break;
			case 11:
				$this->setAdditionalInfo($value);
				break;
			case 12:
				$this->setProductName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = RecommendSendPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setProductId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRecommendFrom($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setFriendEmail($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setRecommendLink($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setVisited($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setUniqid($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setRecommendContent($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setAdditionalInfo($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setProductName($arr[$keys[12]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(RecommendSendPeer::DATABASE_NAME);

		if ($this->isColumnModified(RecommendSendPeer::CREATED_AT)) $criteria->add(RecommendSendPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(RecommendSendPeer::UPDATED_AT)) $criteria->add(RecommendSendPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(RecommendSendPeer::ID)) $criteria->add(RecommendSendPeer::ID, $this->id);
		if ($this->isColumnModified(RecommendSendPeer::SF_GUARD_USER_ID)) $criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(RecommendSendPeer::PRODUCT_ID)) $criteria->add(RecommendSendPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(RecommendSendPeer::RECOMMEND_FROM)) $criteria->add(RecommendSendPeer::RECOMMEND_FROM, $this->recommend_from);
		if ($this->isColumnModified(RecommendSendPeer::FRIEND_EMAIL)) $criteria->add(RecommendSendPeer::FRIEND_EMAIL, $this->friend_email);
		if ($this->isColumnModified(RecommendSendPeer::RECOMMEND_LINK)) $criteria->add(RecommendSendPeer::RECOMMEND_LINK, $this->recommend_link);
		if ($this->isColumnModified(RecommendSendPeer::VISITED)) $criteria->add(RecommendSendPeer::VISITED, $this->visited);
		if ($this->isColumnModified(RecommendSendPeer::UNIQID)) $criteria->add(RecommendSendPeer::UNIQID, $this->uniqid);
		if ($this->isColumnModified(RecommendSendPeer::RECOMMEND_CONTENT)) $criteria->add(RecommendSendPeer::RECOMMEND_CONTENT, $this->recommend_content);
		if ($this->isColumnModified(RecommendSendPeer::ADDITIONAL_INFO)) $criteria->add(RecommendSendPeer::ADDITIONAL_INFO, $this->additional_info);
		if ($this->isColumnModified(RecommendSendPeer::PRODUCT_NAME)) $criteria->add(RecommendSendPeer::PRODUCT_NAME, $this->product_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(RecommendSendPeer::DATABASE_NAME);

		$criteria->add(RecommendSendPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setRecommendFrom($this->recommend_from);

		$copyObj->setFriendEmail($this->friend_email);

		$copyObj->setRecommendLink($this->recommend_link);

		$copyObj->setVisited($this->visited);

		$copyObj->setUniqid($this->uniqid);

		$copyObj->setRecommendContent($this->recommend_content);

		$copyObj->setAdditionalInfo($this->additional_info);

		$copyObj->setProductName($this->product_name);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new RecommendSendPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'RecommendSend.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseRecommendSend:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseRecommendSend::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 