<?php


abstract class BaseRecommendShopSend extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $recommend_from;


	
	protected $friend_email;


	
	protected $recommend_shop_link;


	
	protected $visited;


	
	protected $uniqid_shop;


	
	protected $recommend_shop_content;


	
	protected $additional_shop_info;

	
	protected $asfGuardUser;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getRecommendFrom()
    {

            return $this->recommend_from;
    }

    
    public function getFriendEmail()
    {

            return $this->friend_email;
    }

    
    public function getRecommendShopLink()
    {

            return $this->recommend_shop_link;
    }

    
    public function getVisited()
    {

            return $this->visited;
    }

    
    public function getUniqidShop()
    {

            return $this->uniqid_shop;
    }

    
    public function getRecommendShopContent()
    {

            return $this->recommend_shop_content;
    }

    
    public function getAdditionalShopInfo()
    {

            return $this->additional_shop_info;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = RecommendShopSendPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = RecommendShopSendPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setRecommendFrom($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_from !== $v) {
          $this->recommend_from = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::RECOMMEND_FROM;
        }

	} 
	
	public function setFriendEmail($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->friend_email !== $v) {
          $this->friend_email = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::FRIEND_EMAIL;
        }

	} 
	
	public function setRecommendShopLink($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_shop_link !== $v) {
          $this->recommend_shop_link = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::RECOMMEND_SHOP_LINK;
        }

	} 
	
	public function setVisited($v)
	{

        if ($this->visited !== $v) {
          $this->visited = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::VISITED;
        }

	} 
	
	public function setUniqidShop($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->uniqid_shop !== $v) {
          $this->uniqid_shop = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::UNIQID_SHOP;
        }

	} 
	
	public function setRecommendShopContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->recommend_shop_content !== $v) {
          $this->recommend_shop_content = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::RECOMMEND_SHOP_CONTENT;
        }

	} 
	
	public function setAdditionalShopInfo($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->additional_shop_info !== $v) {
          $this->additional_shop_info = $v;
          $this->modifiedColumns[] = RecommendShopSendPeer::ADDITIONAL_SHOP_INFO;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'RecommendShopSend.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->recommend_from = $rs->getString($startcol + 4);

      $this->friend_email = $rs->getString($startcol + 5);

      $this->recommend_shop_link = $rs->getString($startcol + 6);

      $this->visited = $rs->getBoolean($startcol + 7);

      $this->uniqid_shop = $rs->getString($startcol + 8);

      $this->recommend_shop_content = $rs->getString($startcol + 9);

      $this->additional_shop_info = $rs->getString($startcol + 10);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'RecommendShopSend.postHydrate', array('resultset' => $rs, 'startcol' => 11)));

            return $startcol + 11; 
    } catch (Exception $e) {
      throw new PropelException("Error populating RecommendShopSend object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseRecommendShopSend:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RecommendShopSendPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			RecommendShopSendPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseRecommendShopSend:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'RecommendShopSend.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseRecommendShopSend:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(RecommendShopSendPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(RecommendShopSendPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RecommendShopSendPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'RecommendShopSend.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseRecommendShopSend:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = RecommendShopSendPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += RecommendShopSendPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}


			if (($retval = RecommendShopSendPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RecommendShopSendPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getRecommendFrom();
				break;
			case 5:
				return $this->getFriendEmail();
				break;
			case 6:
				return $this->getRecommendShopLink();
				break;
			case 7:
				return $this->getVisited();
				break;
			case 8:
				return $this->getUniqidShop();
				break;
			case 9:
				return $this->getRecommendShopContent();
				break;
			case 10:
				return $this->getAdditionalShopInfo();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = RecommendShopSendPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getRecommendFrom(),
			$keys[5] => $this->getFriendEmail(),
			$keys[6] => $this->getRecommendShopLink(),
			$keys[7] => $this->getVisited(),
			$keys[8] => $this->getUniqidShop(),
			$keys[9] => $this->getRecommendShopContent(),
			$keys[10] => $this->getAdditionalShopInfo(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RecommendShopSendPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setRecommendFrom($value);
				break;
			case 5:
				$this->setFriendEmail($value);
				break;
			case 6:
				$this->setRecommendShopLink($value);
				break;
			case 7:
				$this->setVisited($value);
				break;
			case 8:
				$this->setUniqidShop($value);
				break;
			case 9:
				$this->setRecommendShopContent($value);
				break;
			case 10:
				$this->setAdditionalShopInfo($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = RecommendShopSendPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setRecommendFrom($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setFriendEmail($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setRecommendShopLink($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setVisited($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setUniqidShop($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setRecommendShopContent($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setAdditionalShopInfo($arr[$keys[10]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(RecommendShopSendPeer::DATABASE_NAME);

		if ($this->isColumnModified(RecommendShopSendPeer::CREATED_AT)) $criteria->add(RecommendShopSendPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(RecommendShopSendPeer::UPDATED_AT)) $criteria->add(RecommendShopSendPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(RecommendShopSendPeer::ID)) $criteria->add(RecommendShopSendPeer::ID, $this->id);
		if ($this->isColumnModified(RecommendShopSendPeer::SF_GUARD_USER_ID)) $criteria->add(RecommendShopSendPeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(RecommendShopSendPeer::RECOMMEND_FROM)) $criteria->add(RecommendShopSendPeer::RECOMMEND_FROM, $this->recommend_from);
		if ($this->isColumnModified(RecommendShopSendPeer::FRIEND_EMAIL)) $criteria->add(RecommendShopSendPeer::FRIEND_EMAIL, $this->friend_email);
		if ($this->isColumnModified(RecommendShopSendPeer::RECOMMEND_SHOP_LINK)) $criteria->add(RecommendShopSendPeer::RECOMMEND_SHOP_LINK, $this->recommend_shop_link);
		if ($this->isColumnModified(RecommendShopSendPeer::VISITED)) $criteria->add(RecommendShopSendPeer::VISITED, $this->visited);
		if ($this->isColumnModified(RecommendShopSendPeer::UNIQID_SHOP)) $criteria->add(RecommendShopSendPeer::UNIQID_SHOP, $this->uniqid_shop);
		if ($this->isColumnModified(RecommendShopSendPeer::RECOMMEND_SHOP_CONTENT)) $criteria->add(RecommendShopSendPeer::RECOMMEND_SHOP_CONTENT, $this->recommend_shop_content);
		if ($this->isColumnModified(RecommendShopSendPeer::ADDITIONAL_SHOP_INFO)) $criteria->add(RecommendShopSendPeer::ADDITIONAL_SHOP_INFO, $this->additional_shop_info);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(RecommendShopSendPeer::DATABASE_NAME);

		$criteria->add(RecommendShopSendPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setRecommendFrom($this->recommend_from);

		$copyObj->setFriendEmail($this->friend_email);

		$copyObj->setRecommendShopLink($this->recommend_shop_link);

		$copyObj->setVisited($this->visited);

		$copyObj->setUniqidShop($this->uniqid_shop);

		$copyObj->setRecommendShopContent($this->recommend_shop_content);

		$copyObj->setAdditionalShopInfo($this->additional_shop_info);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new RecommendShopSendPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'RecommendShopSend.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseRecommendShopSend:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseRecommendShopSend::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 