<?php

/**
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 16330 2011-12-01 11:25:50Z bartek $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */
/**
 * Przeciążenie klasy stRecommendProductFrontendActions
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'stRecommendProductFrontendPluginActions.class.php';

/**
 * stRecommendProductFrontend actions.
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
class stRecommendProductFrontendActions extends stRecommendProductFrontendPluginActions
{

   public function executeShowAddOverlay()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->config = stConfig::getInstance('stSecurityBackend');

      $this->updateFromRequest();

      $this->close = false;

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {

         $this->sendMail($this->product, $this->recommend);

         $this->close = true;
      }
   }

   public function validateShowAddOverlay()
   {
      $error_exists = false;
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {

         $i18n = $this->getContext()->getI18N();

         $validator = new stCaptchaGDValidator();

         $validator->initialize($this->getContext(), array('captcha_error' => 'Wprowadzono zły numer.'));


         $captcha = $this->getRequestParameter('captcha');

         if (!$validator->execute($captcha, $error) && !$this->getUser()->isAuthenticated())
         {
            $this->getRequest()->setError('captcha', $error);
//            $error_exists = true;
         }
      }
      return!$error_exists;
   }

   /**
    * Uchwyt do walidatora tworzenia konta.
    *
    * @return   string
    */
   public function handleErrorShowAddOverlay()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->close = false;

      $this->updateFromRequest();

      $this->config = stConfig::getInstance($this->getContext(), 'stSecurityBackend');

      return sfView::SUCCESS;
   }

   protected function updateFromRequest()
   {
      $config = stConfig::getInstance('stRecommendSendBackend');
      
      $this->product_id = $this->getRequestParameter('product_id');

      $this->product = ProductPeer::retrieveByPK($this->product_id);

      $recommend = $this->getRequestParameter('recommend', array('email' => ''));

      if (!isset($recommend['username']))
      {
         $recommend['username'] = $this->getUser()->isAuthenticated() ? $this->getUser()->getUsername() : null;
      }
      
      if (!isset($recommend['description']) || empty($recommend['description']))
      {
         $description = str_replace(array("{SKLEP}", "{SHOP}", "{PRODUKT}", "{PRODUCT}", "{LINK}"), array($this->getRequest()->getHost(), $this->getRequest()->getHost(), $this->product->getName(), $this->product->getName(), 'http://' . $this->getRequest()->getHost() . '/' . $this->product->getFriendlyUrl() . '.html'), $config->get('text_product', '', true));

         $recommend['description'] = $this->getRequestParameter('recommend[description]', $description);
      }

      $this->recommend = $recommend;

      $this->is_authenticated = $this->getUser()->isAuthenticated();
   }

   /**
    * Obsługuje wysyłanie mail'i
    */
   function SendMail($product, $recommend)
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $mail_error = $this->MailWithProductRecommendToUser($product, $recommend);

      return $mail_error;
   }

   /**
    * Wysyła mail z zamówieniem do administratora
    */
   function mailWithProductRecommendToUser($product, $recommend)
   {

      $this->smarty = new stSmarty($this->getModuleName());

      $language = LanguagePeer::retrieveByCulture($this->getUser()->getCulture());


        $uniqid = uniqid();
        $recommend_send = new RecommendSend();

        $recommend_send->setProductId($product->getId());
        $recommend_send->setRecommendFrom($recommend['username']);
        $recommend_send->setAdditionalInfo($recommend['description']);

        $recommend_send->setFriendEmail($recommend['email']);

            $c = new Criteria();
            $c->add(sfGuardUserPeer::USERNAME, $recommend['username']);
            $user = sfGuardUserPeer::doSelectOne($c);
            if($user)
            {
               $recommend_send->setSfGuardUserId($user->getId());
            }

        $recommend_send->setRecommendContent($recommend['description']);
        $recommend_send->setUniqid($uniqid);
        $recommend_send->setProductName($product->getName());
        $recommend_send->save();

      $mailHtmlHead = stMailer::getHtmlMailDescription("header");

      $mailHtmlFoot = stMailer::getHtmlMailDescription("footer");

      $sendProductRecommendHtmlMailMessage = stMailTemplate::render('sendProductRecommendHtml', array(
                  'product' => $product,
                  'recommend' => $recommend,
                  'head' => $mailHtmlHead,
                  'foot' => $mailHtmlFoot,
                  'languageShortcut' => $language->getShortcut(),
                  'smarty' => $this->smarty
              ));

      $mailPlainHead = stMailer::getPlainMailDescription("header");

      $mailPlainFoot = stMailer::getPlainMailDescription("footer");

      $sendProductRecommendPlainMailMessage = stMailTemplate::render('sendProductRecommendPlain', array(
                  'product' => $product,
                  'recommend' => $recommend,
                  'head' => $mailPlainHead,
                  'foot' => $mailPlainFoot,
                  'languageShortcut' => $language->getShortcut(),
                  'smarty' => $this->smarty
              ));

      $mail = stMailer::getInstance();
      return $mail->setSubject($this->getRequest()->getHost() . ' - ' . __('Polecenie produktu.'))->setHtmlMessage($sendProductRecommendHtmlMailMessage)->setPlainMessage($sendProductRecommendPlainMailMessage)->setTo($recommend['email'])->send();

      die('tutaj X2');
   }

}