<?php

/**
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 16356 2011-12-02 10:34:28Z krzysiek $
 */

/**
 * Akcje komponentu recommend
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>  
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
class stRecommendProductFrontendComponents extends sfComponents
{

   /**
    * Dodaje polecenie produktu, sprawdza czy produkt jest odwiedzony z polecenia
    */
   public function executeSend()
   {
      $this->smarty = new stSmarty('stRecommendProductFrontend');
   }

   /**
    * Dodaje polecenie produktu, sprawdza czy produkt jest odwiedzony z polecenia
    */
   public function executeFailed()
   {
      $this->smarty = new stSmarty('stRecommendProductFrontend');
   }

   /**
    * Dodaje polecenie produktu, sprawdza czy produkt jest odwiedzony z polecenia
    */
   public function executeIndex()
   {
      $this->smarty = new stSmarty('stRecommendProductFrontend');
   }

   public function executeShowRecommend()
   {
      $config =  stConfig::getInstance(sfContext::getInstance(), 'stProduct');
      if (!$config->get('show_product_recomandation'))
      {
          return sfView::NONE;
      }
      $this->smarty = new stSmarty('stRecommendProductFrontend');
      
      if (!isset($this->product))
      {
         $this->product_id = $this->getRequestParameter('product_id', $this->getRequestParameter('id'));
      }
      else
      {
         $this->product_id = $this->product->getId();
      }
   }

}
