<?php
/**
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stRecommendProductFrontendPluginActions.class.php 9952 2010-12-22 10:21:44Z piotr $
 */

/**
 * stRecommendProductFrontend actions.
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>  
 *
 * @package     stRecommendPlugin
 * @subpackage  libs
 */
class stRecommendProductFrontendPluginActions extends stActions
{

    /**
     * Wyświetla formularz polecenia produktu, wyświetla zdefinowane polecenia, jeśli są poleceniami dla produktu i są aktywne
     */
    public function executeIndex()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->setLayout(false);

        $this->config = stConfig::getInstance($this->getContext(), 'stSecurityBackend');

        if ($this->hasRequestParameter('send') && !$this->getRequest()->hasErrors())
        {
            $this->redirect('recommend/send?url='.$this->getRequestParameter('url'));
        }

        if($this->getUser()->isAuthenticated())
        {
            $this->user=$this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');
        } else {
            $this->user = '';
        }

        if (!empty($this->user))
        {
            $this->user_now = sfGuardUserPeer::retrieveByPK($this->user);
            $this->user_login = $this->user_now->getUsername();
        }

        if ($this->hasRequestParameter('product_id'))
        {
            $this->product = ProductPeer::retrieveByPK($this->getRequestParameter('product_id'));
        } 
        elseif ($this->hasRequestParameter('url'))
        {
            $c = new Criteria();
            $c->add(ProductI18nPeer::URL, $this->getRequestParameter('url'));
            $c->setLimit(1);
            $productI18n = ProductI18nPeer::doSelectJoinProduct($c);
            $this->product = $productI18n[0]->getProduct();
        }

        $this->error = $this->getRequest()->hasErrors();

        $config = stConfig::getInstance(sfContext::getInstance(), array('text_product' => stConfig::STRING), 'stRecommendSendBackend');
        $config->load();
        $this->text_product = $config->get('text_product');

        if ($this->hasRequestParameter('send_success'))
        {
            $this->rp = RecommendSendPeer::retrieveByPK($this->getRequestParameter('send_success'));
        }
    }

    /**
     * Wysyła rekomendację i zapuje ją do bazy
     */
    public function executeSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $config = stConfig::getInstance(sfContext::getInstance(), array('text_product' => stConfig::STRING), 'stRecommendSendBackend');
        $config->load();
        $this->text_product = $config->get('text_product');

        $this->rp = $this->getRequestParameter('recommend_product');

        if ($this->hasRequestParameter('url'))
        {
            $c = new Criteria();
            $c->add(ProductI18nPeer::URL, $this->getRequestParameter('url'));
            $c->setLimit(1);
            $productI18n = ProductI18nPeer::doSelectJoinProduct($c);
            $this->product = $productI18n[0]->getProduct();
        }

        if ($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'))
        {

            $user_id=$this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');

            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {

                $user = sfGuardUserPeer::retrieveByPK($user_id);

                if ($this->hasRequestParameter('url'))
                {
                    $c = new Criteria();
                    $c->add(ProductI18nPeer::URL, $this->getRequestParameter('url'));
                    $c->setLimit(1);
                    $productI18n = ProductI18nPeer::doSelectJoinProduct($c);
                    $product = $productI18n[0]->getProduct();
                }
                
                $this->rp = $this->getRequestParameter('recommend_product');

                $c = new Criteria();
                $c->add(RecommendSendPeer::SF_GUARD_USER_ID, $user_id);
                $c->add(RecommendSendPeer::PRODUCT_ID, $product->getId());
                $c->add(RecommendSendPeer::FRIEND_EMAIL, $this->rp['to']);
                $is_recommend = RecommendSendPeer::doSelectOne($c);

                if (!$is_recommend)
                {

                    $uniqid = uniqid();
                    $this->recommend_send = new RecommendSend();
                    $recommend_send = $this->getRequestParameter('recommend_send');
                    $this->recommend_send->setProductId($product->getId());
                    $this->recommend_send->setRecommendFrom($this->rp['from']);
                    $this->recommend_send->setAdditionalInfo($this->rp['additional_info']);
                    $this->recommend_send->setSfGuardUserId($user->getId());
                    $this->recommend_send->setFriendEmail($this->rp['to']);
                    $this->recommend_send->setRecommendContent($this->text_product);
                    $this->recommend_send->setUniqid($uniqid);
                    $this->recommend_send->setProductName($product->getName());
                    $this->recommend_send->save();

                    $mailHtmlHead = stMailer::getHtmlMailDescription(1);

                    $mailHtmlFoot = stMailer::getHtmlMailDescription(2);

                    $htmlMailMessage = stMailTemplate::render('_html',
                    array(
                    'to' => stXssSafe::clean($this->rp['to']),
                    'content' => nl2br($this->text_product),
                    'additional_info' => stXssSafe::clean($this->rp['additional_info']),
                    'from' => stXssSafe::clean($this->rp['from']),
                    'user' => $user,
                    'product' => $product,
                    'when' => $this->recommend_send->getCreatedAt(),
                    'head' => $mailHtmlHead,
                    'foot' => $mailHtmlFoot,
                    'link' => $this->recommend_send->getRecommendLink(),
                    'uniqid' => uniqid(),
                    'smarty' => $this->smarty
                    )
                    );

                    $mail = stMailer::getInstance();
                    $mail->setSubject($this->getRequest()->getHost().' - '.$this->getContext()->getI18n()->__('Polecenie produktu').': '.$product)->setHtmlMessage($htmlMailMessage)->setTo($this->rp['to'])->send();

                    return $this->redirect('product/show?url='.$this->getRequestParameter('url').'&product_description='.$this->getRequestParameter('product_description').'&send_success='.$this->recommend_send->getId());

                } else {

                    return $this->redirect('product/show?url='.$this->getRequestParameter('url').'&product_description='.$this->getRequestParameter('product_description').'&send_fail=2');
                }
            }

        } else {

            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {

                if ($this->hasRequestParameter('url'))
                {
                    $c = new Criteria();
                    $c->add(ProductI18nPeer::URL, $this->getRequestParameter('url'));
                    $c->setLimit(1);
                    $productI18n = ProductI18nPeer::doSelectJoinProduct($c);
                    $product = $productI18n[0]->getProduct();
                }

                $user = RecommendSendPeer::retrieveByPK($this->rp['from']);
                $this->rp = $this->getRequestParameter('recommend_product');

                $c = new Criteria();
                $c->add(RecommendSendPeer::RECOMMEND_FROM, $this->rp['from']);
                $c->add(RecommendSendPeer::PRODUCT_ID, $product->getId());
                $c->add(RecommendSendPeer::FRIEND_EMAIL, $this->rp['to']);
                $is_recommend = RecommendSendPeer::doSelectOne($c);

                if (!$is_recommend)
                {
                    $this->recommend_send = new RecommendSend();
                    $recommend_send = $this->getRequestParameter('recommend_send');
                    $this->recommend_send->setProductId($product->getId());
                    $this->recommend_send->setRecommendFrom($this->rp['from']);
                    $this->recommend_send->setAdditionalInfo($this->rp['additional_info']);
                    $this->recommend_send->setFriendEmail($this->rp['to']);
                    $this->recommend_send->setRecommendContent($this->text_product);
                    $this->recommend_send->setProductName($product->getName());
                    $this->recommend_send->save();

                    $mailHtmlHead = stMailer::getHtmlMailDescription(1);

                    $mailHtmlFoot = stMailer::getHtmlMailDescription(2);

                    $htmlMailMessage = stMailTemplate::render('_html',
                    array(
                    'to' => stXssSafe::clean($this->rp['to']),
                    'content' => nl2br($this->text_product),
                    'from' => stXssSafe::clean($this->rp['from']),
                    'additional_info' => stXssSafe::clean($this->rp['additional_info']),
                    'when' => $this->recommend_send->getCreatedAt(),
                    'head' => $mailHtmlHead,
                    'foot' => $mailHtmlFoot,
                    'product' => $product,
                    'link' => $this->recommend_send->getRecommendLink(),
                    'smarty' => $this->smarty
                    )
                    );

                    $mail = stMailer::getInstance();
                    $mail->setSubject($this->getRequest()->getHost().' - '.$this->getContext()->getI18n()->__('Polecenie produktu').': '.$product)->setHtmlMessage($htmlMailMessage)->setTo($this->rp['to'])->send();

                    return $this->redirect('product/show?url='.$this->getRequestParameter('url').'&product_description='.$this->getRequestParameter('product_description').'&send_success='.$this->recommend_send->getId());

                } else {

                    return $this->redirect('product/show?url='.$this->getRequestParameter('url').'&product_description='.$this->getRequestParameter('product_description').'&send_fail=1');
                }
            }
        }
    }

    /**
     * Informuje o próbie ponownego polecenia sklepu tej samej osobie
     */
    public function executeFailed()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        if ($this->hasRequestParameter('id'))
        {
            $this->recommend_send = RecommendSendPeer::retrieveByPK($this->getRequestParameter('id'));

                if ($this->hasRequestParameter('url'))
                {
                    $c = new Criteria();
                    $c->add(ProductI18nPeer::URL, $this->getRequestParameter('url'));
                    $c->setLimit(1);
                    $productI18n = ProductI18nPeer::doSelectJoinProduct($c);
                    $this->product = $productI18n[0]->getProduct();
                }
        }
    }

    /**
     * Informuje o nieudanym wysłaniu polecenia sklepu
     */
    public function handleErrorSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->getRequest()->setParameter('error_code', $this->getRequestParameter('url'));
        $this->getRequest()->setParameter('product_description', $this->getRequestParameter('product_description'));
        $this->getRequest()->setParameter('id', $this->getRequestParameter('product_id'));
        $this->forward('stProduct', 'show');
    }

    /**
     * Informuje o nieudanym wysłaniu polecenia sklepu
     */
    public function validateSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        if (empty($this->user))
        {
            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {
                $error_exists = false;

                $i18n = $this->getContext()->getI18N();

                $validator = new stCaptchaGDValidator();

                $validator->initialize($this->getContext(), array('captcha_error' => $this->getContext()->getI18N()->__('Wpisz poprawne cyfry')));

                $captcha = $this->getRequestParameter('captcha');

                if (!$validator->execute($captcha, $error))
                {
                    $this->getRequest()->setError('captcha', $error);
                    $error_exists = true;
                }

                return !$error_exists;
            }
        }
    }
}