<?php
use_helper('Validation', 'stCaptchaGD', 'Object', 'Javascript', 'Tag', 'stUrl');
st_theme_use_stylesheet('stRecommendPlugin.css');

$smarty->assign('form_start', form_tag('recommend/send?url='.$product->getFriendlyUrl().'&product_description='.$sf_request->getParameter('product_description').'#recommend', array('class' => 'st_form')));
$smarty->assign('label_content', label_for('recommend_product[content]',__('treść wiadomości'), array('style' => 'font-weight:normal')));
$smarty->assign('recommend_product_text', str_replace(array("{SKLEP}", "{SHOP}", "{PRODUKT}", "{PRODUCT}", "<p>", "</p>"), array($sf_request->getHost(), $sf_request->getHost(), $product->getName(), $product->getName(),'', '<br />'), $text_product));
$smarty->assign('error_from', form_error('recommend_product[from]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign('label_from', label_for('recommend_product[from]',__('twój adres e-mail')));

if ($error)
{
    $smarty->assign('error', $error);
    $smarty->assign('input_from', input_tag('recommend_product[from]', $sf_params->get('recommend_product[from]'), array('id'=>'input', 'class'=>form_has_error('recommend_product{from}') ? 'st_form-error' : '')));
}
else
{
    if (!empty($user))
    {
        $smarty->assign('not_empty_user', !empty($user));
        $smarty->assign('input_from', input_tag('recommend_product[from]', $user_login, array('id'=>'input', 'class'=>form_has_error('recommend_product{from}') ? 'st_form-error' : '')));
    }
    else
    {
        $smarty->assign('input_from', input_tag('recommend_product[from]', $sf_params->get('recommend_product[from]'), array('id'=>'input', 'class'=>form_has_error('recommend_product{from}') ? 'st_form-error' : '')));
    }
}
$smarty->assign('label_additional_product_info', label_for('recommend_product[additional_info]',__('informacje dodatkowe'), array('style' => 'font-weight:normal')));
$smarty->assign('text_additional_product_info', textarea_tag('recommend_product[additional_info]', $sf_params->get('recommend_product[additional_info]'), array('id' => 'additional_info', 'rows' => 5)));
$smarty->assign('error_to', form_error('recommend_product[to]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign('label_to', label_for('recommend_product[to]',__('adres e-mail Twojego znajomego')));
$smarty->assign('input_to', input_tag('recommend_product[to]', $sf_params->get('recommend_product[to]'), array('id'=>'input', 'class'=>form_has_error('recommend_product{to}') ? 'st_form-error' : '')));

if($config->get('captcha_on', stConfig::INT)==1 && !$user)
{
    $smarty->assign('captcha_on', $config->get('captcha_on', stConfig::INT)==1 && !$user);
    $smarty->assign('get_captcha', get_captcha($imageWidth = '323'));
    $smarty->assign('error_captcha', form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
    $smarty->assign('label_captcha', label_for('captcha',__('cyfry z obrazka')));
    $smarty->assign('input_captcha', input_tag('captcha', '', array('id'=>'input', 'class'=>form_has_error('captcha') ? 'st_form-error' : '')));
}

$smarty->assign('send_submit', submit_tag(__('Wyślij'), 'name=send', 'recommend/send?url='.$product->getFriendlyUrl().'&product_description='.$sf_request->getParameter('product_description').'#recommend'));
$smarty->display('recommend_product_index_comp.html');
?>