<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 16330 2011-12-01 11:25:50Z bartek $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/** 
 * Przeciążenie klasy stRecommendShopFrontendActions
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'stRecommendShopFrontendPluginActions.class.php';

/** 
 * stRecommendShopFrontend actions.
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
class stRecommendShopFrontendActions extends stRecommendShopFrontendPluginActions
{
    public function executeShowAddOverlay()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->config = stConfig::getInstance('stSecurityBackend');


        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
         
            $recommend = $this->getRequestParameter('recommend');

            $this->sendMail($recommend);

            $this->close = true;
        }

        $this->is_authenticated = $this->getUser()->isAuthenticated();

        $config = stConfig::getInstance('stRecommendSendBackend');

        $text_shop = $config->get('text_shop', '', true);

        $recommend['username'] = $this->getRequestParameter('recommend[username]', $this->getUser()->isAuthenticated() ? $this->getUser()->getUsername() : false);

        $recommend_text_product = str_replace(array("{SKLEP}", "{SHOP}", "<p>", "</p>"), array($this->getRequest()->getHost(), $this->getRequest()->getHost(), '', '<br />'), $text_shop);

        $recommend['description'] = $this->getRequestParameter('recommend[description]', $recommend_text_product);

        $this->recommend = $recommend;
    }

    public function validateShowAddOverlay()
    {
        $error_exists = false;
        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {

        $i18n = $this->getContext()->getI18N();

        $validator = new stCaptchaGDValidator();

        $validator->initialize($this->getContext(), array('captcha_error' => 'Wprowadzono zły numer.'));


        $captcha = $this->getRequestParameter('captcha');

        if (!$validator->execute($captcha, $error) && !$this->getUser()->isAuthenticated())
        {
            $this->getRequest()->setError('captcha', $error);
            $error_exists = true;
        }

        }
        return !$error_exists;
    }

    /**
    * Uchwyt do walidatora tworzenia konta.
    *
    * @return   string
    */
    public function handleErrorShowAddOverlay()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->recommend = $this->getRequestParameter('recommend');

        $this->is_authenticated = $this->getUser()->isAuthenticated();

        $this->config = stConfig::getInstance('stSecurityBackend');
        return sfView::SUCCESS;
    }

    /**
    * Obsługuje wysyłanie mail'i
    */
    function SendMail($recommend)
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $mail_error = $this->MailWithShopRecommendToUser($recommend);

        return $mail_error;
    }

    /**
    * Wysyła mail z zamówieniem do administratora
    */
    function mailWithShopRecommendToUser($recommend)
    {
        $uniqid = uniqid();
        $recommend_shop_send = new RecommendShopSend();
        $recommend_shop_send->setRecommendFrom($recommend['username']);

            $c = new Criteria();
            $c->add(sfGuardUserPeer::USERNAME, $recommend['username']);
            $user = sfGuardUserPeer::doSelectOne($c);
            if($user)
            {
               $recommend_shop_send->setSfGuardUserId($user->getId());
            }

        $recommend_shop_send->setUniqidShop($uniqid);
        $recommend_shop_send->setFriendEmail($recommend['email']);
        $recommend_shop_send->setRecommendShopContent($recommend['description']);
        $recommend_shop_send->setAdditionalShopInfo($recommend['description']);
        $recommend_shop_send->save();

        $this->smarty = new stSmarty($this->getModuleName());

        $language = LanguagePeer::retrieveByCulture($this->getUser()->getCulture());

        $mailHtmlHead = stMailer::getHtmlMailDescription("header");

        $mailHtmlFoot = stMailer::getHtmlMailDescription("footer");

        $sendShopRecommendHtmlMailMessage = stMailTemplate::render('sendShopRecommendHtml', array(
        'recommend' => $recommend,
        'head' => $mailHtmlHead,
        'foot' => $mailHtmlFoot,
        'languageShortcut' => $language->getShortcut(),
        'smarty' => $this->smarty
        ));

        $mailPlainHead = stMailer::getPlainMailDescription("header");

        $mailPlainFoot = stMailer::getPlainMailDescription("footer");

        $sendShopRecommendPlainMailMessage = stMailTemplate::render('sendShopRecommendPlain', array(
        'recommend' => $recommend,
        'head' => $mailPlainHead,
        'foot' => $mailPlainFoot,
        'languageShortcut' => $language->getShortcut(),
        'smarty' => $this->smarty
        ));

        $mail = stMailer::getInstance();
        return $mail->setSubject($this->getRequest()->getHost().' - '.__('Polecenie sklepu.'))->setHtmlMessage($sendShopRecommendHtmlMailMessage)->setPlainMessage($sendShopRecommendPlainMailMessage)->setTo($recommend['email'])->send();;
    }


}
