<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 12741 2011-05-13 09:37:02Z bartek $
 */

/** 
 * Akcje komponentu rekomendacje
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>  
 *
 * @package     stRecommendPlugin
 * @subpackage  actions
 */
class stRecommendShopFrontendComponents extends sfComponents
{
    
    /** 
     * Dodaje rekomendację sklepu, sprawdza czy użytkownik wchodzi do sklepu z polecenia innego użytkownika
     */
    public function executeIndex()
    {
        $this->smarty = new stSmarty('stRecommendShopFrontend');
        
        if ($this->hasRequestParameter('uniqid')) {
            
            $c = new Criteria();
            
            $c->add(RecommendSendPeer::RECOMMEND_LINK,'http://'.$sf_request->getHost().'/index.php?='.'&uniqid='.$this->getRequestParameter('uniqid'));
            
            $recomm_shop = RecommendSendPeer::doSelectOne($c);
            
            if ($recomm_shop) {
                
                $recomm_shop->setVisited(1);
                
                $recomm_shop->save();
                
            }
        }
        
        if ($this->getUser()->hasAttribute('user_id'))
        
        {

            $this->user=$this->getUser()->getAttribute('user_id');
        
        }
    }

    public function executeShowRecommend()
    {
        $this->smarty = new stSmarty('stRecommendShopFrontend');
    }
    
}