<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stRecommendShopFrontendPluginActions.class.php 9952 2010-12-22 10:21:44Z piotr $
 */

/** 
 * stRecommendShopFrontend actions.
 *
 * @author Paweł Byszewski <pawel.byszewski@sote.pl>  
 *
 * @package     stRecommendPlugin
 * @subpackage  libs
 */
class stRecommendShopFrontendPluginActions extends stActions
{
    /** 
     * Wyświetla formularz polecenia sklepu, wyświetla zdefinowane polecenia, jeśli są poleceniami dla sklepu i są aktywne
     */
    public function executeIndex()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        
        $this->config = stConfig::getInstance($this->getContext(), 'stSecurityBackend');

        if ($this->hasRequestParameter('send') && !$this->getRequest()->hasErrors())
        {
            $this->redirect('recommend_shop/send');
        }

        if($this->getUser()->isAuthenticated())
        {
            $this->user=$this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');
        } else {
            $this->user = '';
        }

        if (!empty($this->user))
        {
            $this->user_now = sfGuardUserPeer::retrieveByPK($this->user);
            $this->user_login = $this->user_now->getUsername();
        }

        $this->error = $this->getRequest()->hasErrors();

        $config = stConfig::getInstance(sfContext::getInstance(), array('text_shop' => stConfig::STRING), 'stRecommendSendBackend');
        $config->load();
        $this->text_shop = $config->get('text_shop');
    }

    /** 
     * Wysyła rekomendację i zapisuje ją do bazy
     */
    public function executeSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        
        $config = stConfig::getInstance(sfContext::getInstance(), array('text_shop' => stConfig::STRING), 'stRecommendSendBackend');
        $config->load();
        $this->text_shop = $config->get('text_shop');

        if ($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'))
        {
            $this->user=$this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');

            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {
                $user = sfGuardUserPeer::retrieveByPK($this->user);
                $this->rs = $this->getRequestParameter('recommend_shop');

                $c = new Criteria();
                $c->add(RecommendShopSendPeer::SF_GUARD_USER_ID, $this->user);
                $c->add(RecommendShopSendPeer::FRIEND_EMAIL, $this->rs['to']);
                $is_recommend_shop = RecommendShopSendPeer::doSelectOne($c);
                
                if (!$is_recommend_shop)
                {

                    $uniqid = uniqid();
                    $this->recommend_shop_send = new RecommendShopSend();
                    $recommend_shop_send = $this->getRequestParameter('recommend_shop_send');
                    $this->recommend_shop_send->setSfGuardUserId($this->user);
                    $this->recommend_shop_send->setRecommendFrom($this->rs['from']);
                    $this->recommend_shop_send->setAdditionalShopInfo($this->rs['additional_shop_info']);
                    $this->recommend_shop_send->setFriendEmail($this->rs['to']);
                    $this->recommend_shop_send->setRecommendShopContent($this->text_shop);
                    $this->recommend_shop_send->setUniqidShop($uniqid);
                    $this->recommend_shop_send->save();

                    $mailHtmlHead = stMailer::getHtmlMailDescription(1);
                
                    $mailHtmlFoot = stMailer::getHtmlMailDescription(2);
                    
                    $htmlMailMessage = stMailTemplate::render('_html',
                    array(
                    'to' => stXssSafe::clean($this->rs['to']),
                    'from' => stXssSafe::clean($this->rs['from']),
                    'additional_shop_info' => stXssSafe::clean($this->rs['additional_shop_info']),
                    'content' => nl2br($this->text_shop),
                    'user' => $user,
                    'when' => $this->recommend_shop_send->getCreatedAt(),
                    'link' => $this->recommend_shop_send->getRecommendShopLink(),
                    'uniqid' => $uniqid,
                    'head' => $mailHtmlHead,
                    'foot' => $mailHtmlFoot,
                    'smarty' =>$this->smarty
                    ));

                    $mail = stMailer::getInstance();
                    $mail->setSubject($this->getRequest()->getHost().' - '.$this->getContext()->getI18n()->__('Polecenie sklepu.'))->setHtmlMessage($htmlMailMessage)->setTo($this->rs['to'])->send();
                    
                } else {
                    
                    $this->redirect('recommend_shop/failed');
                }
            }
            
        } else {
            
            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {
                $user = RecommendShopSendPeer::retrieveByPK($this->rs['from']);
                $this->rs = $this->getRequestParameter('recommend_shop');

                $c = new Criteria();
                $c->add(RecommendShopSendPeer::RECOMMEND_FROM, $this->rs['from']);
                $c->add(RecommendShopSendPeer::FRIEND_EMAIL, $this->rs['to']);
                $is_recommend_shop = RecommendShopSendPeer::doSelectOne($c);
                
                if (!$is_recommend_shop)
                {
                    $this->recommend_shop_send = new RecommendShopSend();
                    $recommend_shop_send = $this->getRequestParameter('recommend_shop_send');
                    $this->recommend_shop_send->setRecommendFrom($this->rs['from']);
                    $this->recommend_shop_send->setFriendEmail($this->rs['to']);
                    $this->recommend_shop_send->setRecommendShopContent($this->text_shop);
                    $this->recommend_shop_send->setAdditionalShopInfo($this->rs['additional_shop_info']);
                    $this->recommend_shop_send->save();
        
                    $mailHtmlHead = stMailer::getHtmlMailDescription(1);
                
                    $mailHtmlFoot = stMailer::getHtmlMailDescription(2);
                    
                    $htmlMailMessage = stMailTemplate::render('_html',
                    array(
                    'to' => stXssSafe::clean($this->rs['to']),
                    'additional_shop_info' => stXssSafe::clean($this->rs['additional_shop_info']),
                    'from' => stXssSafe::clean($this->rs['from']),
                    'content' => nl2br($this->text_shop),
                    'when' => $this->recommend_shop_send->getCreatedAt(),
                    'link' => $this->recommend_shop_send->getRecommendShopLink(),
                    'head' => $mailHtmlHead,
                    'foot' => $mailHtmlFoot,
                    'smarty' => $this->smarty
                    ));

                    $mail = stMailer::getInstance();
                    $mail->setSubject($this->getRequest()->getHost().' - '.$this->getContext()->getI18n()->__('Polecenie sklepu.'))->setHtmlMessage($htmlMailMessage)->setTo($this->rs['to'])->send();
                    
                } else {

                    $this->redirect('recommend_shop/failed');
                }
            }
        }
    }

    /** 
     * Informuje o próbie ponownego polecenia sklepu tej samej osobie
     */
    public function executeFailed()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        
        if ($this->hasRequestParameter('id'))
        {
            $this->recommend_shop_send = RecommendShopSendPeer::retrieveByPK($this->getRequestParameter('id'));
        }
    }

    /** 
     * Informuje o nieudanym wysłaniu polecenia sklepu
     */
    public function handleErrorSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        
        $this->getRequest()->setParameter('error_code', '');
        $this->forward('stRecommendShopFrontend','index');
    }

    /** 
     * Informuje o nieudanym wysłaniu polecenia sklepu
     */
    public function validateSend()
    {
        $this->smarty = new stSmarty($this->getModuleName());
        
        if (empty($this->user))
        {
            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {
                $error_exists = false;

                $i18n = $this->getContext()->getI18N();

                $validator = new stCaptchaGDValidator();

                $validator->initialize($this->getContext(), array('captcha_error' => $this->getContext()->getI18N()->__('Wpisz poprawne cyfry')));

                $captcha = $this->getRequestParameter('captcha');

                if (!$validator->execute($captcha, $error))
                {
                    $this->getRequest()->setError('captcha', $error);
                    $error_exists = true;
                }

                return !$error_exists;
            }
        }
    }
}