<?php
use_helper('Validation', 'stCaptchaGD', 'Object', 'Javascript', 'Tag');
st_theme_use_stylesheet('stRecommendPlugin.css');

$smarty->assign('form_start', form_tag('recommend_shop/send', array('class' => 'st_form')));
$smarty->assign('label_content', label_for('recommend_shop[content]',__('treść wiadomości'), array('style' => 'font-weight:normal')));
$smarty->assign('recommend_shop_text', str_replace(array("{SKLEP}", "{SHOP}", "<p>", "</p>"), array($sf_request->getHost(), $sf_request->getHost(), '', '<br />'), $text_shop));
$smarty->assign('error_from', form_error('recommend_shop[from]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign('label_from', label_for('recommend_shop[from]',__('twój adres e-mail')));

if ($error)
{
    $smarty->assign('error', $error);
    $smarty->assign('input_from', input_tag('recommend_shop[from]', $sf_params->get('recommend_shop[from]'), array('id'=>'input', 'class'=>form_has_error('recommend_shop{from}') ? 'st_form-error' : '')));
}
else
{
    if (!empty($user))
    {
        $smarty->assign('not_empty_user', !empty($user));
        $smarty->assign('input_from', input_tag('recommend_shop[from]', $user_login, array('id'=>'input', 'class'=>form_has_error('recommend_shop{from}') ? 'st_form-error' : '')));
    }
    else
    {
        $smarty->assign('input_from', input_tag('recommend_shop[from]', $sf_params->get('recommend_shop[from]'), array('id'=>'input', 'class'=>form_has_error('recommend_shop{from}') ? 'st_form-error' : '')));
    }
}

$smarty->assign('label_additional_shop_info', label_for('recommend_shop[additional_shop_info]',__('informacje dodatkowe'), array('style' => 'font-weight:normal')));
$smarty->assign('text_additional_shop_info', textarea_tag('recommend_shop[additional_shop_info]', $sf_params->get('recommend_shop[additional_shop_info]'), array('id' => 'additional_info', 'rows' => 5)));
$smarty->assign('error_to', form_error('recommend_shop[to]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
$smarty->assign('label_to', label_for('recommend_shop[to]',__('adres e-mail Twojego znajomego')));
$smarty->assign('input_to', input_tag('recommend_shop[to]', $sf_params->get('recommend_shop[to]'), array('id'=>'input', 'class'=>form_has_error('recommend_shop{to}') ? 'st_form-error' : '')));

if($config->get('captcha_on', stConfig::INT)==1 && !$user)
{
    $smarty->assign('captcha_on', $config->get('captcha_on', stConfig::INT)==1 && !$user);
    $smarty->assign('get_captcha', get_captcha($imageWidth = '323'));
    $smarty->assign('error_captcha', form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));
    $smarty->assign('label_captcha', label_for('captcha',__('cyfry z obrazka')));
    $smarty->assign('input_captcha', input_tag('captcha', '', array('id'=>'input', 'class'=>form_has_error('captcha') ? 'st_form-error' : '')));
}

$smarty->assign('send_submit', submit_tag(__('Wyślij'), 'name=send'));
$smarty->display('recommend_shop_index.html');
?>