<?php
use_helper('Validation', 'stCaptchaGD', 'stUrl');

$smarty->assign('form_start', form_tag('stRecommendShopFrontend/showAddOverlay', array('id' => 'form_recommend')));


$smarty->assign('label_description', label_for('recommend[description]',__('Treść')));

$smarty->assign('input_description', textarea_tag('recommend[description]',  $recommend['description'], array('id'=>'st_form-recommend-description','class'=>form_has_error('recommend{description}') ? 'st_form-error' : '')));


$smarty->assign('label_email', label_for('recommend[email]',__('Adresat (e-mail)')));

$smarty->assign('error_email', form_error('recommend[email]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));

$smarty->assign('input_email', input_tag('recommend[email]',  $recommend['email'], array('id'=>'st_form-recommend-email','class'=>form_has_error('recommend{email}') ? 'st_form-error' : '')));


$smarty->assign('label_username', label_for('recommend[username]',__('Nadawca (e-mail)')));

$smarty->assign('error_username', form_error('recommend[username]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));

$smarty->assign('input_username', input_tag('recommend[username]',  $recommend['username'], array('id'=>'st_form-recommend-email','class'=>form_has_error('recommend{username}') ? 'st_form-error' : '')));

if($config->get('captcha_on', stConfig::INT)==1)
{

    $smarty->assign('captcha_on', $config->get('captcha_on', stConfig::INT)==1);

    $smarty->assign('error_captcha', form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));

    $smarty->assign('get_captcha', get_captcha(328));

    $smarty->assign('label_captcha', label_for('captcha',__('Cyfry z obrazka')));

    $smarty->assign('input_captcha', input_tag('captcha', '', array('id'=>'st_form-recommend-captcha','class'=>form_has_error('captcha') ? 'st_form-error' : '')));
}

$smarty->assign('recommend_submit', submit_tag(__('Wyślij'), array('id'=>'st_button_recommend_add')));

$smarty->assign('is_authenticated', $is_authenticated);


$smarty->display('recommend_show_add_overlay.html');

?>

<script type="text/javascript" language="javascript">
    jQuery(function ($) {
        $('#form_recommend').submit(function() {
            $.post($(this).attr('action'), $(this).serialize(), function(data) { $('#recommend_shop_overlay').find('.recommend_shop_overlay_content').html(data); });

            return false;
        });
    });
</script>

<?php if(@$close): ?>
    
<script type="text/javascript" language="javascript">
    jQuery(function ($) {
        $('#recommend_shop_overlay').overlay().close();
        location.reload();
    });

</script>

<?php endif; ?>

