<?php


abstract class BaseBackendAlert extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $display;


	
	protected $code;


	
	protected $opt_description;

	
	protected $collBackendAlertI18ns;

	
	protected $lastBackendAlertI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getDisplay()
    {

            return $this->display;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = BackendAlertPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = BackendAlertPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = BackendAlertPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = BackendAlertPeer::OPT_NAME;
        }

	} 
	
	public function setDisplay($v)
	{

        if ($this->display !== $v) {
          $this->display = $v;
          $this->modifiedColumns[] = BackendAlertPeer::DISPLAY;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = BackendAlertPeer::CODE;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = BackendAlertPeer::OPT_DESCRIPTION;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'BackendAlert.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->display = $rs->getBoolean($startcol + 4);

      $this->code = $rs->getString($startcol + 5);

      $this->opt_description = $rs->getString($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'BackendAlert.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating BackendAlert object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseBackendAlert:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BackendAlertPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			BackendAlertPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseBackendAlert:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'BackendAlert.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseBackendAlert:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(BackendAlertPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(BackendAlertPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BackendAlertPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'BackendAlert.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseBackendAlert:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = BackendAlertPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += BackendAlertPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collBackendAlertI18ns !== null) {
				foreach($this->collBackendAlertI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = BackendAlertPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBackendAlertI18ns !== null) {
					foreach($this->collBackendAlertI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BackendAlertPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getDisplay();
				break;
			case 5:
				return $this->getCode();
				break;
			case 6:
				return $this->getOptDescription();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BackendAlertPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getDisplay(),
			$keys[5] => $this->getCode(),
			$keys[6] => $this->getOptDescription(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BackendAlertPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setDisplay($value);
				break;
			case 5:
				$this->setCode($value);
				break;
			case 6:
				$this->setOptDescription($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BackendAlertPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDisplay($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setCode($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptDescription($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(BackendAlertPeer::DATABASE_NAME);

		if ($this->isColumnModified(BackendAlertPeer::CREATED_AT)) $criteria->add(BackendAlertPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(BackendAlertPeer::UPDATED_AT)) $criteria->add(BackendAlertPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(BackendAlertPeer::ID)) $criteria->add(BackendAlertPeer::ID, $this->id);
		if ($this->isColumnModified(BackendAlertPeer::OPT_NAME)) $criteria->add(BackendAlertPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(BackendAlertPeer::DISPLAY)) $criteria->add(BackendAlertPeer::DISPLAY, $this->display);
		if ($this->isColumnModified(BackendAlertPeer::CODE)) $criteria->add(BackendAlertPeer::CODE, $this->code);
		if ($this->isColumnModified(BackendAlertPeer::OPT_DESCRIPTION)) $criteria->add(BackendAlertPeer::OPT_DESCRIPTION, $this->opt_description);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(BackendAlertPeer::DATABASE_NAME);

		$criteria->add(BackendAlertPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setDisplay($this->display);

		$copyObj->setCode($this->code);

		$copyObj->setOptDescription($this->opt_description);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getBackendAlertI18ns() as $relObj) {
				$copyObj->addBackendAlertI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new BackendAlertPeer();
		}
		return self::$peer;
	}

	
	public function initBackendAlertI18ns()
	{
		if ($this->collBackendAlertI18ns === null) {
			$this->collBackendAlertI18ns = array();
		}
	}

	
	public function getBackendAlertI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBackendAlertI18ns === null) {
			if ($this->isNew()) {
			   $this->collBackendAlertI18ns = array();
			} else {

				$criteria->add(BackendAlertI18nPeer::ID, $this->getId());

				BackendAlertI18nPeer::addSelectColumns($criteria);
				$this->collBackendAlertI18ns = BackendAlertI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BackendAlertI18nPeer::ID, $this->getId());

				BackendAlertI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastBackendAlertI18nCriteria) || !$this->lastBackendAlertI18nCriteria->equals($criteria)) {
					$this->collBackendAlertI18ns = BackendAlertI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBackendAlertI18nCriteria = $criteria;
		return $this->collBackendAlertI18ns;
	}

	
	public function countBackendAlertI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BackendAlertI18nPeer::ID, $this->getId());

		return BackendAlertI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBackendAlertI18n(BackendAlertI18n $l)
	{
		$this->collBackendAlertI18ns[] = $l;
		$l->setBackendAlert($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentBackendAlertI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentBackendAlertI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentBackendAlertI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentBackendAlertI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentBackendAlertI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = BackendAlertI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setBackendAlertI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setBackendAlertI18nForCulture(new BackendAlertI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setBackendAlertI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addBackendAlertI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'BackendAlert.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseBackendAlert:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseBackendAlert::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 