<?php


abstract class BaseProductSearchIndex extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $culture;


	
	protected $name;


	
	protected $simple_search;


	
	protected $advanced_search;


	
	protected $advanced_name;

	
	protected $aProduct;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCulture()
    {

            return $this->culture;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getSimpleSearch()
    {

            return $this->simple_search;
    }

    
    public function getAdvancedSearch()
    {

            return $this->advanced_search;
    }

    
    public function getAdvancedName()
    {

            return $this->advanced_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductSearchIndexPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductSearchIndexPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setCulture($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->culture !== $v) {
          $this->culture = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::CULTURE;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::NAME;
        }

	} 
	
	public function setSimpleSearch($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->simple_search !== $v) {
          $this->simple_search = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::SIMPLE_SEARCH;
        }

	} 
	
	public function setAdvancedSearch($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->advanced_search !== $v) {
          $this->advanced_search = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::ADVANCED_SEARCH;
        }

	} 
	
	public function setAdvancedName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->advanced_name !== $v) {
          $this->advanced_name = $v;
          $this->modifiedColumns[] = ProductSearchIndexPeer::ADVANCED_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductSearchIndex.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->culture = $rs->getString($startcol + 3);

      $this->name = $rs->getString($startcol + 4);

      $this->simple_search = $rs->getString($startcol + 5);

      $this->advanced_search = $rs->getString($startcol + 6);

      $this->advanced_name = $rs->getString($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductSearchIndex.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductSearchIndex object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductSearchIndex:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductSearchIndexPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductSearchIndexPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductSearchIndex:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductSearchIndex.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductSearchIndex:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductSearchIndexPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductSearchIndexPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductSearchIndexPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductSearchIndex.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductSearchIndex:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductSearchIndexPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += ProductSearchIndexPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}


			if (($retval = ProductSearchIndexPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductSearchIndexPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCulture();
				break;
			case 4:
				return $this->getName();
				break;
			case 5:
				return $this->getSimpleSearch();
				break;
			case 6:
				return $this->getAdvancedSearch();
				break;
			case 7:
				return $this->getAdvancedName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductSearchIndexPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCulture(),
			$keys[4] => $this->getName(),
			$keys[5] => $this->getSimpleSearch(),
			$keys[6] => $this->getAdvancedSearch(),
			$keys[7] => $this->getAdvancedName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductSearchIndexPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCulture($value);
				break;
			case 4:
				$this->setName($value);
				break;
			case 5:
				$this->setSimpleSearch($value);
				break;
			case 6:
				$this->setAdvancedSearch($value);
				break;
			case 7:
				$this->setAdvancedName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductSearchIndexPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCulture($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSimpleSearch($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setAdvancedSearch($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAdvancedName($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductSearchIndexPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductSearchIndexPeer::CREATED_AT)) $criteria->add(ProductSearchIndexPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductSearchIndexPeer::UPDATED_AT)) $criteria->add(ProductSearchIndexPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductSearchIndexPeer::ID)) $criteria->add(ProductSearchIndexPeer::ID, $this->id);
		if ($this->isColumnModified(ProductSearchIndexPeer::CULTURE)) $criteria->add(ProductSearchIndexPeer::CULTURE, $this->culture);
		if ($this->isColumnModified(ProductSearchIndexPeer::NAME)) $criteria->add(ProductSearchIndexPeer::NAME, $this->name);
		if ($this->isColumnModified(ProductSearchIndexPeer::SIMPLE_SEARCH)) $criteria->add(ProductSearchIndexPeer::SIMPLE_SEARCH, $this->simple_search);
		if ($this->isColumnModified(ProductSearchIndexPeer::ADVANCED_SEARCH)) $criteria->add(ProductSearchIndexPeer::ADVANCED_SEARCH, $this->advanced_search);
		if ($this->isColumnModified(ProductSearchIndexPeer::ADVANCED_NAME)) $criteria->add(ProductSearchIndexPeer::ADVANCED_NAME, $this->advanced_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductSearchIndexPeer::DATABASE_NAME);

		$criteria->add(ProductSearchIndexPeer::ID, $this->id);
		$criteria->add(ProductSearchIndexPeer::CULTURE, $this->culture);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getId();

		$pks[1] = $this->getCulture();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setId($keys[0]);

		$this->setCulture($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setName($this->name);

		$copyObj->setSimpleSearch($this->simple_search);

		$copyObj->setAdvancedSearch($this->advanced_search);

		$copyObj->setAdvancedName($this->advanced_name);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
		$copyObj->setCulture(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductSearchIndexPeer();
		}
		return self::$peer;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setId(NULL);
		} else {
			$this->setId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->id, $con);

			
		}
		return $this->aProduct;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductSearchIndex.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductSearchIndex:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductSearchIndex::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 