<?php
/**
 * 
 * @author Sote
 *
 */
class stSearchOptimize {
    /**
     * Avaible langs
     * @var array
     */
    protected $languages = null;

    /**
     * Products per step
     * @var integer
     */
    protected $limit = 5;

    /**
     * public construcotr
     * @return unknown_type
     */
    public function __construct() {
        $databaseManager = new sfDatabaseManager();
        $databaseManager->initialize();
        
        $this->languages = LanguagePeer::doSelect(new Criteria());
    }

    /**
     * Optimize product in all languages
     * @param integer $step
     * @return integer
     */
    public function optimize($step)
    {
        // get data from database
        $c = new Criteria();
        $c->setLimit($this->limit);
        $c->setOffset($step);
        $items = ProductPeer::doSelect($c);

        // build indexes for product for all languages
        foreach ($items as $item) {
            foreach ($this->languages as $lang) {
                stSimpleSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
                stAdvancedSearch::getInstance()->buildIndex($item, $lang->getOriginalLanguage());
            }
        }
        
        // increase steps
        $step+=count($items);
        return $step;
    }
    
    
    /**
     * Main loop in progressbar
     * @param integer $step
     * @return integer
     */
    public function updateOptimize($step) {
        sfLoader::loadPluginConfig();
        return $this->optimize($step);
    }
    
    /**
     * Initialize post update progressbar
     * @param sfEvent $event
     * @return unknown_type
     */
    public static function postInstall(sfEvent $event) {
        sfLoader::loadHelpers('stProgressBar');
        sfLoader::loadHelpers('Partial');
        $event->getSubject()->msg .= progress_bar('stSearch_optimize', 'stSearchOptimize', 'updateOptimize', ProductPeer::doCount(new Criteria()));
    }
    
    /**
     * Return title for progressbar
     * @return string
     */
    public function getTitle() 
    {
        return sfContext::getInstance()->getI18n()->__('Aktualizacja wyników wyszukiwania', array(), 'stSearchBackend');
    }
}