<?php
/** 
 * SOTESHOP/stSitemapPlugin 
 * 
 * Ten plik należy do aplikacji stSitemapPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stSitemapPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 13059 2011-05-25 13:38:24Z krzysiek $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>
 */

/** 
 * stSitemapBackend actions.
 *
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>  
 *
 * @package     stSitemapPlugin
 * @subpackage  actions
 */
class stSitemapBackendActions extends sfActions
{
    /** 
     * Wyświetla konfigurację modułu mapa strony
     */
    public function executeIndex()
    {    
        $this->config = stConfig::getInstance($this->getContext(), array(
        'sitemap_on' => stConfig::BOOL,
        'categories_on' => stConfig::BOOL,
        'webpages_on' => stConfig::BOOL,
        'producers_on' => stConfig::BOOL
        ));

        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
            $this->config->setFromRequest('sitemap');
            $this->config->save();
            
            /** 
             * usuwanie cache
             */
            stCacheManager::remove('sf_cache_partial/stSitemapFrontend/_link/*');
            
            $this->setFlash('notice', 'Twoje zmiany zostały zapisane');
        }
        $this->config->load();
    }
}
?>