<?php
/** 
 * SOTESHOP/stSitemapPlugin
 *
 * Ten plik należy do aplikacji stSitemapPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stSitemapPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stSitemapFrontendPluginActions.class.php 13059 2011-05-25 13:38:24Z krzysiek $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>
 */

/** 
 * stSitemapFrontend actions.
 *
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>
 *
 * @package     stSitemapPlugin
 * @subpackage  libs
 */
class stSitemapFrontendPluginActions extends stActions
{
    /**
     * Wyświetla elementy mapy strony
     */
    public function executeIndex()
    {
        
        $this->smarty = new stSmarty($this->getModuleName());
        $config = stConfig::getInstance(sfContext::getInstance(), 'stSitemapBackend');
        $config->load();

        $this->categories_on=$config->get('categories_on');
        $this->webpages_on=$config->get('webpages_on');
        $this->producers_on=$config->get('producers_on');

        if ($this->categories_on)
        {
            $this->categoryTrees = ProductHasCategoryPeer::doSelectRoots(new Criteria());
        }

        if ($this->producers_on)
        {
            $this->producers = ProducerPeer::doSelectActive();
        }

        if ($this->webpages_on)
        {
            $c = new Criteria();
            $c->add(WebpagePeer::ACTIVE,1);
            $this->webpages = WebpagePeer::doSelect($c);
        }

    }

}