<?php
use_helper('stUrl');
st_theme_use_stylesheet('stSitemapPlugin.css');
$category_template = '';
if ($categories_on)
{
    foreach ($categoryTrees as $categoryTree)
    {
        $smarty->assign('c_root_name', $categoryTree->getName());
        $dc = new Criteria();
        $dc->addAnd(CategoryPeer::RGT, $categoryTree->getLft(), Criteria::GREATER_THAN);
        $dc->addAnd(CategoryPeer::RGT, $categoryTree->getRgt(), Criteria::LESS_THAN);
        $dc->addAnd(CategoryPeer::SCOPE, $categoryTree->getScope());
        $descendants = ProductHasCategoryPeer::doSelectCategories($dc);
        $smarty->assign('c_descendants', $descendants);
        $category_template .= $smarty->fetch("sitemap_categories.html");
    }
    $smarty->clear_all_assign();
    $smarty->assign('category_template', $category_template);
}
if ($producers)
{
    $results_producer = array();
    foreach ($producers as $index => $producer)
    {
        $results_producer[$index]['instance'] = $producer;
        $producer_url = st_url_for('stProduct/producerList?url=' . $producer->getFriendlyUrl());
        $results_producer[$index]['link'] =  content_tag('a', $producer->getName(), array('href' => $producer_url, 'class' => 'product_name'));
    }
    $smarty->assign('results_producer', $results_producer);
}
$smarty->assign("webpages", $webpages);
$smarty->assign("webpages_on", $webpages_on);
$smarty->assign("producers_on", $producers_on);

$smarty->assign('webpages', $webpages);
$smarty->display("sitemap_index.html");
?>